/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login.ui;

import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import com.google.gct.login.ui.GoogleLoginUsersPanel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import icons.GoogleLoginIcons;
import java.awt.Component;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class GoogleLoginAction
extends AnAction
implements RightAlignedToolbarAction {
    private static final String SIGN_IN_MESSAGE = "Sign in to Google...";

    public void actionPerformed(AnActionEvent e) {
        GoogleLoginAction.showPopup(e);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        CredentialedUser activeUser = GoogleLogin.getInstance().getActiveUser();
        if (activeUser == null) {
            presentation.setText(SIGN_IN_MESSAGE);
            presentation.setIcon(GoogleLoginIcons.DEFAULT_USER_AVATAR);
        } else {
            presentation.setText(activeUser.getEmail());
            Image image = activeUser.getPicture();
            if (image == null) {
                presentation.setIcon(GoogleLoginIcons.DEFAULT_USER_AVATAR);
            } else {
                Image scaledImage = image.getScaledInstance(16, 16, 4);
                presentation.setIcon((Icon)new ImageIcon(scaledImage));
            }
        }
    }

    private static void showPopup(AnActionEvent event) {
        GoogleLoginUsersPanel usersPanel = new GoogleLoginUsersPanel();
        ComponentPopupBuilder popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)usersPanel, (JComponent)usersPanel.getList());
        JBPopup popup = popupBuilder.setCancelOnWindowDeactivation(true).createPopup();
        JComponent source = (JComponent)event.getInputEvent().getSource();
        popup.showUnderneathOf((Component)source);
    }
}

