/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeRequestUrl;
import com.google.common.base.Strings;
import com.google.gct.login.CancellableServerReceiver;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.CredentialedUserRoster;
import com.google.gct.login.GoogleLogin;
import com.google.gct.login.GoogleLoginKt;
import com.google.gct.login.GoogleLoginListener;
import com.google.gct.login.GoogleLoginPrefs;
import com.google.gct.login.GoogleLoginState;
import com.google.gct.login.GoogleLoginUtils;
import com.google.gct.login.IGoogleLoginCompletedCallback;
import com.google.gct.login.LoginContext;
import com.google.gct.login.OAuthScopeRegistry;
import com.google.gct.login.RequestCancelledException;
import com.google.gct.login.common.OAuthData;
import com.google.gct.login.common.OAuthDataStore;
import com.google.gct.login.common.UiFacade;
import com.google.gct.login.common.VerificationCodeHolder;
import com.google.gct.login.ui.GoogleLoginCopyAndPasteDialog;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.concurrency.AppExecutorUtil;
import icons.GoogleLoginIcons;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0003*+,B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J\b\u0010 \u001a\u00020\rH\u0002J\u001c\u0010!\u001a\u00020\u001c2\b\u0010\"\u001a\u0004\u0018\u00010\t2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u0015H\u0016J\b\u0010'\u001a\u00020\u001cH\u0002J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\tH\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/google/gct/login/GoogleLoginImpl;", "Lcom/google/gct/login/GoogleLogin;", "()V", "activeUser", "Lcom/google/gct/login/CredentialedUser;", "getActiveUser", "()Lcom/google/gct/login/CredentialedUser;", "allUsers", "", "", "getAllUsers", "()Ljava/util/Map;", "clientInfo", "Lcom/google/gct/login/GoogleLoginImpl$ClientInfo;", "currentProject", "Lcom/intellij/openapi/project/Project;", "getCurrentProject", "()Lcom/intellij/openapi/project/Project;", "dataStore", "Lcom/google/gct/login/GoogleLoginImpl$AndroidPreferencesOAuthDataStore;", "isLoggedIn", "", "()Z", "uiFacade", "Lcom/google/gct/login/GoogleLoginImpl$AndroidUiFacade;", "users", "Lcom/google/gct/login/CredentialedUserRoster;", "addLoginListenersFromExtensionPoints", "", "createGoogleLoginState", "Lcom/google/gct/login/GoogleLoginState;", "initializingUsers", "getClientInfo", "logIn", "message", "loginCompletedCallback", "Lcom/google/gct/login/IGoogleLoginCompletedCallback;", "logOut", "showPrompt", "logOutAllUsers", "setActiveUser", "userEmail", "AndroidPreferencesOAuthDataStore", "AndroidUiFacade", "ClientInfo", "google-login-as"})
public final class GoogleLoginImpl
implements GoogleLogin {
    @NotNull
    private final ClientInfo clientInfo = this.getClientInfo();
    @NotNull
    private final AndroidUiFacade uiFacade = new AndroidUiFacade(this.clientInfo.getId());
    @NotNull
    private final AndroidPreferencesOAuthDataStore dataStore = new AndroidPreferencesOAuthDataStore();
    @NotNull
    private final CredentialedUserRoster users = new CredentialedUserRoster();

    public GoogleLoginImpl() {
        AppExecutorUtil.getAppExecutorService().submit(new Runnable(){

            @Override
            public final void run() {
                block2: {
                    Unit unit;
                    this.addLoginListenersFromExtensionPoints();
                    String string = System.getenv("GOOGLE_LOGIN_USER");
                    if (string != null) {
                        String string2 = string;
                        GoogleLoginImpl googleLoginImpl = this;
                        String user = string2;
                        boolean bl = false;
                        GoogleLoginKt.access$getLOG().info("Added fake Google user: " + user);
                        googleLoginImpl.users.addUser(new CredentialedUser(user));
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    if (unit != null) break block2;
                    GoogleLoginImpl $this$run_u24lambda_u2d1 = this;
                    boolean bl = false;
                    $this$run_u24lambda_u2d1.dataStore.initializeUsers();
                }
            }
        });
    }

    @Override
    public boolean isLoggedIn() {
        return this.users.isActiveUserAvailable();
    }

    @Override
    @NotNull
    public Map<String, CredentialedUser> getAllUsers() {
        LinkedHashMap<String, CredentialedUser> linkedHashMap = this.users.getAllUsers();
        Intrinsics.checkNotNullExpressionValue(linkedHashMap, (String)"users.allUsers");
        return linkedHashMap;
    }

    @Override
    @Nullable
    public CredentialedUser getActiveUser() {
        return this.users.getActiveUser();
    }

    @Override
    public void setActiveUser(@NotNull String userEmail) {
        Intrinsics.checkNotNullParameter((Object)userEmail, (String)"userEmail");
        this.users.setActiveUser(userEmail);
    }

    @Override
    public void logIn(@Nullable String message, @Nullable IGoogleLoginCompletedCallback loginCompletedCallback) {
        CredentialedUser lastActiveUser = this.users.getActiveUser();
        this.users.removeActiveUser();
        GoogleLoginState state = this.createGoogleLoginState(false);
        Project project = this.getCurrentProject();
        new Task.Modal(state, message, this, loginCompletedCallback, lastActiveUser, project){
            private boolean loggedIn;
            final /* synthetic */ GoogleLoginState $state;
            final /* synthetic */ String $message;
            final /* synthetic */ GoogleLoginImpl this$0;
            final /* synthetic */ IGoogleLoginCompletedCallback $loginCompletedCallback;
            final /* synthetic */ CredentialedUser $lastActiveUser;
            {
                this.$state = $state;
                this.$message = $message;
                this.this$0 = $receiver;
                this.$loginCompletedCallback = $loginCompletedCallback;
                this.$lastActiveUser = $lastActiveUser;
                super($super_call_param$1, "Please sign in via the opened browser...", true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                if (!(indicator instanceof ProgressIndicatorEx)) {
                    return;
                }
                ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(this.this$0){
                    final /* synthetic */ GoogleLoginImpl this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void cancel() {
                        GoogleLoginImpl.access$getUiFacade$p(this.this$0).stop();
                        super.cancel();
                    }
                });
                this.loggedIn = this.$state != null && this.$state.logInWithLocalServer(this.$message);
            }

            public void onCancel() {
                this.notifyOnComplete();
            }

            public void onSuccess() {
                this.notifyOnComplete();
            }

            private final void notifyOnComplete() {
                block1: {
                    block0: {
                        if (!this.loggedIn) break block0;
                        GoogleLoginImpl.access$getUsers$p(this.this$0).addUser(new CredentialedUser(this.$state, new IGoogleLoginCompletedCallback(this.$loginCompletedCallback){
                            final /* synthetic */ IGoogleLoginCompletedCallback $loginCompletedCallback;
                            {
                                this.$loginCompletedCallback = $loginCompletedCallback;
                            }

                            public final void onLoginCompleted() {
                                block0: {
                                    IGoogleLoginCompletedCallback iGoogleLoginCompletedCallback = this.$loginCompletedCallback;
                                    if (iGoogleLoginCompletedCallback == null) break block0;
                                    iGoogleLoginCompletedCallback.onLoginCompleted();
                                }
                            }
                        }));
                        break block1;
                    }
                    this.restoreLastActiveUser();
                    IGoogleLoginCompletedCallback iGoogleLoginCompletedCallback = this.$loginCompletedCallback;
                    if (iGoogleLoginCompletedCallback == null) break block1;
                    iGoogleLoginCompletedCallback.onLoginCompleted();
                }
            }

            private final void restoreLastActiveUser() {
                if (this.$lastActiveUser != null) {
                    String string = this.$lastActiveUser.getEmail();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lastActiveUser.email");
                    this.this$0.setActiveUser(string);
                }
            }
        }.queue();
    }

    @Override
    public boolean logOut(boolean showPrompt) {
        CredentialedUser credentialedUser = this.users.getActiveUser();
        if (credentialedUser == null) {
            return false;
        }
        CredentialedUser activeUser = credentialedUser;
        boolean loggedOut = activeUser.getGoogleLoginState().logOut(showPrompt);
        if (loggedOut) {
            this.logOutAllUsers();
        }
        return loggedOut;
    }

    private final void logOutAllUsers() {
        Collection<CredentialedUser> collection = this.users.getAllUsers().values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"users.allUsers.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CredentialedUser user = (CredentialedUser)element$iv;
            boolean bl = false;
            user.getGoogleLoginState().logOut(false);
        }
        this.users.removeAllUsers();
    }

    private final void addLoginListenersFromExtensionPoints() {
        List list = GoogleLoginListener.EP_NAME.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"EP_NAME.extensionList");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GoogleLoginListener listener = (GoogleLoginListener)element$iv;
            boolean bl = false;
            this.users.addLoginListener(listener);
        }
    }

    private final GoogleLoginState createGoogleLoginState(boolean initializingUsers) {
        GoogleLoginState state = new GoogleLoginState(this.clientInfo.getId(), this.clientInfo.getInfo(), OAuthScopeRegistry.getScopes(), new AndroidPreferencesOAuthDataStore(), this.uiFacade);
        return initializingUsers && !state.isLoggedIn() ? (GoogleLoginState)null : state;
    }

    private final Project getCurrentProject() {
        Window window = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (window == null) {
            return null;
        }
        Window activeWindow = window;
        return (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)activeWindow));
    }

    private final ClientInfo getClientInfo() {
        String id = LoginContext.getId();
        String info = LoginContext.getInfo();
        CharSequence charSequence = id;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !((charSequence = (CharSequence)info) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
            Intrinsics.checkNotNullExpressionValue((Object)info, (String)"info");
            return new ClientInfo(id, info);
        }
        throw new IllegalStateException("The client information for Android Studio was not found");
    }

    public static final /* synthetic */ AndroidUiFacade access$getUiFacade$p(GoogleLoginImpl $this) {
        return $this.uiFacade;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/google/gct/login/GoogleLoginImpl$ClientInfo;", "", "id", "", "info", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getInfo", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "google-login-as"})
    private static final class ClientInfo {
        @NotNull
        private final String id;
        @NotNull
        private final String info;

        public ClientInfo(@NotNull String id, @NotNull String info) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            this.id = id;
            this.info = info;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getInfo() {
            return this.info;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.info;
        }

        @NotNull
        public final ClientInfo copy(@NotNull String id, @NotNull String info) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return new ClientInfo(id, info);
        }

        public static /* synthetic */ ClientInfo copy$default(ClientInfo clientInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = clientInfo.id;
            }
            if ((n & 2) != 0) {
                string2 = clientInfo.info;
            }
            return clientInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ClientInfo(id=" + this.id + ", info=" + this.info + ")";
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = result * 31 + this.info.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClientInfo)) {
                return false;
            }
            ClientInfo clientInfo = (ClientInfo)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)clientInfo.id)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.info, (Object)clientInfo.info);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00032\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0016J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0006\u0010\u0017\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/google/gct/login/GoogleLoginImpl$AndroidUiFacade;", "Lcom/google/gct/login/common/UiFacade;", "clientId", "", "(Ljava/lang/String;)V", "receiver", "Lcom/google/gct/login/CancellableServerReceiver;", "askYesOrNo", "", "title", "message", "logErrorAndDisplayDialog", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "notifyStatusIndicator", "obtainVerificationCodeFromExternalUserInteraction", "Lcom/google/gct/login/common/VerificationCodeHolder;", "obtainVerificationCodeFromUserInteraction", "authCodeRequestUrl", "Lcom/google/api/client/googleapis/auth/oauth2/GoogleAuthorizationCodeRequestUrl;", "showErrorDialog", "stop", "google-login-as"})
    private static final class AndroidUiFacade
    implements UiFacade {
        @NotNull
        private final String clientId;
        @Nullable
        private volatile CancellableServerReceiver receiver;

        public AndroidUiFacade(@NotNull String clientId) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            this.clientId = clientId;
        }

        @Override
        @Nullable
        public String obtainVerificationCodeFromUserInteraction(@NotNull String title, @NotNull GoogleAuthorizationCodeRequestUrl authCodeRequestUrl) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)authCodeRequestUrl, (String)"authCodeRequestUrl");
            GoogleLoginCopyAndPasteDialog dialog = new GoogleLoginCopyAndPasteDialog(authCodeRequestUrl, "Google Login");
            dialog.show();
            return dialog.getExitCode() == 1 ? (String)null : Strings.emptyToNull((String)dialog.getVerificationCode());
        }

        public final void stop() {
            CancellableServerReceiver localreceiver = this.receiver;
            if (localreceiver != null) {
                try {
                    localreceiver.stop();
                }
                catch (IOException e) {
                    this.logErrorAndDisplayDialog("Google Login", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public VerificationCodeHolder obtainVerificationCodeFromExternalUserInteraction(@Nullable String title) {
            String string;
            CancellableServerReceiver cancellableServerReceiver = new CancellableServerReceiver();
            Object it = cancellableServerReceiver;
            boolean bl = false;
            this.receiver = it;
            CancellableServerReceiver serverReceiver = cancellableServerReceiver;
            try {
                it = serverReceiver.getRedirectUri();
            }
            catch (IOException e) {
                String string2 = title;
                if (string2 == null) {
                    string2 = "Google Login";
                }
                this.logErrorAndDisplayDialog(string2, e);
                return null;
            }
            Object redirectUrl = it;
            AuthorizationCodeRequestUrl authCodeRequestUrl = new AuthorizationCodeRequestUrl("https://accounts.google.com/o/oauth2/auth", this.clientId).setRedirectUri((String)redirectUrl).setScopes((Collection)OAuthScopeRegistry.getScopes());
            BrowserUtil.browse((String)authCodeRequestUrl.build());
            try {
                string = serverReceiver.waitForCode();
            }
            catch (RequestCancelledException e) {
                GoogleLoginUtils.showErrorDialog("Login cancelled.", "Google Login");
                VerificationCodeHolder verificationCodeHolder = null;
                return verificationCodeHolder;
            }
            catch (IOException e) {
                String string3 = title;
                if (string3 == null) {
                    string3 = "Google Login";
                }
                this.logErrorAndDisplayDialog(string3, e);
                VerificationCodeHolder verificationCodeHolder = null;
                return verificationCodeHolder;
            }
            finally {
                this.receiver = null;
            }
            String verificationCode = string;
            return new VerificationCodeHolder(verificationCode, (String)redirectUrl);
        }

        @Override
        public void showErrorDialog(@NotNull String title, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Messages.showErrorDialog((String)message, (String)title);
        }

        @Override
        public boolean askYesOrNo(@NotNull String title, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Object updatedMessage = message;
            if (Intrinsics.areEqual((Object)message, (Object)"Are you sure you want to sign out?")) {
                updatedMessage = (String)updatedMessage + " This will sign out all logged in users.";
            }
            return Messages.showYesNoDialog((String)updatedMessage, (String)title, (Icon)GoogleLoginIcons.GOOGLE_FAVICON) == 0;
        }

        @Override
        public void notifyStatusIndicator() {
        }

        private final void logErrorAndDisplayDialog(String title, Exception exception) {
            GoogleLoginKt.access$getLOG().error(exception.getMessage(), (Throwable)exception);
            String string = exception.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            GoogleLoginUtils.showErrorDialog(string, title);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0006\u0010\u0005\u001a\u00020\u0004J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/google/gct/login/GoogleLoginImpl$AndroidPreferencesOAuthDataStore;", "Lcom/google/gct/login/common/OAuthDataStore;", "(Lcom/google/gct/login/GoogleLoginImpl;)V", "clearStoredOAuthData", "", "initializeUsers", "loadOAuthData", "Lcom/google/gct/login/common/OAuthData;", "saveOAuthData", "credentials", "google-login-as"})
    private final class AndroidPreferencesOAuthDataStore
    implements OAuthDataStore {
        @Override
        public void saveOAuthData(@NotNull OAuthData credentials) {
            Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
            GoogleLoginPrefs.saveOAuthData(credentials);
        }

        @Override
        @NotNull
        public OAuthData loadOAuthData() {
            OAuthData oAuthData = GoogleLoginPrefs.loadOAuthData();
            Intrinsics.checkNotNullExpressionValue((Object)oAuthData, (String)"loadOAuthData()");
            return oAuthData;
        }

        @Override
        public void clearStoredOAuthData() {
            GoogleLoginPrefs.clearStoredOAuthData();
        }

        /*
         * WARNING - void declaration
         */
        public final void initializeUsers() {
            void $this$forEach$iv;
            String activeUserString = null;
            activeUserString = GoogleLoginPrefs.getActiveUser();
            List<String> list = GoogleLoginPrefs.getStoredUsers();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getStoredUsers()");
            List<String> allUsers = list;
            Object removedUsers = null;
            removedUsers = "";
            Iterable iterable = allUsers;
            GoogleLoginImpl googleLoginImpl = GoogleLoginImpl.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String user = (String)element$iv;
                boolean bl = false;
                googleLoginImpl.users.addUser(new CredentialedUser(user));
                GoogleLoginState delegate = googleLoginImpl.createGoogleLoginState(true);
                if (delegate == null) {
                    removedUsers = removedUsers + user + ", ";
                    if (Intrinsics.areEqual((Object)user, (Object)activeUserString)) {
                        activeUserString = null;
                    }
                    googleLoginImpl.users.removeUser(user);
                    continue;
                }
                googleLoginImpl.users.addUser(new CredentialedUser(delegate, null));
            }
            if (activeUserString == null) {
                GoogleLoginImpl.this.users.removeActiveUser();
            } else {
                try {
                    GoogleLoginImpl.this.users.setActiveUser(activeUserString);
                }
                catch (IllegalArgumentException ex) {
                    GoogleLoginKt.access$getLOG().warn("Error while initiating users", (Throwable)ex);
                    GoogleLoginImpl.this.users.removeActiveUser();
                }
            }
            if (!(((CharSequence)removedUsers).length() == 0)) {
                GoogleLoginKt.access$getLOG().info("The following user(s) had expired authentication scopes: " + removedUsers + " and have been logged out.");
            }
        }
    }
}

