/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader.events;

import com.intellij.internal.statistic.uploader.events.ExternalSystemEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEventType;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ExternalUploadSendEvent
extends ExternalSystemEvent {
    private final int mySucceed;
    private final int myFailed;
    private final int myTotal;
    @NotNull
    private final List<String> mySuccessfullySentFiles;
    @NotNull
    private final List<Integer> myErrors;

    public ExternalUploadSendEvent(long timestamp, int succeed, int failed, int total, @NotNull List<String> successfullySentFiles, @NotNull List<Integer> errors, @NotNull String recorder) {
        super(ExternalSystemEventType.SEND, timestamp, recorder);
        this.mySucceed = succeed;
        this.myFailed = failed;
        this.myTotal = total;
        this.mySuccessfullySentFiles = successfullySentFiles;
        this.myErrors = errors;
    }

    public int getSucceed() {
        return this.mySucceed;
    }

    public int getFailed() {
        return this.myFailed;
    }

    public int getTotal() {
        return this.myTotal;
    }

    @NotNull
    public List<String> getSuccessfullySentFiles() {
        return this.mySuccessfullySentFiles;
    }

    @NotNull
    public List<Integer> getErrors() {
        return this.myErrors;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalUploadSendEvent event = (ExternalUploadSendEvent)o;
        return this.mySucceed == event.mySucceed && this.myFailed == event.myFailed && this.myTotal == event.myTotal && Objects.equals(this.mySuccessfullySentFiles, event.mySuccessfullySentFiles) && Objects.equals(this.myErrors, event.myErrors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mySucceed, this.myFailed, this.myTotal, this.mySuccessfullySentFiles, this.myErrors);
    }
}

