/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader.events;

import com.intellij.internal.statistic.config.StatisticsStringUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventEscaper;
import com.intellij.internal.statistic.uploader.events.ExternalSystemErrorEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEvent;
import com.intellij.internal.statistic.uploader.events.ExternalSystemEventType;
import com.intellij.internal.statistic.uploader.events.ExternalUploadFinishedEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadSendEvent;
import com.intellij.internal.statistic.uploader.events.ExternalUploadStartedEvent;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalSystemEventSerializer {
    @NotNull
    public static String serialize(@NotNull ExternalSystemEvent event) {
        String prefix = event.getTimestamp() + " " + event.getEventType().name() + " " + event.getRecorderId();
        if (event instanceof ExternalUploadFinishedEvent) {
            ExternalUploadFinishedEvent failed = (ExternalUploadFinishedEvent)event;
            if (StatisticsStringUtil.isNotEmpty(failed.getError())) {
                return prefix + " " + StatisticsEventEscaper.escape((String)failed.getError());
            }
            return prefix;
        }
        if (event instanceof ExternalUploadSendEvent) {
            ExternalUploadSendEvent finished = (ExternalUploadSendEvent)event;
            String hashedFiles = ExternalSystemEventSerializer.filesToString(finished.getSuccessfullySentFiles());
            String errors = ExternalSystemEventSerializer.errorsToString(finished.getErrors());
            return prefix + " " + finished.getSucceed() + " " + finished.getFailed() + " " + finished.getTotal() + " " + hashedFiles + " " + errors;
        }
        if (event instanceof ExternalSystemErrorEvent) {
            ExternalSystemErrorEvent error = (ExternalSystemErrorEvent)event;
            return prefix + " " + StatisticsEventEscaper.escape((String)error.getEvent()) + " " + StatisticsEventEscaper.escape((String)error.getErrorClass());
        }
        return prefix;
    }

    @Nullable
    public static ExternalSystemEvent deserialize(@NotNull String line, int version) {
        String recorderId;
        int payloadStartIndex = version == 0 ? 2 : 3;
        String[] parts = line.split(" ");
        int length = parts.length;
        if (length < payloadStartIndex) {
            return null;
        }
        ExternalSystemEventType type = ExternalSystemEventType.parse(parts[1]);
        if (type == null) {
            return null;
        }
        long timestamp = ExternalSystemEventSerializer.parseLong(parts[0]);
        String string = recorderId = version == 0 ? "FUS" : parts[2];
        if (type == ExternalSystemEventType.FINISHED) {
            String error = length > payloadStartIndex ? parts[payloadStartIndex].trim() : null;
            return new ExternalUploadFinishedEvent(timestamp, error, recorderId);
        }
        if (type == ExternalSystemEventType.SEND && length > payloadStartIndex + 2) {
            int succeed = ExternalSystemEventSerializer.parseInt(parts[payloadStartIndex]);
            int failed = ExternalSystemEventSerializer.parseInt(parts[payloadStartIndex + 1]);
            int total = ExternalSystemEventSerializer.parseInt(parts[payloadStartIndex + 2]);
            List<String> sentFiles = length > payloadStartIndex + 3 ? ExternalSystemEventSerializer.parseSentFiles(parts[payloadStartIndex + 3]) : Collections.emptyList();
            List<Integer> errors = length > payloadStartIndex + 4 ? ExternalSystemEventSerializer.parseErrors(parts[payloadStartIndex + 4]) : Collections.emptyList();
            return new ExternalUploadSendEvent(timestamp, succeed, failed, total, sentFiles, errors, recorderId);
        }
        if (type == ExternalSystemEventType.STARTED && length == payloadStartIndex) {
            return new ExternalUploadStartedEvent(timestamp, recorderId);
        }
        if (type == ExternalSystemEventType.ERROR && length == payloadStartIndex + 2) {
            String event = parts[payloadStartIndex].trim();
            String errorClass = parts[payloadStartIndex + 1].trim();
            return new ExternalSystemErrorEvent(timestamp, event, errorClass, recorderId);
        }
        return null;
    }

    @NotNull
    private static List<String> parseSentFiles(@NotNull String part) {
        return ExternalSystemEventSerializer.parseValues(part, value -> new String(Base64.getDecoder().decode((String)value), StandardCharsets.UTF_8));
    }

    @NotNull
    private static List<Integer> parseErrors(@NotNull String part) {
        return ExternalSystemEventSerializer.parseValues(part, value -> ExternalSystemEventSerializer.parseInt(value));
    }

    @NotNull
    private static <V> List<V> parseValues(@NotNull String part, @NotNull Function<? super String, ? extends V> processor) {
        try {
            if (part.startsWith("[") && part.endsWith("]")) {
                String unwrappedPart = part.substring(1, part.length() - 1);
                String[] values = unwrappedPart.split(",");
                return Arrays.stream(values).filter(value -> !value.isEmpty()).map(processor).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
        catch (IllegalArgumentException e) {
            return Collections.emptyList();
        }
    }

    @NotNull
    private static String filesToString(@NotNull List<String> files) {
        return ExternalSystemEventSerializer.valuesToString(files, path -> Base64.getEncoder().encodeToString(path.getBytes(StandardCharsets.UTF_8)));
    }

    @NotNull
    private static String errorsToString(@NotNull List<Integer> errors) {
        return ExternalSystemEventSerializer.valuesToString(errors, error -> String.valueOf(error));
    }

    private static <V> String valuesToString(@NotNull List<? extends V> values, @NotNull Function<? super V, String> processor) {
        return values.stream().map(processor).collect(Collectors.joining(",", "[", "]"));
    }

    private static int parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static long parseLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }
}

