/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader.events;

import com.intellij.internal.statistic.uploader.events.ExternalSystemEventType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExternalSystemEvent {
    public static final String ALL_RECORDERS = "ALL";
    private final long myTimestamp;
    private final ExternalSystemEventType myEventType;
    @NotNull
    private final String myRecorderId;

    public ExternalSystemEvent(@NotNull ExternalSystemEventType eventType, long timestamp, @Nullable String recorderId) {
        this.myTimestamp = timestamp;
        this.myEventType = eventType;
        this.myRecorderId = recorderId != null ? recorderId : ALL_RECORDERS;
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    public ExternalSystemEventType getEventType() {
        return this.myEventType;
    }

    @NotNull
    public String getRecorderId() {
        return this.myRecorderId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalSystemEvent event = (ExternalSystemEvent)o;
        return this.myTimestamp == event.myTimestamp && this.myEventType == event.myEventType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myTimestamp, this.myEventType});
    }
}

