/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader;

import com.intellij.internal.statistic.config.StatisticsStringUtil;
import com.intellij.internal.statistic.eventLog.EventLogSendConfig;
import com.intellij.internal.statistic.eventLog.FilesToSendProvider;
import com.intellij.internal.statistic.eventLog.MachineId;
import com.intellij.internal.statistic.eventLog.config.EventLogFileListProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class EventLogExternalSendConfig
implements EventLogSendConfig {
    @NotNull
    private final String myRecorderId;
    private final String myDeviceId;
    private final int myBucket;
    private final MachineId myMachineId;
    private final FilesToSendProvider myFilesProvider;
    private final boolean myIsSendEnabled;

    public EventLogExternalSendConfig(@NotNull String recorder, @NotNull String deviceId, int bucket, @NotNull MachineId machineId, @NotNull List<String> logs, boolean isSendEnabled) {
        this.myRecorderId = recorder;
        this.myDeviceId = deviceId;
        this.myBucket = bucket;
        this.myMachineId = machineId;
        this.myFilesProvider = new EventLogFileListProvider(logs);
        this.myIsSendEnabled = isSendEnabled;
    }

    @Override
    @NotNull
    public String getRecorderId() {
        return this.myRecorderId;
    }

    @Override
    @NotNull
    public String getDeviceId() {
        return this.myDeviceId;
    }

    @Override
    public int getBucket() {
        return this.myBucket;
    }

    @Override
    @NotNull
    public MachineId getMachineId() {
        return this.myMachineId;
    }

    @Override
    public boolean isSendEnabled() {
        return this.myIsSendEnabled;
    }

    @Override
    @NotNull
    public FilesToSendProvider getFilesToSendProvider() {
        return this.myFilesProvider;
    }

    public static List<EventLogExternalSendConfig> parseSendConfigurations(@NotNull Map<String, String> options, @NotNull ParseConfigurationExceptionHandler errorHandler) {
        String recorder = options.get("--recorders");
        if (recorder == null) {
            return Collections.emptyList();
        }
        String[] recorderIds = recorder.split(";");
        ArrayList<EventLogExternalSendConfig> configurations = new ArrayList<EventLogExternalSendConfig>();
        for (String recorderId : recorderIds) {
            try {
                configurations.add(EventLogExternalSendConfig.parseSendConfiguration(recorderId, options));
            }
            catch (ParseSendConfigurationException e) {
                errorHandler.handle(recorderId, e);
            }
        }
        return configurations;
    }

    private static EventLogExternalSendConfig parseSendConfiguration(@NotNull String recorderId, @NotNull Map<String, String> options) throws ParseSendConfigurationException {
        String recorderLowerCase = recorderId.toLowerCase(Locale.ENGLISH);
        String deviceOption = options.get("--device-" + recorderLowerCase);
        if (deviceOption == null) {
            throw new ParseSendConfigurationException(ParseErrorType.NO_DEVICE_ID);
        }
        String machineIdOption = options.get("--machine-" + recorderLowerCase);
        if (machineIdOption == null) {
            throw new ParseSendConfigurationException(ParseErrorType.NO_MACHINE_ID);
        }
        int bucket = EventLogExternalSendConfig.getIntOption("--bucket-" + recorderLowerCase, options);
        if (bucket < 0 || bucket >= 256) {
            throw new ParseSendConfigurationException(ParseErrorType.INVALID_BUCKET);
        }
        int idRevisionOption = EventLogExternalSendConfig.getIntOption("--id-revision-" + recorderLowerCase, options);
        if (idRevisionOption < 0) {
            throw new ParseSendConfigurationException(ParseErrorType.INVALID_REVISION);
        }
        String logs = options.get("--files-" + recorderLowerCase);
        if (logs == null) {
            throw new ParseSendConfigurationException(ParseErrorType.NO_LOG_FILES);
        }
        List<String> files = StatisticsStringUtil.split(logs, File.pathSeparatorChar);
        return new EventLogExternalSendConfig(recorderId, deviceOption, bucket, new MachineId(machineIdOption, idRevisionOption), files, true);
    }

    private static int getIntOption(@NotNull String name, @NotNull Map<String, String> options) {
        try {
            String option = options.get(name);
            return option != null ? Integer.parseInt(option) : -1;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static interface ParseConfigurationExceptionHandler {
        public void handle(@NotNull String var1, @NotNull ParseSendConfigurationException var2);
    }

    public static enum ParseErrorType {
        NO_DEVICE_ID,
        NO_MACHINE_ID,
        INVALID_BUCKET,
        INVALID_REVISION,
        NO_LOG_FILES;

    }

    public static class ParseSendConfigurationException
    extends Exception {
        private final ParseErrorType myType;

        public ParseSendConfigurationException(@NotNull ParseErrorType type) {
            this.myType = type;
        }

        @NotNull
        public ParseErrorType getType() {
            return this.myType;
        }
    }
}

