/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.updater;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.internal.statistic.service.fus.collectors.FUStateUsagesLogger;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

final class StatisticsStateCollectorsScheduler
implements ApplicationInitializedListener {
    public static final int LOG_APPLICATION_STATES_INITIAL_DELAY_IN_MIN = 10;
    public static final int LOG_APPLICATION_STATES_DELAY_IN_MIN = 1440;
    private static final int LOG_APPLICATION_STATE_SMART_MODE_DELAY_IN_SECONDS = 60;
    public static final int LOG_PROJECTS_STATES_INITIAL_DELAY_IN_MIN = 5;
    public static final int LOG_PROJECTS_STATES_DELAY_IN_MIN = 720;
    private static final String REDUCE_DELAY_FLAG_KEY = "fus.internal.reduce.initial.delay";
    private final Map<Project, Future<?>> persistStatisticsSessionsMap = Collections.synchronizedMap(new HashMap());
    private final AtomicBoolean allowExecution = new AtomicBoolean(true);

    StatisticsStateCollectorsScheduler() {
    }

    public void componentsInitialized() {
        this.runStatesLogging();
    }

    private void runStatesLogging() {
        if (!StatisticsUploadAssistant.isSendAllowed()) {
            return;
        }
        JobScheduler.getScheduler().schedule(() -> this.allowExecution.set(false), 10L, TimeUnit.MINUTES);
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> FUStateUsagesLogger.create().logApplicationStates(), 10L, 1440L, TimeUnit.MINUTES);
        ApplicationManager.getApplication().getMessageBus().simpleConnect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (LightEdit.owns((Project)project)) {
                    return;
                }
                DumbService.getInstance((Project)project).runWhenSmart(() -> {
                    boolean reduceInitialDelay = Boolean.parseBoolean(System.getProperty(StatisticsStateCollectorsScheduler.REDUCE_DELAY_FLAG_KEY));
                    ScheduledFuture<?> future = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> FUStateUsagesLogger.create().logProjectStates(project, (ProgressIndicator)new EmptyProgressIndicator()), reduceInitialDelay ? 0L : 5L, 720L, TimeUnit.MINUTES);
                    StatisticsStateCollectorsScheduler.this.persistStatisticsSessionsMap.put(project, future);
                });
                if (StatisticsStateCollectorsScheduler.this.allowExecution.get()) {
                    DumbService.getInstance((Project)project).runWhenSmart(() -> {
                        if (ContainerUtil.exists((Object[])ProjectManager.getInstance().getOpenProjects(), p -> !p.isDisposed() && p.isInitialized() && DumbService.getInstance((Project)p).isDumb())) {
                            return;
                        }
                        StatisticsStateCollectorsScheduler.this.scheduleLogging();
                    });
                }
            }

            public void projectClosed(@NotNull Project project) {
                Future<?> future = StatisticsStateCollectorsScheduler.this.persistStatisticsSessionsMap.remove(project);
                if (future != null) {
                    future.cancel(true);
                }
            }
        });
    }

    private void scheduleLogging() {
        if (this.allowExecution.getAndSet(false)) {
            JobScheduler.getScheduler().schedule(() -> FUStateUsagesLogger.create().logApplicationStatesOnStartup(), 60L, TimeUnit.SECONDS);
        }
    }
}

