/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.updater;

import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.ide.StatisticsNotificationManager;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogMigration;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.connection.StatisticsService;
import com.intellij.internal.statistic.eventLog.uploader.EventLogExternalUploader;
import com.intellij.internal.statistic.eventLog.validator.IntellijSensitiveDataValidator;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

@InternalIgnoreDependencyViolation
final class StatisticsJobsScheduler
implements ApplicationInitializedListener {
    private static final int SEND_STATISTICS_INITIAL_DELAY_IN_MILLIS = 300000;
    private static final int CHECK_STATISTICS_PROVIDERS_DELAY_IN_MIN = 1;
    private static final int CHECK_EXTERNAL_UPLOADER_DELAY_IN_MIN = 3;
    private static final String REDUCE_DELAY_FLAG_KEY = "fus.internal.reduce.initial.delay";

    StatisticsJobsScheduler() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw ExtensionNotApplicableException.create();
        }
    }

    public void componentsInitialized() {
        StatisticsNotificationManager notificationManager = (StatisticsNotificationManager)ApplicationManager.getApplication().getService(StatisticsNotificationManager.class);
        if (notificationManager != null) {
            notificationManager.showNotificationIfNeeded();
        }
        StatisticsJobsScheduler.checkPreviousExternalUploadResult();
        StatisticsJobsScheduler.runEventLogStatisticsService();
        StatisticsJobsScheduler.runValidationRulesUpdate();
        StatisticsEventLogMigration.performMigration();
    }

    private static void runValidationRulesUpdate() {
        int initialDelay = Boolean.parseBoolean(System.getProperty(REDUCE_DELAY_FLAG_KEY)) ? 0 : 3;
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> {
            List<StatisticsEventLoggerProvider> providers = StatisticsEventLogProviderUtil.getEventLogProviders();
            for (StatisticsEventLoggerProvider provider : providers) {
                if (!provider.isRecordEnabled()) continue;
                IntellijSensitiveDataValidator.getInstance(provider.getRecorderId()).update();
            }
        }, initialDelay, 180L, TimeUnit.MINUTES);
    }

    private static void checkPreviousExternalUploadResult() {
        JobScheduler.getScheduler().schedule(() -> {
            List providers = ContainerUtil.filter(StatisticsEventLogProviderUtil.getEventLogProviders(), provider -> provider.getSendLogsOnIdeClose());
            EventLogExternalUploader.INSTANCE.logPreviousExternalUploadResult(providers);
        }, 3L, TimeUnit.MINUTES);
    }

    private static void runEventLogStatisticsService() {
        JobScheduler.getScheduler().schedule(() -> {
            List<StatisticsEventLoggerProvider> providers = StatisticsEventLogProviderUtil.getEventLogProviders();
            for (StatisticsEventLoggerProvider provider : providers) {
                if (!provider.isSendEnabled()) continue;
                StatisticsService statisticsService = StatisticsUploadAssistant.getEventLogStatisticsService(provider.getRecorderId());
                StatisticsJobsScheduler.runStatisticsServiceWithDelay(statisticsService, provider.getSendFrequencyMs());
            }
        }, 1L, TimeUnit.MINUTES);
    }

    private static void runStatisticsServiceWithDelay(@NotNull StatisticsService statisticsService, long delayInMs) {
        JobScheduler.getScheduler().scheduleWithFixedDelay(statisticsService::send, 300000L, delayInMs, TimeUnit.MILLISECONDS);
    }
}

