/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FUStatisticsPersistence {
    private static final Logger LOG = Logger.getInstance(FUStatisticsPersistence.class);
    private static final String LEGACY_PERSISTENCE_STATE_FILE = "fus-previous-state.data";
    private static final String PERSISTENCE_STATE_FILE = "fus-state.data";
    private static final String SENT_DATA_FILE = "fus-sent-data.json";
    public static final String FUS_CACHE_PATH = "fus-sessions";

    public static void clearLegacyStates() {
        FUStatisticsPersistence.deleteCaches(FUStatisticsPersistence.getSentDataFile());
        FUStatisticsPersistence.deleteCaches(FUStatisticsPersistence.getLegacyStateFile());
        FUStatisticsPersistence.deleteCaches(FUStatisticsPersistence.getPersistenceStateFile());
        FUStatisticsPersistence.deleteCaches(FUStatisticsPersistence.getStatisticsCacheDirectory());
        FUStatisticsPersistence.deleteCaches(FUStatisticsPersistence.getStatisticsLegacyCacheDirectory());
        FUStatisticsPersistence.deleteSystemEventIdsFiles();
    }

    private static void deleteSystemEventIdsFiles() {
        try {
            File[] files = EventLogConfiguration.getInstance().getEventLogSettingsPath().toFile().listFiles((directory, name) -> name.endsWith("_system_event_id"));
            if (files != null) {
                for (File file : files) {
                    FileUtil.delete((File)file);
                }
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
    }

    private static void deleteCaches(@Nullable File dir) {
        if (dir != null && dir.exists()) {
            try {
                boolean delete = FileUtil.delete((File)dir);
                if (!delete) {
                    LOG.info("Failed deleting legacy caches");
                }
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
    }

    @NotNull
    public static File getStatisticsCacheDirectory() {
        return PathManager.getConfigDir().resolve("fus-sessions/").toFile();
    }

    @NotNull
    public static File getStatisticsLegacyCacheDirectory() {
        return Paths.get(PathManager.getSystemPath(), new String[0]).resolve(FUS_CACHE_PATH).toFile();
    }

    @NotNull
    public static File getPersistenceStateFile() {
        return FUStatisticsPersistence.getFileInStatisticsCacheDirectory(PERSISTENCE_STATE_FILE);
    }

    @NotNull
    private static File getLegacyStateFile() {
        return FUStatisticsPersistence.getFileInStatisticsCacheDirectory(LEGACY_PERSISTENCE_STATE_FILE);
    }

    @NotNull
    private static File getFileInStatisticsCacheDirectory(@NotNull String fileName) {
        return new File(FUStatisticsPersistence.getStatisticsCacheDirectory(), "/" + fileName);
    }

    @NotNull
    public static File getSentDataFile() {
        return FUStatisticsPersistence.getFileInStatisticsCacheDirectory(SENT_DATA_FILE);
    }
}

