/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.AllowedDuringStartupCollector;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class FUStateUsagesLogger
implements UsagesCollectorConsumer {
    private static final Logger LOG = Logger.getInstance(FUStateUsagesLogger.class);
    private static final Object LOCK = new Object();

    public static FUStateUsagesLogger create() {
        return new FUStateUsagesLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompletableFuture<Void> logProjectStates(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        Object object = LOCK;
        synchronized (object) {
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            HashMap<String, StatisticsEventLogger> recorderLoggers = new HashMap<String, StatisticsEventLogger>();
            for (ProjectUsagesCollector usagesCollector : ProjectUsagesCollector.getExtensions(this)) {
                if (!PluginInfoDetectorKt.getPluginInfo(usagesCollector.getClass()).isDevelopedByJetBrains()) {
                    LOG.warn("Skip '" + usagesCollector.getGroupId() + "' because its registered in a third-party plugin");
                    continue;
                }
                CancellablePromise<? extends Set<MetricEvent>> metrics = usagesCollector.getMetrics(project, indicator);
                futures.add(FUStateUsagesLogger.logMetricsOrError(project, recorderLoggers, usagesCollector, metrics));
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        }
    }

    @NotNull
    public CompletableFuture<Void> logApplicationStates() {
        return this.logApplicationStates(false);
    }

    @NotNull
    public CompletableFuture<Void> logApplicationStatesOnStartup() {
        return this.logApplicationStates(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private CompletableFuture<Void> logApplicationStates(boolean onStartup) {
        Object object = LOCK;
        synchronized (object) {
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            HashMap<String, StatisticsEventLogger> recorderLoggers = new HashMap<String, StatisticsEventLogger>();
            for (ApplicationUsagesCollector usagesCollector : ApplicationUsagesCollector.getExtensions(this)) {
                if (onStartup && !(usagesCollector instanceof AllowedDuringStartupCollector)) continue;
                if (!PluginInfoDetectorKt.getPluginInfo(usagesCollector.getClass()).isDevelopedByJetBrains()) {
                    LOG.warn("Skip '" + usagesCollector.getGroupId() + "' because its registered in a third-party plugin");
                    continue;
                }
                Promise metrics = Promises.resolvedPromise(usagesCollector.getMetrics());
                futures.add(FUStateUsagesLogger.logMetricsOrError(null, recorderLoggers, usagesCollector, (Promise<? extends Set<MetricEvent>>)metrics));
            }
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        }
    }

    private static CompletableFuture<Void> logMetricsOrError(@Nullable Project project, @NotNull Map<String, StatisticsEventLogger> recorderLoggers, @NotNull FeatureUsagesCollector usagesCollector, @NotNull Promise<? extends Set<MetricEvent>> metrics) {
        String recorder;
        StatisticsEventLogger logger2;
        EventLogGroup group = usagesCollector.getGroup();
        if (group == null) {
            group = new EventLogGroup(usagesCollector.getGroupId(), usagesCollector.getVersion());
        }
        if ((logger2 = recorderLoggers.get(recorder = group.getRecorder())) == null) {
            logger2 = StatisticsEventLogProviderUtil.getEventLogProvider(recorder).getLogger();
            recorderLoggers.put(recorder, logger2);
        }
        try {
            return FUStateUsagesLogger.logUsagesAsStateEvents(project, group, metrics, logger2);
        }
        catch (Throwable th) {
            if (project != null && project.isDisposed()) {
                return CompletableFuture.completedFuture(null);
            }
            FeatureUsageData data = new FeatureUsageData().addProject(project);
            return logger2.logAsync(group, "invocation.failed", data.build(), true);
        }
    }

    @NotNull
    private static CompletableFuture<Void> logUsagesAsStateEvents(@Nullable Project project, @NotNull EventLogGroup group, @NotNull Promise<? extends Set<MetricEvent>> metricsPromise, @NotNull StatisticsEventLogger logger2) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        metricsPromise.onSuccess(metrics -> {
            if (project != null && project.isDisposed()) {
                return;
            }
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            if (!metrics.isEmpty()) {
                FeatureUsageData groupData = FUStateUsagesLogger.addProject(project);
                for (MetricEvent metric : metrics) {
                    FeatureUsageData data = FUStateUsagesLogger.mergeWithEventData(groupData, metric.getData());
                    Map<Object, Object> eventData = data != null ? data.build() : Collections.emptyMap();
                    futures.add(logger2.logAsync(group, metric.getEventId(), eventData, true));
                }
            }
            futures.add(logger2.logAsync(group, "invoked", new FeatureUsageData().addProject(project).build(), true));
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete((result, throwable) -> future.complete(null));
        });
        return future;
    }

    @Nullable
    private static FeatureUsageData addProject(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        return new FeatureUsageData().addProject(project);
    }

    @Nullable
    public static FeatureUsageData mergeWithEventData(@Nullable FeatureUsageData groupData, @Nullable FeatureUsageData data) {
        if (data == null) {
            return groupData;
        }
        FeatureUsageData newData = groupData == null ? new FeatureUsageData() : groupData.copy();
        newData.merge(data, "event_");
        return newData;
    }

    public static void logStateEvent(@NotNull EventLogGroup group, @NotNull String event, @NotNull FeatureUsageData data) {
        FeatureUsageLogger.INSTANCE.logState(group, event, data.build());
        FeatureUsageLogger.INSTANCE.logState(group, "invoked");
    }

    @NotNull
    public static CompletableFuture<Void> logStateEventsAsync(@NotNull EventLogGroup group, @NotNull Collection<MetricEvent> events) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        StatisticsEventLogger logger2 = StatisticsEventLogProviderUtil.getEventLogProvider(group.getRecorder()).getLogger();
        for (MetricEvent event : events) {
            futures.add(logger2.logAsync(group, event.getEventId(), event.getData().build(), true));
        }
        futures.add(logger2.logAsync(group, "invoked", true));
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public static void logStateEvents(@NotNull EventLogGroup group, @NotNull Collection<MetricEvent> events) {
        FUStateUsagesLogger.logStateEventsAsync(group, events);
    }
}

