/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.concurrency.JobScheduler;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsageCollectorEP;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FUCounterUsageLogger {
    public static final ExtensionPointName<CounterUsageCollectorEP> EP_NAME = new ExtensionPointName("com.intellij.statistics.counterUsagesCollector");
    private static final int LOG_REGISTERED_DELAY_MIN = 1440;
    private static final int LOG_REGISTERED_INITIAL_DELAY_MIN = 5;
    private static final Logger LOG = Logger.getInstance(FUCounterUsageLogger.class);
    private static final FUCounterUsageLogger INSTANCE = new FUCounterUsageLogger();
    private final Map<String, EventLogGroup> myGroups = new HashMap<String, EventLogGroup>();

    @NotNull
    public static FUCounterUsageLogger getInstance() {
        return INSTANCE;
    }

    public FUCounterUsageLogger() {
        for (CounterUsageCollectorEP ep : EP_NAME.getExtensionList()) {
            this.registerGroupFromEP(ep);
        }
        ApplicationManager.getApplication().getExtensionArea().getExtensionPoint(EP_NAME).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CounterUsageCollectorEP>(){

            public void extensionAdded(@NotNull CounterUsageCollectorEP extension, @NotNull PluginDescriptor pluginDescriptor) {
                FUCounterUsageLogger.this.registerGroupFromEP(extension);
            }
        }, true, null);
        JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.logRegisteredGroups(), 5L, 1440L, TimeUnit.MINUTES);
    }

    private void registerGroupFromEP(CounterUsageCollectorEP ep) {
        String id;
        if (ep.implementationClass == null && StringUtil.isNotEmpty((String)(id = ep.getGroupId()))) {
            this.register(new EventLogGroup(id, ep.version));
        }
    }

    @NotNull
    public static List<FeatureUsagesCollector> instantiateCounterCollectors() {
        ArrayList<FeatureUsagesCollector> result = new ArrayList<FeatureUsagesCollector>(EP_NAME.getPoint().size());
        EP_NAME.processWithPluginDescriptor((ep, pluginDescriptor) -> {
            if (ep.implementationClass != null) {
                result.add((FeatureUsagesCollector)ApplicationManager.getApplication().instantiateClass(ep.implementationClass, pluginDescriptor));
            }
        });
        return result;
    }

    private void register(@NotNull EventLogGroup group) {
        this.myGroups.put(group.getId(), group);
    }

    public CompletableFuture<Void> logRegisteredGroups() {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (EventLogGroup group : this.myGroups.values()) {
            futures.add(FeatureUsageLogger.INSTANCE.log(group, "registered"));
        }
        HashMap<String, StatisticsEventLogger> recorderLoggers = new HashMap<String, StatisticsEventLogger>();
        for (FeatureUsagesCollector collector : FUCounterUsageLogger.instantiateCounterCollectors()) {
            EventLogGroup group = collector.getGroup();
            if (group != null) {
                String recorder = group.getRecorder();
                StatisticsEventLogger logger2 = (StatisticsEventLogger)recorderLoggers.get(recorder);
                if (logger2 == null) {
                    logger2 = StatisticsEventLogProviderUtil.getEventLogProvider(recorder).getLogger();
                    recorderLoggers.put(recorder, logger2);
                }
                futures.add(logger2.logAsync(group, "registered", false));
                continue;
            }
            try {
                if (!StringUtil.isEmpty((String)collector.getGroupId())) continue;
                LOG.error("Please override either getGroupId() or getGroup() with not empty string in " + collector.getClass().getName());
            }
            catch (IllegalStateException e) {
                LOG.error(e.getMessage() + " in " + collector.getClass().getName());
            }
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    @Deprecated(forRemoval=true)
    public void logEvent(@Nullable Project project, @NonNls @NotNull String groupId, @NonNls @NotNull String eventId) {
        EventLogGroup group = this.findRegisteredGroupById(groupId);
        if (group != null) {
            Map<String, Object> data = new FeatureUsageData().addProject(project).build();
            FeatureUsageLogger.INSTANCE.log(group, eventId, data);
        }
    }

    @Deprecated
    public void logEvent(@Nullable Project project, @NonNls @NotNull String groupId, @NonNls @NotNull String eventId, @NotNull FeatureUsageData data) {
        EventLogGroup group = this.findRegisteredGroupById(groupId);
        if (group != null) {
            FeatureUsageLogger.INSTANCE.log(group, eventId, data.addProject(project).build());
        }
    }

    @Deprecated(forRemoval=true)
    public void logEvent(@NonNls @NotNull String groupId, @NonNls @NotNull String eventId) {
        EventLogGroup group = this.findRegisteredGroupById(groupId);
        if (group != null) {
            FeatureUsageLogger.INSTANCE.log(group, eventId);
        }
    }

    @Deprecated
    public void logEvent(@NonNls @NotNull String groupId, @NonNls @NotNull String eventId, @NotNull FeatureUsageData data) {
        EventLogGroup group = this.findRegisteredGroupById(groupId);
        if (group != null) {
            FeatureUsageLogger.INSTANCE.log(group, eventId, data.build());
        }
    }

    @Nullable
    private EventLogGroup findRegisteredGroupById(@NotNull String groupId) {
        if (!this.myGroups.containsKey(groupId)) {
            LOG.error("Cannot record event because group '" + groupId + "' is not registered. To fix it add '<statistics.counterUsagesCollector groupId=\"" + groupId + "\" version=\"1\"/>' in plugin.xml");
            return null;
        }
        return this.myGroups.get(groupId);
    }
}

