/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage.persistence;

import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventsSchemePathSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="EventLogWhitelist", storages={@Storage(value="$CACHE_FILE$")})
public final class EventLogMetadataSettingsPersistence
implements PersistentStateComponent<Element> {
    private final Map<String, Long> myLastModifications = new HashMap<String, Long>();
    private final Map<String, EventsSchemePathSettings> myRecorderToPathSettings = new HashMap<String, EventsSchemePathSettings>();
    private final Map<String, EventLogExternalOptions> myOptions = new HashMap<String, EventLogExternalOptions>();
    private static final String MODIFY = "update";
    private static final String RECORDER_ID = "recorder-id";
    private static final String LAST_MODIFIED = "last-modified";
    private static final String PATH = "path";
    private static final String CUSTOM_PATH = "custom-path";
    private static final String USE_CUSTOM_PATH = "use-custom-path";
    private static final String OPTIONS = "options";
    private static final String OPTION = "option";
    private static final String OPTION_NAME = "name";
    private static final String OPTION_VALUE = "value";
    private final Object myOptionsLock = new Object();

    public static EventLogMetadataSettingsPersistence getInstance() {
        return (EventLogMetadataSettingsPersistence)ApplicationManager.getApplication().getService(EventLogMetadataSettingsPersistence.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, String> getOptions(@NotNull String recorderId) {
        Object object = this.myOptionsLock;
        synchronized (object) {
            EventLogExternalOptions options = this.myOptions.get(recorderId);
            if (options == null) {
                return Collections.emptyMap();
            }
            return options.getOptions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOptions(@NotNull String recorderId, Map<String, String> options) {
        Object object = this.myOptionsLock;
        synchronized (object) {
            if (!this.myOptions.containsKey(recorderId)) {
                this.myOptions.put(recorderId, new EventLogExternalOptions());
            }
            this.myOptions.get(recorderId).putOptions(options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Map<String, String> updateOptions(@NotNull String recorderId, @NotNull Map<String, String> newOptions) {
        Object object = this.myOptionsLock;
        synchronized (object) {
            Map<String, String> persistedOptions = this.getOptions(recorderId);
            HashMap<String, String> changedOptions = new HashMap<String, String>();
            for (Map.Entry<String, String> newOption : newOptions.entrySet()) {
                String value = persistedOptions.get(newOption.getKey());
                String newValue = newOption.getValue();
                if (newValue == null || StringUtil.equals((CharSequence)value, (CharSequence)newValue)) continue;
                changedOptions.put(newOption.getKey(), newValue);
            }
            this.setOptions(recorderId, changedOptions);
            return changedOptions;
        }
    }

    public long getLastModified(@NotNull String recorderId) {
        return this.myLastModifications.containsKey(recorderId) ? Math.max(this.myLastModifications.get(recorderId), 0L) : 0L;
    }

    public void setLastModified(@NotNull String recorderId, long lastUpdate) {
        this.myLastModifications.put(recorderId, Math.max(lastUpdate, 0L));
    }

    @Nullable
    public EventsSchemePathSettings getPathSettings(@NotNull String recorderId) {
        return this.myRecorderToPathSettings.get(recorderId);
    }

    public void setPathSettings(@NotNull String recorderId, @NotNull EventsSchemePathSettings settings) {
        this.myRecorderToPathSettings.put(recorderId, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull Element element) {
        String recorder;
        this.myLastModifications.clear();
        for (Element update : element.getChildren(MODIFY)) {
            recorder = update.getAttributeValue(RECORDER_ID);
            if (!StringUtil.isNotEmpty((String)recorder)) continue;
            long lastUpdate = EventLogMetadataSettingsPersistence.parseLastUpdate(update);
            this.myLastModifications.put(recorder, lastUpdate);
        }
        this.myRecorderToPathSettings.clear();
        for (Element path : element.getChildren(PATH)) {
            String customPath;
            recorder = path.getAttributeValue(RECORDER_ID);
            if (!StringUtil.isNotEmpty((String)recorder) || (customPath = path.getAttributeValue(CUSTOM_PATH)) == null) continue;
            boolean useCustomPath = EventLogMetadataSettingsPersistence.parseUseCustomPath(path);
            this.myRecorderToPathSettings.put(recorder, new EventsSchemePathSettings(customPath, useCustomPath));
        }
        Object object = this.myOptionsLock;
        synchronized (object) {
            this.myOptions.clear();
            for (Element options : element.getChildren(OPTIONS)) {
                String recorderId = options.getAttributeValue(RECORDER_ID);
                if (recorderId == null) continue;
                this.myOptions.put(recorderId, new EventLogExternalOptions().deserialize(options));
            }
        }
    }

    private static boolean parseUseCustomPath(@NotNull Element update) {
        try {
            return Boolean.parseBoolean(update.getAttributeValue(USE_CUSTOM_PATH, "false"));
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static long parseLastUpdate(@NotNull Element update) {
        try {
            return Long.parseLong(update.getAttributeValue(LAST_MODIFIED, "0"));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public Element getState() {
        Element element = new Element("state");
        for (Map.Entry<String, Long> entry : this.myLastModifications.entrySet()) {
            Element update = new Element(MODIFY);
            update.setAttribute(RECORDER_ID, entry.getKey());
            update.setAttribute(LAST_MODIFIED, String.valueOf(entry.getValue()));
            element.addContent(update);
        }
        for (Map.Entry<String, Object> entry : this.myRecorderToPathSettings.entrySet()) {
            Element path = new Element(PATH);
            path.setAttribute(RECORDER_ID, entry.getKey());
            EventsSchemePathSettings value = (EventsSchemePathSettings)entry.getValue();
            path.setAttribute(CUSTOM_PATH, value.getCustomPath());
            path.setAttribute(USE_CUSTOM_PATH, String.valueOf(value.isUseCustomPath()));
            element.addContent(path);
        }
        for (Map.Entry<String, Object> entry : this.myOptions.entrySet()) {
            Element options = new Element(OPTIONS);
            options.setAttribute(RECORDER_ID, entry.getKey());
            for (Element option : ((EventLogExternalOptions)entry.getValue()).serialize()) {
                options.addContent(option);
            }
            element.addContent(options);
        }
        return element;
    }

    private static class EventLogExternalOptions {
        private final Map<String, String> myOptions = new HashMap<String, String>();

        private EventLogExternalOptions() {
        }

        @NotNull
        public Map<String, String> getOptions() {
            return new HashMap<String, String>(this.myOptions);
        }

        public void putOptions(@NotNull Map<String, String> options) {
            this.myOptions.putAll(options);
        }

        @NotNull
        public List<Element> serialize() {
            ArrayList<Element> result = new ArrayList<Element>();
            for (Map.Entry<String, String> entry : this.myOptions.entrySet()) {
                Element option = new Element(EventLogMetadataSettingsPersistence.OPTION);
                option.setAttribute(EventLogMetadataSettingsPersistence.OPTION_NAME, entry.getKey());
                option.setAttribute(EventLogMetadataSettingsPersistence.OPTION_VALUE, entry.getValue());
                result.add(option);
            }
            return result;
        }

        @NotNull
        public EventLogExternalOptions deserialize(@NotNull Element root) {
            this.myOptions.clear();
            for (Element option : root.getChildren(EventLogMetadataSettingsPersistence.OPTION)) {
                String name = option.getAttributeValue(EventLogMetadataSettingsPersistence.OPTION_NAME);
                String value = option.getAttributeValue(EventLogMetadataSettingsPersistence.OPTION_VALUE);
                if (name == null || value == null) continue;
                this.myOptions.put(name, value);
            }
            return this;
        }
    }
}

