/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage.persistence;

import com.intellij.internal.statistic.eventLog.validator.storage.persistence.BaseEventLogMetadataPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventsSchemePathSettings;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogMetadataPersistence
extends BaseEventLogMetadataPersistence {
    private static final String DEPRECATED_EVENTS_SCHEME_FILE = "white-list.json";
    public static final String EVENTS_SCHEME_FILE = "events-scheme.json";
    private static final Logger LOG = Logger.getInstance(EventLogMetadataPersistence.class);
    @NotNull
    private final String myRecorderId;

    public EventLogMetadataPersistence(@NotNull String recorderId) {
        this.myRecorderId = recorderId;
    }

    @Override
    @Nullable
    public String getCachedEventsScheme() {
        try {
            Path file = this.getEventsSchemeFile();
            if (Files.exists(file, new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
                return Files.readString(file);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @NotNull
    private Path getEventsSchemeFile() throws IOException {
        EventsSchemePathSettings settings = EventLogMetadataSettingsPersistence.getInstance().getPathSettings(this.myRecorderId);
        if (settings != null && settings.isUseCustomPath()) {
            return Path.of(settings.getCustomPath(), new String[0]);
        }
        Path file = this.getDefaultFile();
        if (!Files.exists(file, new LinkOption[0])) {
            this.initBuiltinMetadata(file);
        }
        return file;
    }

    public void cacheEventsScheme(@NotNull String eventsSchemeJson, long lastModified) {
        try {
            Path file = this.getDefaultFile();
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.writeString(file, (CharSequence)eventsSchemeJson, new OpenOption[0]);
            EventLogMetadataSettingsPersistence.getInstance().setLastModified(this.myRecorderId, lastModified);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void initBuiltinMetadata(@NotNull Path file) throws IOException {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.builtinEventSchemePath());){
            if (stream == null) {
                return;
            }
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.copy(stream, file, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private String builtinEventSchemePath() {
        return "resources/event-log-metadata/" + this.myRecorderId + "/events-scheme.json";
    }

    public long getLastModified() {
        return EventLogMetadataSettingsPersistence.getInstance().getLastModified(this.myRecorderId);
    }

    @NotNull
    public Path getDefaultFile() throws IOException {
        return EventLogMetadataPersistence.getDefaultMetadataFile(this.myRecorderId, EVENTS_SCHEME_FILE, DEPRECATED_EVENTS_SCHEME_FILE);
    }
}

