/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.validator.IntellijSensitiveDataValidator;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.storage.GlobalRulesHolder;
import com.intellij.internal.statistic.eventLog.validator.storage.GroupValidationTestRule;
import com.intellij.internal.statistic.eventLog.validator.storage.IntellijValidationRulesStorage;
import com.intellij.internal.statistic.eventLog.validator.storage.ValidationRulesPersistedStorage;
import com.intellij.internal.statistic.eventLog.validator.storage.ValidationTestRulesStorageHolder;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.BaseEventLogMetadataPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogTestMetadataPersistence;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValidationTestRulesPersistedStorage
implements IntellijValidationRulesStorage {
    private final ConcurrentMap<String, EventGroupRules> eventsValidators = new ConcurrentHashMap<String, EventGroupRules>();
    private final Object myLock = new Object();
    @NotNull
    private final EventLogTestMetadataPersistence myTestMetadataPersistence;
    @NotNull
    private final EventLogMetadataPersistence myMetadataPersistence;
    @NotNull
    private final String myRecorderId;
    @NotNull
    private final AtomicBoolean myIsInitialized;

    ValidationTestRulesPersistedStorage(@NotNull String recorderId) {
        this.myRecorderId = recorderId;
        this.myIsInitialized = new AtomicBoolean(false);
        this.myTestMetadataPersistence = new EventLogTestMetadataPersistence(recorderId);
        this.myMetadataPersistence = new EventLogMetadataPersistence(recorderId);
        this.updateValidators();
    }

    @Override
    @Nullable
    public EventGroupRules getGroupRules(@NotNull String groupId) {
        return (EventGroupRules)this.eventsValidators.get(groupId);
    }

    @Override
    public void update() {
        this.updateValidators();
    }

    @Override
    public void reload() {
        this.updateValidators();
    }

    public boolean isUnreachable() {
        return !this.myIsInitialized.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValidators() {
        Object object = this.myLock;
        synchronized (object) {
            this.eventsValidators.clear();
            this.myIsInitialized.set(false);
            EventGroupRemoteDescriptors productionGroups = EventLogTestMetadataPersistence.loadCachedEventGroupsSchemes(this.myMetadataPersistence);
            EventGroupRemoteDescriptors testGroups = EventLogTestMetadataPersistence.loadCachedEventGroupsSchemes(this.myTestMetadataPersistence);
            Map<String, EventGroupRules> result = this.createValidators(testGroups, productionGroups.rules);
            this.eventsValidators.putAll(result);
            this.myIsInitialized.set(true);
        }
    }

    @NotNull
    public EventGroupRemoteDescriptors loadProductionGroups() {
        return EventLogTestMetadataPersistence.loadCachedEventGroupsSchemes(this.myMetadataPersistence);
    }

    @NotNull
    private Map<String, EventGroupRules> createValidators(@NotNull EventGroupRemoteDescriptors groups, @Nullable EventGroupRemoteDescriptors.GroupRemoteRule productionRules) {
        EventGroupRemoteDescriptors.GroupRemoteRule rules = ValidationTestRulesPersistedStorage.merge(groups.rules, productionRules);
        GlobalRulesHolder globalRulesHolder = new GlobalRulesHolder(rules);
        EventLogBuild build2 = EventLogBuild.fromString((String)EventLogConfiguration.getInstance().getBuild());
        return ValidationRulesPersistedStorage.createValidators(build2, groups, globalRulesHolder, this.myRecorderId);
    }

    public void addTestGroup(@NotNull GroupValidationTestRule group) throws IOException {
        EventLogTestMetadataPersistence.addTestGroup(this.myRecorderId, group);
        this.updateValidators();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        Object object = this.myLock;
        synchronized (object) {
            this.eventsValidators.clear();
            this.myTestMetadataPersistence.cleanup();
        }
    }

    @NotNull
    public List<GroupValidationTestRule> loadValidationTestRules() {
        ArrayList testGroupsSchemes = EventLogTestMetadataPersistence.loadCachedEventGroupsSchemes((BaseEventLogMetadataPersistence)this.myTestMetadataPersistence).groups;
        ArrayList<GroupValidationTestRule> groups = new ArrayList<GroupValidationTestRule>();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        for (EventGroupRemoteDescriptors.EventGroupRemoteDescriptor group : testGroupsSchemes) {
            if (group.id == null || group.rules == null || group.rules.event_id == null) continue;
            Set eventIds = group.rules.event_id;
            if (eventIds.contains("{util#fus_test_mode}")) {
                groups.add(new GroupValidationTestRule(group.id, false));
                continue;
            }
            groups.add(new GroupValidationTestRule(group.id, true, gson.toJson((Object)group.rules)));
        }
        return groups;
    }

    public void updateTestGroups(@NotNull List<GroupValidationTestRule> groups) throws IOException {
        this.myTestMetadataPersistence.updateTestGroups(groups);
        this.updateValidators();
    }

    @Nullable
    private static EventGroupRemoteDescriptors.GroupRemoteRule merge(@Nullable EventGroupRemoteDescriptors.GroupRemoteRule testRules, @Nullable EventGroupRemoteDescriptors.GroupRemoteRule productionTestRules) {
        if (testRules == null) {
            return productionTestRules;
        }
        if (productionTestRules == null) {
            return testRules;
        }
        EventGroupRemoteDescriptors.GroupRemoteRule rule = new EventGroupRemoteDescriptors.GroupRemoteRule();
        ValidationTestRulesPersistedStorage.copyRules(rule, productionTestRules);
        ValidationTestRulesPersistedStorage.copyRules(rule, testRules);
        return rule;
    }

    private static void copyRules(@NotNull EventGroupRemoteDescriptors.GroupRemoteRule to, @NotNull EventGroupRemoteDescriptors.GroupRemoteRule from) {
        if (to.enums == null) {
            to.enums = new HashMap();
        }
        if (to.regexps == null) {
            to.regexps = new HashMap();
        }
        if (from.enums != null) {
            to.enums.putAll(from.enums);
        }
        if (from.regexps != null) {
            to.regexps.putAll(from.regexps);
        }
    }

    public static void cleanupAll() {
        List<String> recorders = StatisticsEventLogProviderUtil.getEventLogProviders().stream().filter(provider -> provider.isRecordEnabled()).map(provider -> provider.getRecorderId()).collect(Collectors.toList());
        ValidationTestRulesPersistedStorage.cleanupAll(recorders);
    }

    public static void cleanupAll(List<String> recorders) {
        for (String recorderId : recorders) {
            ValidationTestRulesPersistedStorage testStorage = ValidationTestRulesPersistedStorage.getTestStorage(recorderId, false);
            if (testStorage == null) continue;
            testStorage.cleanup();
        }
    }

    @Nullable
    public static ValidationTestRulesPersistedStorage getTestStorage(@NotNull String recorderId, boolean initIfNeeded) {
        IntellijSensitiveDataValidator validator = initIfNeeded ? IntellijSensitiveDataValidator.getInstance(recorderId) : IntellijSensitiveDataValidator.getIfInitialized(recorderId);
        IntellijValidationRulesStorage storage = validator != null ? (IntellijValidationRulesStorage)validator.getValidationRulesStorage() : null;
        return storage instanceof ValidationTestRulesStorageHolder ? ((ValidationTestRulesStorageHolder)((Object)storage)).getTestGroupStorage() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.myLock;
        synchronized (object) {
            return this.eventsValidators.size();
        }
    }
}

