/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage;

import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.storage.IntellijValidationRulesStorage;
import com.intellij.internal.statistic.eventLog.validator.storage.ValidationTestRulesPersistedStorage;
import com.intellij.internal.statistic.eventLog.validator.storage.ValidationTestRulesStorageHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeValidationRulesStorage
implements IntellijValidationRulesStorage,
ValidationTestRulesStorageHolder {
    @NotNull
    private final IntellijValidationRulesStorage myRulesStorage;
    @NotNull
    private final ValidationTestRulesPersistedStorage myTestRulesStorage;

    CompositeValidationRulesStorage(@NotNull IntellijValidationRulesStorage rulesStorage, @NotNull ValidationTestRulesPersistedStorage testRulesStorage) {
        this.myRulesStorage = rulesStorage;
        this.myTestRulesStorage = testRulesStorage;
    }

    @Override
    @Nullable
    public EventGroupRules getGroupRules(@NotNull String groupId) {
        EventGroupRules testGroupRules = this.myTestRulesStorage.getGroupRules(groupId);
        if (testGroupRules != null) {
            return testGroupRules;
        }
        return this.myRulesStorage.getGroupRules(groupId);
    }

    public boolean isUnreachable() {
        return this.myRulesStorage.isUnreachable() && this.myTestRulesStorage.isUnreachable();
    }

    @Override
    public void update() {
        this.myRulesStorage.update();
        this.myTestRulesStorage.update();
    }

    @Override
    public void reload() {
        this.myRulesStorage.reload();
        this.myTestRulesStorage.reload();
    }

    @Override
    @NotNull
    public ValidationTestRulesPersistedStorage getTestGroupStorage() {
        return this.myTestRulesStorage;
    }
}

