/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.utils;

import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.TestModeValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.UtilValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.UtilRuleProducer;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomRuleProducer
extends UtilRuleProducer {
    private final boolean myTestMode;

    public CustomRuleProducer(@NotNull String recorderId) {
        this.myTestMode = StatisticsRecorderUtil.isTestModeEnabled(recorderId);
    }

    @Nullable
    public UtilValidationRule createValidationRule(@NotNull String value, @NotNull EventGroupContextData contextData) {
        for (CustomValidationRule extension : (CustomValidationRule[])CustomValidationRule.EP_NAME.getExtensions()) {
            if (!this.isAcceptedRule(extension) || !extension.acceptRuleId(value)) continue;
            return extension;
        }
        return null;
    }

    private boolean isAcceptedRule(FUSRule extension) {
        if (extension instanceof TestModeValidationRule && !this.myTestMode) {
            return false;
        }
        return CustomRuleProducer.isDevelopedByJetBrains(extension);
    }

    private static boolean isDevelopedByJetBrains(FUSRule extension) {
        return ApplicationManager.getApplication().isUnitTestMode() || PluginInfoDetectorKt.getPluginInfo(extension.getClass()).isDevelopedByJetBrains();
    }
}

