/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public abstract class LocalEnumCustomValidationRule
extends CustomValidationRule {
    private final String myRule;
    private final Class<? extends Enum> myEnumClass;

    public LocalEnumCustomValidationRule(@NotNull String rule, @NotNull Class<? extends Enum> enumClass) {
        this.myRule = rule;
        this.myEnumClass = enumClass;
    }

    @Override
    @NotNull
    public String getRuleId() {
        return this.myRule;
    }

    @NotNull
    protected final ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        Enum[] constants;
        for (Enum constant : constants = this.myEnumClass.getEnumConstants()) {
            if (!StringUtil.equals((CharSequence)constant.name(), (CharSequence)data)) continue;
            return ValidationResultType.ACCEPTED;
        }
        return ValidationResultType.REJECTED;
    }
}

