/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.validator.SensitiveDataValidator;
import com.intellij.internal.statistic.eventLog.validator.ValidationRuleStorage;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.TestModeValidationRule;
import com.intellij.internal.statistic.eventLog.validator.storage.IntellijValidationRulesStorage;
import com.intellij.internal.statistic.eventLog.validator.storage.ValidationRulesStorageProvider;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijSensitiveDataValidator
extends SensitiveDataValidator<IntellijValidationRulesStorage> {
    private static final ConcurrentMap<String, IntellijSensitiveDataValidator> ourInstances = new ConcurrentHashMap<String, IntellijSensitiveDataValidator>();
    private final String myRecorderId;

    @NotNull
    public static IntellijSensitiveDataValidator getInstance(@NotNull String recorderId) {
        return ourInstances.computeIfAbsent(recorderId, id -> {
            IntellijValidationRulesStorage storage = ValidationRulesStorageProvider.newStorage(recorderId);
            return ApplicationManager.getApplication().isUnitTestMode() ? new BlindSensitiveDataValidator(storage, recorderId) : new IntellijSensitiveDataValidator(storage, recorderId);
        });
    }

    @Nullable
    public static IntellijSensitiveDataValidator getIfInitialized(@NotNull String recorderId) {
        return (IntellijSensitiveDataValidator)((Object)ourInstances.get(recorderId));
    }

    protected IntellijSensitiveDataValidator(@NotNull IntellijValidationRulesStorage storage, @NotNull String recorderId) {
        super((ValidationRuleStorage)storage);
        this.myRecorderId = recorderId;
    }

    public boolean isGroupAllowed(@NotNull EventLogGroup group) {
        if (StatisticsRecorderUtil.isTestModeEnabled(this.myRecorderId)) {
            return true;
        }
        IntellijValidationRulesStorage storage = (IntellijValidationRulesStorage)this.getValidationRulesStorage();
        if (storage.isUnreachable()) {
            return true;
        }
        return storage.getGroupRules(group.getId()) != null;
    }

    @NotNull
    public Map<String, Object> guaranteeCorrectEventData(@NotNull EventContext context, EventGroupRules groupRules) {
        if (this.isTestModeEnabled(groupRules)) {
            return context.eventData;
        }
        Map validatedData = super.guaranteeCorrectEventData(context, groupRules);
        boolean containsPluginInfo = validatedData.containsKey("plugin") || validatedData.containsKey("plugin_type") || validatedData.containsKey("plugin_version");
        PluginInfo pluginInfo = (PluginInfo)context.getPayload(CustomValidationRule.PLUGIN_INFO);
        if (pluginInfo != null && !containsPluginInfo) {
            StatisticsUtil.addPluginInfoTo(pluginInfo, validatedData);
        }
        return validatedData;
    }

    private boolean isTestModeEnabled(@Nullable EventGroupRules rule) {
        return StatisticsRecorderUtil.isTestModeEnabled(this.myRecorderId) && rule != null && ContainerUtil.exists((Object[])rule.getEventIdRules(), r -> r instanceof TestModeValidationRule);
    }

    public void update() {
        ((IntellijValidationRulesStorage)this.getValidationRulesStorage()).update();
    }

    public void reload() {
        ((IntellijValidationRulesStorage)this.getValidationRulesStorage()).reload();
    }

    static {
        CustomValidationRule.EP_NAME.addChangeListener(ourInstances::clear, null);
    }

    private static class BlindSensitiveDataValidator
    extends IntellijSensitiveDataValidator {
        protected BlindSensitiveDataValidator(@NotNull IntellijValidationRulesStorage storage, @NotNull String recorderId) {
            super(storage, recorderId);
        }

        @NotNull
        public String guaranteeCorrectEventId(@NotNull EventContext context, @Nullable EventGroupRules groupRules) {
            return context.eventId;
        }

        @Override
        @NotNull
        public Map<String, Object> guaranteeCorrectEventData(@NotNull EventContext context, EventGroupRules groupRules) {
            return context.eventData;
        }

        @Override
        public boolean isGroupAllowed(@NotNull EventLogGroup group) {
            return true;
        }
    }
}

