/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection;

import com.intellij.internal.statistic.config.StatisticsStringUtil;
import com.intellij.internal.statistic.config.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.DeviceConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfig;
import com.intellij.internal.statistic.eventLog.EventLogSendConfig;
import com.intellij.internal.statistic.eventLog.LogEventRecord;
import com.intellij.internal.statistic.eventLog.LogEventRecordRequest;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.MachineId;
import com.intellij.internal.statistic.eventLog.connection.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.EventLogResultDecorator;
import com.intellij.internal.statistic.eventLog.connection.EventLogSendListener;
import com.intellij.internal.statistic.eventLog.connection.EventLogSettingsService;
import com.intellij.internal.statistic.eventLog.connection.EventLogUploadSettingsService;
import com.intellij.internal.statistic.eventLog.connection.StatServiceException;
import com.intellij.internal.statistic.eventLog.connection.StatisticsResult;
import com.intellij.internal.statistic.eventLog.connection.StatisticsService;
import com.intellij.internal.statistic.eventLog.connection.request.StatsHttpRequests;
import com.intellij.internal.statistic.eventLog.connection.request.StatsHttpResponse;
import com.intellij.internal.statistic.eventLog.connection.request.StatsRequestBuilder;
import com.intellij.internal.statistic.eventLog.filters.LogEventFilter;
import com.intellij.internal.statistic.uploader.EventLogExternalSendConfig;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public class EventLogStatisticsService
implements StatisticsService {
    private final EventLogSendConfig myConfiguration;
    private final EventLogSettingsService mySettingsService;
    private final EventLogSendListener mySendListener;

    public EventLogStatisticsService(@NotNull EventLogSendConfig config, @NotNull EventLogApplicationInfo application, @Nullable EventLogSendListener listener) {
        this.myConfiguration = config;
        this.mySettingsService = new EventLogUploadSettingsService(config.getRecorderId(), application);
        this.mySendListener = listener;
    }

    @TestOnly
    public EventLogStatisticsService(@NotNull EventLogSendConfig config, @Nullable EventLogSendListener listener, @Nullable EventLogUploadSettingsService settingsService) {
        this.myConfiguration = config;
        this.mySettingsService = settingsService;
        this.mySendListener = listener;
    }

    @Override
    public StatisticsResult send() {
        return EventLogStatisticsService.send(this.myConfiguration, this.mySettingsService, new EventLogCounterResultDecorator(this.mySendListener));
    }

    @Deprecated
    public static StatisticsResult send(@NotNull DeviceConfiguration device, @NotNull EventLogRecorderConfig config, @NotNull EventLogSettingsService settings, @NotNull EventLogResultDecorator decorator) {
        boolean isSendEnabled = config.isSendEnabled();
        List<String> logFiles = config.getFilesToSendProvider().getFilesToSend().stream().map(file -> file.getFile().getAbsolutePath()).collect(Collectors.toList());
        String recorderId = config.getRecorderId();
        return EventLogStatisticsService.send(new EventLogExternalSendConfig(recorderId, device.getDeviceId(), device.getBucket(), device.getMachineId(), logFiles, isSendEnabled), settings, decorator);
    }

    public StatisticsResult send(@NotNull EventLogResultDecorator decorator) {
        return EventLogStatisticsService.send(this.myConfiguration, this.mySettingsService, decorator);
    }

    public static StatisticsResult send(@NotNull EventLogSendConfig config, @NotNull EventLogSettingsService settings, @NotNull EventLogResultDecorator decorator) {
        EventLogApplicationInfo info = settings.getApplicationInfo();
        DataCollectorDebugLogger logger2 = info.getLogger();
        List<EventLogFile> logs = EventLogStatisticsService.getLogFiles(config, logger2);
        if (!config.isSendEnabled()) {
            EventLogStatisticsService.cleanupEventLogFiles(logs, logger2);
            return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "Event Log collector is not enabled");
        }
        if (logs.isEmpty()) {
            return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to send");
        }
        if (!settings.isSettingsReachable()) {
            return new StatisticsResult(StatisticsResult.ResultCode.ERROR_IN_CONFIG, "ERROR: settings server is unreachable");
        }
        if (!settings.isSendEnabled()) {
            EventLogStatisticsService.cleanupEventLogFiles(logs, logger2);
            return new StatisticsResult(StatisticsResult.ResultCode.NOT_PERMITTED_SERVER, "NOT_PERMITTED");
        }
        String serviceUrl = settings.getServiceUrl();
        if (serviceUrl == null) {
            return new StatisticsResult(StatisticsResult.ResultCode.ERROR_IN_CONFIG, "ERROR: unknown Statistics Service URL.");
        }
        boolean isInternal = info.isInternal();
        String productCode = info.getProductCode();
        EventLogBuildType defaultBuildType = EventLogStatisticsService.getDefaultBuildType(info);
        LogEventFilter baseFilter = settings.getBaseEventFilter();
        MachineId machineId = EventLogStatisticsService.getActualOrDisabledMachineId(config.getMachineId(), settings);
        try {
            EventLogConnectionSettings connectionSettings = info.getConnectionSettings();
            decorator.onLogsLoaded(logs.size());
            ArrayList<File> toRemove = new ArrayList<File>(logs.size());
            for (EventLogFile logFile : logs) {
                File file = logFile.getFile();
                EventLogBuildType type = logFile.getType(defaultBuildType);
                LogEventFilter filter = settings.getEventFilter(baseFilter, type);
                String deviceId = config.getDeviceId();
                LogEventRecordRequest recordRequest = LogEventRecordRequest.Companion.create(file, config.getRecorderId(), productCode, deviceId, filter, isInternal, logger2, machineId);
                ValidationErrorInfo error = EventLogStatisticsService.validate(recordRequest, file);
                if (error != null) {
                    if (logger2.isTraceEnabled()) {
                        logger2.trace(file.getName() + "-> " + error.getMessage());
                    }
                    decorator.onFailed(recordRequest, error.getCode(), null);
                    toRemove.add(file);
                    continue;
                }
                try {
                    StatsHttpRequests.post(serviceUrl, connectionSettings).withBody(LogEventSerializer.INSTANCE.toString(recordRequest), "application/json", StandardCharsets.UTF_8).succeed((r, code) -> {
                        toRemove.add(file);
                        decorator.onSucceed(recordRequest, EventLogStatisticsService.loadAndLogResponse(logger2, r, file), file.getAbsolutePath());
                    }).fail((r, code) -> {
                        if (code == 400) {
                            toRemove.add(file);
                        }
                        decorator.onFailed(recordRequest, code, EventLogStatisticsService.loadAndLogResponse(logger2, r, file));
                    }).send();
                }
                catch (Exception e) {
                    if (logger2.isTraceEnabled()) {
                        logger2.trace(file.getName() + " -> " + e.getMessage());
                    }
                    int errorCode = e instanceof StatsRequestBuilder.InvalidHttpRequest ? ((StatsRequestBuilder.InvalidHttpRequest)e).getCode() : 50;
                    decorator.onFailed(null, errorCode, null);
                }
            }
            EventLogStatisticsService.cleanupFiles(toRemove, logger2);
            return decorator.onFinished();
        }
        catch (Exception e) {
            String message = e.getMessage();
            logger2.info(message != null ? message : "", e);
            throw new StatServiceException("Error during data sending.", e);
        }
    }

    private static MachineId getActualOrDisabledMachineId(@NotNull MachineId machineId, @NotNull EventLogSettingsService settings) {
        if (machineId == MachineId.DISABLED) {
            return MachineId.DISABLED;
        }
        Map<String, String> options = settings.getOptions();
        String machineIdSaltOption = options.get("id_salt");
        if ("disabled".equals(machineIdSaltOption)) {
            return MachineId.DISABLED;
        }
        return machineId;
    }

    @NotNull
    private static EventLogBuildType getDefaultBuildType(EventLogApplicationInfo info) {
        return info.isEAP() ? EventLogBuildType.EAP : EventLogBuildType.RELEASE;
    }

    @NotNull
    private static String loadAndLogResponse(@NotNull DataCollectorDebugLogger logger2, @NotNull StatsHttpResponse response, @NotNull File file) throws IOException {
        String content;
        String message = response.readAsString();
        String string = content = message != null ? message : Integer.toString(response.getStatusCode());
        if (logger2.isTraceEnabled()) {
            logger2.trace(file.getName() + " -> " + content);
        }
        return content;
    }

    @Nullable
    private static ValidationErrorInfo validate(@Nullable LogEventRecordRequest request, @NotNull File file) {
        if (request == null) {
            return new ValidationErrorInfo("File is empty or has invalid format: " + file.getName(), 1);
        }
        if (StatisticsStringUtil.isEmpty(request.getDevice())) {
            return new ValidationErrorInfo("Cannot upload event log, device ID is empty", 2);
        }
        if (StatisticsStringUtil.isEmpty(request.getProduct())) {
            return new ValidationErrorInfo("Cannot upload event log, product code is empty", 3);
        }
        if (StatisticsStringUtil.isEmpty(request.getRecorder())) {
            return new ValidationErrorInfo("Cannot upload event log, recorder code is empty", 4);
        }
        if (request.getRecords().isEmpty()) {
            return new ValidationErrorInfo("Cannot upload event log, record list is empty", 5);
        }
        for (LogEventRecord content : request.getRecords()) {
            if (!content.getEvents().isEmpty()) continue;
            return new ValidationErrorInfo("Cannot upload event log, event list is empty", 6);
        }
        return null;
    }

    @NotNull
    protected static List<EventLogFile> getLogFiles(@NotNull EventLogSendConfig config, @NotNull DataCollectorDebugLogger logger2) {
        try {
            return config.getFilesToSendProvider().getFilesToSend();
        }
        catch (Exception e) {
            String message = e.getMessage();
            logger2.info(message != null ? message : "", e);
            return Collections.emptyList();
        }
    }

    private static void cleanupEventLogFiles(@NotNull List<EventLogFile> toRemove, @NotNull DataCollectorDebugLogger logger2) {
        ArrayList<File> filesToRemove = new ArrayList<File>();
        for (EventLogFile file : toRemove) {
            filesToRemove.add(file.getFile());
        }
        EventLogStatisticsService.cleanupFiles(filesToRemove, logger2);
    }

    private static void cleanupFiles(@NotNull List<File> toRemove, @NotNull DataCollectorDebugLogger logger2) {
        for (File file : toRemove) {
            if (!file.delete()) {
                logger2.warn("Failed deleting event log: " + file.getName());
            }
            if (!logger2.isTraceEnabled()) continue;
            logger2.trace("Removed sent log: " + file.getName());
        }
    }

    private static final class EventLogCounterResultDecorator
    implements EventLogResultDecorator {
        private final EventLogSendListener myListener;
        private int myLocalFiles = -1;
        private final List<String> mySuccessfullySentFiles = new ArrayList<String>();
        private final List<Integer> myErrors = new ArrayList<Integer>();

        private EventLogCounterResultDecorator(@Nullable EventLogSendListener listener) {
            this.myListener = listener;
        }

        @Override
        public void onLogsLoaded(int localFiles) {
            this.myLocalFiles = localFiles;
        }

        @Override
        public void onSucceed(@NotNull LogEventRecordRequest request, @NotNull String content, @NotNull String logPath) {
            this.mySuccessfullySentFiles.add(logPath);
        }

        @Override
        public void onFailed(@Nullable LogEventRecordRequest request, int error, @Nullable String content) {
            this.myErrors.add(error);
        }

        @Override
        @NotNull
        public StatisticsResult onFinished() {
            int failed;
            int succeed;
            int total;
            if (this.myListener != null) {
                this.myListener.onLogsSend(this.mySuccessfullySentFiles, this.myErrors, this.myLocalFiles);
            }
            if ((total = (succeed = this.mySuccessfullySentFiles.size()) + (failed = this.myErrors.size())) == 0) {
                return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to upload.");
            }
            if (failed > 0) {
                return new StatisticsResult(StatisticsResult.ResultCode.SENT_WITH_ERRORS, "Uploaded " + succeed + " out of " + total + " files.");
            }
            return new StatisticsResult(StatisticsResult.ResultCode.SEND, "Uploaded " + succeed + " files.");
        }
    }

    private static final class ValidationErrorInfo {
        private final int myCode;
        private final String myError;

        private ValidationErrorInfo(@NotNull String error, int code) {
            this.myError = error;
            this.myCode = code;
        }

        private int getCode() {
            return this.myCode;
        }

        @NotNull
        private String getMessage() {
            return this.myError;
        }
    }
}

