/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EmptyStatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsService;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogFile;
import com.intellij.internal.statistic.eventLog.EventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfiguration;
import com.intellij.internal.statistic.eventLog.FilteredEventMergeStrategy;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogFileWriter;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.StatisticsEventMergeStrategy;
import com.intellij.internal.statistic.eventLog.StatisticsFileEventLogger;
import com.intellij.internal.statistic.eventLog.logger.StatisticsEventLogThrottleWriter;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 &2\u00020\u0001:\u0001&B+\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB'\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0002J\b\u0010 \u001a\u0004\u0018\u00010!J\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\rH&J\b\u0010%\u001a\u00020\rH&R\u001b\u0010\u000f\u001a\u00020\u00108VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006'"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "", "recorderId", "", "version", "", "sendFrequencyMs", "", "maxFileSize", "(Ljava/lang/String;IJLjava/lang/String;)V", "maxFileSizeInBytes", "(Ljava/lang/String;IJI)V", "sendLogsOnIdeClose", "", "(Ljava/lang/String;IJIZ)V", "logger", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogger;", "getLogger", "()Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogger;", "logger$delegate", "Lkotlin/Lazy;", "getRecorderId", "()Ljava/lang/String;", "getSendFrequencyMs", "()J", "getSendLogsOnIdeClose", "()Z", "getVersion", "()I", "createEventsMergeStrategy", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventMergeStrategy;", "createLogger", "getActiveLogFile", "Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "getLogFilesProvider", "Lcom/intellij/internal/statistic/eventLog/EventLogFilesProvider;", "isRecordEnabled", "isSendEnabled", "Companion", "intellij.platform.statistics"})
public abstract class StatisticsEventLoggerProvider {
    @NotNull
    private final Lazy logger$delegate;
    @NotNull
    private final String recorderId;
    private final int version;
    private final long sendFrequencyMs;
    private final int maxFileSizeInBytes;
    private final boolean sendLogsOnIdeClose;
    @NotNull
    private static final ExtensionPointName<StatisticsEventLoggerProvider> EP_NAME;
    public static final int DEFAULT_MAX_FILE_SIZE_BYTES = 204800;
    private static final long DEFAULT_SEND_FREQUENCY_MS;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public StatisticsEventLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        StatisticsEventLoggerProvider statisticsEventLoggerProvider = this;
        Object var3_3 = null;
        return (StatisticsEventLogger)lazy.getValue();
    }

    public abstract boolean isRecordEnabled();

    public abstract boolean isSendEnabled();

    @Nullable
    public final EventLogFile getActiveLogFile() {
        return this.getLogger().getActiveLogFile();
    }

    @NotNull
    public final EventLogFilesProvider getLogFilesProvider() {
        return this.getLogger().getLogFilesProvider();
    }

    @NotNull
    public StatisticsEventMergeStrategy createEventsMergeStrategy() {
        return new FilteredEventMergeStrategy(SetsKt.emptySet());
    }

    private final StatisticsEventLogger createLogger() {
        if (!this.isRecordEnabled()) {
            return new EmptyStatisticsEventLogger();
        }
        Application app = ApplicationManager.getApplication();
        boolean isEap = app != null && app.isEAP();
        boolean isHeadless = app != null && app.isHeadlessEnvironment();
        EventLogConfiguration eventLogConfiguration = EventLogConfiguration.Companion.getInstance();
        EventLogRecorderConfiguration config = eventLogConfiguration.getOrCreate(this.recorderId);
        StatisticsEventLogFileWriter writer = new StatisticsEventLogFileWriter(this.recorderId, this.maxFileSizeInBytes, isEap, eventLogConfiguration.getBuild());
        EventLogConfigOptionsService configService = EventLogConfigOptionsService.getInstance();
        StatisticsEventLogThrottleWriter throttledWriter = new StatisticsEventLogThrottleWriter(configService, this.recorderId, String.valueOf(this.version), writer);
        StatisticsFileEventLogger logger2 = new StatisticsFileEventLogger(this.recorderId, config.getSessionId(), isHeadless, eventLogConfiguration.getBuild(), String.valueOf(config.getBucket()), String.valueOf(this.version), throttledWriter, UsageStatisticsPersistenceComponent.getInstance(), this.createEventsMergeStrategy());
        Disposer.register((Disposable)((Disposable)ApplicationManager.getApplication()), (Disposable)logger2);
        return logger2;
    }

    @NotNull
    public final String getRecorderId() {
        return this.recorderId;
    }

    public final int getVersion() {
        return this.version;
    }

    public final long getSendFrequencyMs() {
        return this.sendFrequencyMs;
    }

    public final boolean getSendLogsOnIdeClose() {
        return this.sendLogsOnIdeClose;
    }

    public StatisticsEventLoggerProvider(@NotNull String recorderId, int version, long sendFrequencyMs, int maxFileSizeInBytes, boolean sendLogsOnIdeClose) {
        this.recorderId = recorderId;
        this.version = version;
        this.sendFrequencyMs = sendFrequencyMs;
        this.maxFileSizeInBytes = maxFileSizeInBytes;
        this.sendLogsOnIdeClose = sendLogsOnIdeClose;
        this.logger$delegate = LazyKt.lazy((Function0)((Function0)new Function0<StatisticsEventLogger>(this){
            final /* synthetic */ StatisticsEventLoggerProvider this$0;

            @NotNull
            public final StatisticsEventLogger invoke() {
                return StatisticsEventLoggerProvider.access$createLogger(this.this$0);
            }
            {
                this.this$0 = statisticsEventLoggerProvider;
                super(0);
            }
        }));
    }

    public /* synthetic */ StatisticsEventLoggerProvider(String string, int n, long l, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        this(string, n, l, n2, bl);
    }

    @Deprecated(message="Use primary constructor instead")
    public StatisticsEventLoggerProvider(@NotNull String recorderId, int version, long sendFrequencyMs, @NotNull String maxFileSize) {
        this(recorderId, version, sendFrequencyMs, Companion.parseFileSize(maxFileSize));
    }

    public /* synthetic */ StatisticsEventLoggerProvider(String string, int n, long l, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            l = TimeUnit.HOURS.toMillis(1L);
        }
        if ((n2 & 8) != 0) {
            string2 = "200KB";
        }
        this(string, n, l, string2);
    }

    @Deprecated(message="Use primary constructor instead")
    public StatisticsEventLoggerProvider(@NotNull String recorderId, int version, long sendFrequencyMs, int maxFileSizeInBytes) {
        this(recorderId, version, sendFrequencyMs, maxFileSizeInBytes, false);
    }

    static {
        Companion = new Companion(null);
        EP_NAME = new ExtensionPointName("com.intellij.statistic.eventLog.eventLoggerProvider");
        DEFAULT_SEND_FREQUENCY_MS = TimeUnit.HOURS.toMillis(1L);
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(StatisticsEventLoggerProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        LOG = logger2;
    }

    public static final /* synthetic */ StatisticsEventLogger access$createLogger(StatisticsEventLoggerProvider $this) {
        return $this.createLogger();
    }

    @NotNull
    public static final ExtensionPointName<StatisticsEventLoggerProvider> getEP_NAME() {
        Companion companion = Companion;
        return EP_NAME;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider$Companion;", "", "()V", "DEFAULT_MAX_FILE_SIZE_BYTES", "", "DEFAULT_SEND_FREQUENCY_MS", "", "getDEFAULT_SEND_FREQUENCY_MS", "()J", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "getEP_NAME$annotations", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "parseFileSize", "maxFileSize", "", "intellij.platform.statistics"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void getEP_NAME$annotations() {
        }

        @NotNull
        public final ExtensionPointName<StatisticsEventLoggerProvider> getEP_NAME() {
            return EP_NAME;
        }

        public final long getDEFAULT_SEND_FREQUENCY_MS() {
            return DEFAULT_SEND_FREQUENCY_MS;
        }

        public final int parseFileSize(@NotNull String maxFileSize) {
            int n;
            int n2;
            int length = maxFileSize.length();
            if (length < 3) {
                LOG.warn("maxFileSize should contain measurement unit: " + maxFileSize);
                return 204800;
            }
            String string = maxFileSize;
            int n3 = 0;
            int n4 = length - 2;
            String string2 = string.substring(n3, n4);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String value = string2;
            try {
                String string3 = value;
                n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException e) {
                LOG.warn("Unable to parse maxFileSize for FUS log file: " + maxFileSize);
                return 204800;
            }
            int size = n2;
            String string4 = maxFileSize;
            int n5 = length - 2;
            String string5 = string4.substring(n5, length);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            switch (string5) {
                case "KB": {
                    n = 1024;
                    break;
                }
                case "MB": {
                    n = 0x100000;
                    break;
                }
                case "GB": {
                    n = 0x40000000;
                    break;
                }
                default: {
                    LOG.warn("Unable to parse measurement unit of maxFileSize for FUS log file: " + maxFileSize);
                    return 204800;
                }
            }
            int multiplier = n;
            return size * multiplier;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

