/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EmptyStatisticsEventLoggerProvider;
import com.intellij.internal.statistic.eventLog.StatisticsEventLoggerProvider;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.PluginType;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0002J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0002J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0006J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0007H\u0002R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogProvidersHolder;", "", "()V", "eventLoggerProviders", "Ljava/util/concurrent/atomic/AtomicReference;", "", "", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "calculateEventLogProvider", "getAllEventLogProviders", "", "getEventLogProvider", "recorderId", "getEventLogProviders", "", "isJetBrainsProduct", "", "isProviderApplicable", "extension", "intellij.platform.statistics"})
public final class StatisticsEventLogProvidersHolder {
    private final AtomicReference<Map<String, StatisticsEventLoggerProvider>> eventLoggerProviders = new AtomicReference<Map<String, StatisticsEventLoggerProvider>>(this.calculateEventLogProvider());

    @NotNull
    public final StatisticsEventLoggerProvider getEventLogProvider(@NotNull String recorderId) {
        StatisticsEventLoggerProvider statisticsEventLoggerProvider = this.eventLoggerProviders.get().get(recorderId);
        if (statisticsEventLoggerProvider == null) {
            statisticsEventLoggerProvider = new EmptyStatisticsEventLoggerProvider(recorderId);
        }
        return statisticsEventLoggerProvider;
    }

    @NotNull
    public final Collection<StatisticsEventLoggerProvider> getEventLogProviders() {
        return this.eventLoggerProviders.get().values();
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, StatisticsEventLoggerProvider> calculateEventLogProvider() {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = this.getAllEventLogProviders();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            StatisticsEventLoggerProvider statisticsEventLoggerProvider = (StatisticsEventLoggerProvider)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string = it.getRecorderId();
            map.put(string, element$iv$iv);
        }
        return destination$iv$iv;
    }

    private final List<StatisticsEventLoggerProvider> getAllEventLogProviders() {
        List providers = StatisticsEventLoggerProvider.Companion.getEP_NAME().getExtensionsIfPointIsRegistered();
        if (providers.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        boolean isJetBrainsProduct = this.isJetBrainsProduct();
        Iterable $this$distinctBy$iv = ContainerUtil.filter((Collection)providers, (Condition)new Condition(this, isJetBrainsProduct){
            final /* synthetic */ StatisticsEventLogProvidersHolder this$0;
            final /* synthetic */ boolean $isJetBrainsProduct;

            public final boolean value(StatisticsEventLoggerProvider it) {
                return StatisticsEventLogProvidersHolder.access$isProviderApplicable(this.this$0, this.$isJetBrainsProduct, it.getRecorderId(), it);
            }
            {
                this.this$0 = statisticsEventLogProvidersHolder;
                this.$isJetBrainsProduct = bl;
            }
        });
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            StatisticsEventLoggerProvider it = (StatisticsEventLoggerProvider)e$iv;
            boolean bl = false;
            String key$iv = it.getRecorderId();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    private final boolean isJetBrainsProduct() {
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        if (appInfo == null || StringUtil.isEmpty((String)appInfo.getShortCompanyName())) {
            return true;
        }
        return PlatformUtils.isJetBrainsProduct();
    }

    private final boolean isProviderApplicable(boolean isJetBrainsProduct, String recorderId, StatisticsEventLoggerProvider extension) {
        if (Intrinsics.areEqual((Object)recorderId, (Object)extension.getRecorderId())) {
            if (!isJetBrainsProduct || !StatisticsRecorderUtil.isBuildInRecorder(recorderId)) {
                return true;
            }
            PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(extension.getClass());
            return Intrinsics.areEqual((Object)recorderId, (Object)"MLSE") ? pluginInfo.isDevelopedByJetBrains() : pluginInfo.getType() == PluginType.PLATFORM || pluginInfo.getType() == PluginType.FROM_SOURCES || pluginInfo.isAllowedToInjectIntoFUS();
        }
        return false;
    }

    public StatisticsEventLogProvidersHolder() {
        if (ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(StatisticsEventLoggerProvider.Companion.getEP_NAME())) {
            StatisticsEventLoggerProvider.Companion.getEP_NAME().addChangeListener(new Runnable(){

                @Override
                public final void run() {
                    eventLoggerProviders.set(this.calculateEventLogProvider());
                }
            }, null);
        }
    }

    public static final /* synthetic */ boolean access$isProviderApplicable(StatisticsEventLogProvidersHolder $this, boolean isJetBrainsProduct, String recorderId, StatisticsEventLoggerProvider extension) {
        return $this.isProviderApplicable(isJetBrainsProduct, recorderId, extension);
    }
}

