/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ShortcutDataProvider {
    private static final Collection<Integer> DOUBLE_CLICK_MODIFIER_KEYS = Arrays.asList(17, 16);
    private static final List<Pair<Integer, String>> ourModifiers = new ArrayList<Pair<Integer, String>>(6);
    private static final Int2ObjectMap<String> ourKeyCodes;

    @Nullable
    public static String getActionEventText(@Nullable AnActionEvent event) {
        return event != null ? ShortcutDataProvider.getInputEventText(event.getInputEvent(), event.getPlace()) : null;
    }

    @Nullable
    public static String getInputEventText(@Nullable InputEvent inputEvent, @Nullable String place) {
        if (inputEvent instanceof KeyEvent) {
            if ("TouchBarGeneral".equals(place)) {
                return "Touchbar";
            }
            return ShortcutDataProvider.getKeyEventText((KeyEvent)inputEvent);
        }
        if (inputEvent instanceof MouseEvent) {
            return ShortcutDataProvider.getMouseEventText((MouseEvent)inputEvent);
        }
        return null;
    }

    @Nullable
    static String getKeyEventText(@Nullable KeyEvent key) {
        if (key == null) {
            return null;
        }
        KeyStroke keystroke = KeyStroke.getKeyStrokeForEvent(key);
        return keystroke != null ? ShortcutDataProvider.getShortcutText(new KeyboardShortcut(keystroke, null)) : "Unknown";
    }

    @Nullable
    static String getMouseEventText(@Nullable MouseEvent event) {
        String modifiersText;
        int modifiers;
        int clickCount;
        if (event == null) {
            return null;
        }
        Object res = ShortcutDataProvider.getMouseButtonText(event.getButton());
        if (event.getID() == 506) {
            res = (String)res + "Drag";
        }
        if ((clickCount = event.getClickCount()) > 1) {
            res = (String)res + "(" + ShortcutDataProvider.roundClickCount(clickCount) + "x)";
        }
        if ((modifiers = event.getModifiersEx() & 0xFFFFFBFF & 0xFFFFEFFF & 0xFFFFF7FF) > 0 && !(modifiersText = ShortcutDataProvider.getLocaleUnawareKeyModifiersText(modifiers)).isEmpty()) {
            res = modifiersText + "+" + (String)res;
        }
        return res;
    }

    @NotNull
    private static String roundClickCount(int clickCount) {
        if (clickCount < 3) {
            return String.valueOf(clickCount);
        }
        if (clickCount < 5) {
            return "3-5";
        }
        if (clickCount < 25) {
            return "5-25";
        }
        if (clickCount < 100) {
            return "25-100";
        }
        return "100+";
    }

    private static String getMouseButtonText(int buttonNum) {
        switch (buttonNum) {
            case 1: {
                return "MouseLeft";
            }
            case 2: {
                return "MouseMiddle";
            }
            case 3: {
                return "MouseRight";
            }
        }
        return "NoMouseButton";
    }

    private static String getShortcutText(KeyboardShortcut shortcut) {
        String keyModifiersText;
        int modifiers = shortcut.getFirstKeyStroke().getModifiers();
        int code = shortcut.getFirstKeyStroke().getKeyCode();
        if (modifiers == 0 && DOUBLE_CLICK_MODIFIER_KEYS.contains(code)) {
            String strCode = ShortcutDataProvider.getLocaleUnawareKeyText(code);
            return strCode + "+" + strCode;
        }
        Object results = "";
        if (modifiers > 0 && !(keyModifiersText = ShortcutDataProvider.getLocaleUnawareKeyModifiersText(modifiers)).isEmpty()) {
            results = keyModifiersText + "+";
        }
        results = (String)results + ShortcutDataProvider.getLocaleUnawareKeyText(code);
        return results;
    }

    private static String getLocaleUnawareKeyText(int keyCode) {
        if (keyCode >= 48 && keyCode <= 57 || keyCode >= 65 && keyCode <= 90) {
            return String.valueOf((char)keyCode);
        }
        String knownKeyCode = (String)ourKeyCodes.get(keyCode);
        if (knownKeyCode != null) {
            return knownKeyCode;
        }
        if (keyCode >= 96 && keyCode <= 105) {
            char c = (char)(keyCode - 96 + 48);
            return "NumPad-" + c;
        }
        if ((keyCode & 0x1000000) != 0) {
            return String.valueOf((char)(keyCode ^ 0x1000000));
        }
        return "Unknown keyCode: 0x" + Integer.toString(keyCode, 16);
    }

    private static String getLocaleUnawareKeyModifiersText(int modifiers) {
        List pressed = ourModifiers.stream().filter(p -> ((Integer)p.first & modifiers) != 0).map(p -> (String)p.second).collect(Collectors.toList());
        return StringUtil.join(pressed, (String)"+");
    }

    static {
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)1024, (Object)"Button1"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)2048, (Object)"Button2"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)4096, (Object)"Button3"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)256, (Object)"Meta"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)128, (Object)"Ctrl"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)512, (Object)"Alt"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)64, (Object)"Shift"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)8192, (Object)"Alt Graph"));
        ourKeyCodes = new Int2ObjectOpenHashMap();
        ourKeyCodes.put(10, (Object)"Enter");
        ourKeyCodes.put(8, (Object)"Backspace");
        ourKeyCodes.put(9, (Object)"Tab");
        ourKeyCodes.put(3, (Object)"Cancel");
        ourKeyCodes.put(12, (Object)"Clear");
        ourKeyCodes.put(65312, (Object)"Compose");
        ourKeyCodes.put(19, (Object)"Pause");
        ourKeyCodes.put(20, (Object)"Caps Lock");
        ourKeyCodes.put(27, (Object)"Escape");
        ourKeyCodes.put(32, (Object)"Space");
        ourKeyCodes.put(33, (Object)"Page Up");
        ourKeyCodes.put(34, (Object)"Page Down");
        ourKeyCodes.put(35, (Object)"End");
        ourKeyCodes.put(36, (Object)"Home");
        ourKeyCodes.put(37, (Object)"Left");
        ourKeyCodes.put(38, (Object)"Up");
        ourKeyCodes.put(39, (Object)"Right");
        ourKeyCodes.put(40, (Object)"Down");
        ourKeyCodes.put(65368, (Object)"Begin");
        ourKeyCodes.put(16, (Object)"Shift");
        ourKeyCodes.put(17, (Object)"Control");
        ourKeyCodes.put(18, (Object)"Alt");
        ourKeyCodes.put(157, (Object)"Meta");
        ourKeyCodes.put(65406, (Object)"Alt Graph");
        ourKeyCodes.put(44, (Object)"Comma");
        ourKeyCodes.put(46, (Object)"Period");
        ourKeyCodes.put(47, (Object)"Slash");
        ourKeyCodes.put(59, (Object)"Semicolon");
        ourKeyCodes.put(61, (Object)"Equals");
        ourKeyCodes.put(91, (Object)"Open Bracket");
        ourKeyCodes.put(92, (Object)"Back Slash");
        ourKeyCodes.put(93, (Object)"Close Bracket");
        ourKeyCodes.put(106, (Object)"NumPad *");
        ourKeyCodes.put(107, (Object)"NumPad +");
        ourKeyCodes.put(108, (Object)"NumPad ,");
        ourKeyCodes.put(109, (Object)"NumPad -");
        ourKeyCodes.put(110, (Object)"NumPad .");
        ourKeyCodes.put(111, (Object)"NumPad /");
        ourKeyCodes.put(127, (Object)"Delete");
        ourKeyCodes.put(144, (Object)"Num Lock");
        ourKeyCodes.put(145, (Object)"Scroll Lock");
        ourKeyCodes.put(524, (Object)"Windows");
        ourKeyCodes.put(525, (Object)"Context Menu");
        ourKeyCodes.put(112, (Object)"F1");
        ourKeyCodes.put(113, (Object)"F2");
        ourKeyCodes.put(114, (Object)"F3");
        ourKeyCodes.put(115, (Object)"F4");
        ourKeyCodes.put(116, (Object)"F5");
        ourKeyCodes.put(117, (Object)"F6");
        ourKeyCodes.put(118, (Object)"F7");
        ourKeyCodes.put(119, (Object)"F8");
        ourKeyCodes.put(120, (Object)"F9");
        ourKeyCodes.put(121, (Object)"F10");
        ourKeyCodes.put(122, (Object)"F11");
        ourKeyCodes.put(123, (Object)"F12");
        ourKeyCodes.put(61440, (Object)"F13");
        ourKeyCodes.put(61441, (Object)"F14");
        ourKeyCodes.put(61442, (Object)"F15");
        ourKeyCodes.put(61443, (Object)"F16");
        ourKeyCodes.put(61444, (Object)"F17");
        ourKeyCodes.put(61445, (Object)"F18");
        ourKeyCodes.put(61446, (Object)"F19");
        ourKeyCodes.put(61447, (Object)"F20");
        ourKeyCodes.put(61448, (Object)"F21");
        ourKeyCodes.put(61449, (Object)"F22");
        ourKeyCodes.put(61450, (Object)"F23");
        ourKeyCodes.put(61451, (Object)"F24");
        ourKeyCodes.put(154, (Object)"Print Screen");
        ourKeyCodes.put(155, (Object)"Insert");
        ourKeyCodes.put(156, (Object)"Help");
        ourKeyCodes.put(192, (Object)"Back Quote");
        ourKeyCodes.put(222, (Object)"Quote");
        ourKeyCodes.put(224, (Object)"Up");
        ourKeyCodes.put(225, (Object)"Down");
        ourKeyCodes.put(226, (Object)"Left");
        ourKeyCodes.put(227, (Object)"Right");
        ourKeyCodes.put(128, (Object)"Dead Grave");
        ourKeyCodes.put(129, (Object)"Dead Acute");
        ourKeyCodes.put(130, (Object)"Dead Circumflex");
        ourKeyCodes.put(131, (Object)"Dead Tilde");
        ourKeyCodes.put(132, (Object)"Dead Macron");
        ourKeyCodes.put(133, (Object)"Dead Breve");
        ourKeyCodes.put(134, (Object)"Dead Above Dot");
        ourKeyCodes.put(135, (Object)"Dead Diaeresis");
        ourKeyCodes.put(136, (Object)"Dead Above Ring");
        ourKeyCodes.put(137, (Object)"Dead Double Acute");
        ourKeyCodes.put(138, (Object)"Dead Caron");
        ourKeyCodes.put(139, (Object)"Dead Cedilla");
        ourKeyCodes.put(140, (Object)"Dead Ogonek");
        ourKeyCodes.put(141, (Object)"Dead Iota");
        ourKeyCodes.put(142, (Object)"Dead Voiced Sound");
        ourKeyCodes.put(143, (Object)"Dead Semivoiced Sound");
        ourKeyCodes.put(150, (Object)"Ampersand");
        ourKeyCodes.put(151, (Object)"Asterisk");
        ourKeyCodes.put(152, (Object)"Double Quote");
        ourKeyCodes.put(153, (Object)"Less");
        ourKeyCodes.put(160, (Object)"Greater");
        ourKeyCodes.put(161, (Object)"Left Brace");
        ourKeyCodes.put(162, (Object)"Right Brace");
        ourKeyCodes.put(512, (Object)"At");
        ourKeyCodes.put(513, (Object)"Colon");
        ourKeyCodes.put(514, (Object)"Circumflex");
        ourKeyCodes.put(515, (Object)"Dollar");
        ourKeyCodes.put(516, (Object)"Euro");
        ourKeyCodes.put(517, (Object)"Exclamation Mark");
        ourKeyCodes.put(518, (Object)"Inverted Exclamation Mark");
        ourKeyCodes.put(519, (Object)"Left Parenthesis");
        ourKeyCodes.put(520, (Object)"Number Sign");
        ourKeyCodes.put(45, (Object)"Minus");
        ourKeyCodes.put(521, (Object)"Plus");
        ourKeyCodes.put(522, (Object)"Right Parenthesis");
        ourKeyCodes.put(523, (Object)"Underscore");
        ourKeyCodes.put(24, (Object)"Final");
        ourKeyCodes.put(28, (Object)"Convert");
        ourKeyCodes.put(29, (Object)"No Convert");
        ourKeyCodes.put(30, (Object)"Accept");
        ourKeyCodes.put(31, (Object)"Mode Change");
        ourKeyCodes.put(21, (Object)"Kana");
        ourKeyCodes.put(25, (Object)"Kanji");
        ourKeyCodes.put(240, (Object)"Alphanumeric");
        ourKeyCodes.put(241, (Object)"Katakana");
        ourKeyCodes.put(242, (Object)"Hiragana");
        ourKeyCodes.put(243, (Object)"Full-Width");
        ourKeyCodes.put(244, (Object)"Half-Width");
        ourKeyCodes.put(245, (Object)"Roman Characters");
        ourKeyCodes.put(256, (Object)"All Candidates");
        ourKeyCodes.put(257, (Object)"Previous Candidate");
        ourKeyCodes.put(258, (Object)"Code Input");
        ourKeyCodes.put(259, (Object)"Japanese Katakana");
        ourKeyCodes.put(260, (Object)"Japanese Hiragana");
        ourKeyCodes.put(261, (Object)"Japanese Roman");
        ourKeyCodes.put(262, (Object)"Kana Lock");
        ourKeyCodes.put(263, (Object)"Input Method On/Off");
        ourKeyCodes.put(65481, (Object)"Again");
        ourKeyCodes.put(65483, (Object)"Undo");
        ourKeyCodes.put(65485, (Object)"Copy");
        ourKeyCodes.put(65487, (Object)"Paste");
        ourKeyCodes.put(65489, (Object)"Cut");
        ourKeyCodes.put(65488, (Object)"Find");
        ourKeyCodes.put(65482, (Object)"Props");
        ourKeyCodes.put(65480, (Object)"Stop");
        ourKeyCodes.put(0, (Object)"Undefined");
    }
}

