/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.StatisticsEventMergeStrategy;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import com.jetbrains.fus.reporting.model.lion3.LogEventAction;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/statistic/eventLog/FilteredEventMergeStrategy;", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventMergeStrategy;", "ignoredFields", "", "", "(Ljava/util/Set;)V", "shouldMerge", "", "lastEvent", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "newEvent", "shouldMergeEvents", "Lcom/jetbrains/fus/reporting/model/lion3/LogEventAction;", "intellij.platform.statistics"})
public final class FilteredEventMergeStrategy
implements StatisticsEventMergeStrategy {
    private final Set<String> ignoredFields;

    @Override
    public boolean shouldMerge(@NotNull LogEvent lastEvent, @NotNull LogEvent newEvent) {
        if (Intrinsics.areEqual((Object)lastEvent.getSession(), (Object)newEvent.getSession()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)lastEvent.getBucket(), (Object)newEvent.getBucket()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)lastEvent.getBuild(), (Object)newEvent.getBuild()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)lastEvent.getRecorderVersion(), (Object)newEvent.getRecorderVersion()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)lastEvent.getGroup().getId(), (Object)newEvent.getGroup().getId()) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)lastEvent.getGroup().getVersion(), (Object)newEvent.getGroup().getVersion()) ^ true) {
            return false;
        }
        return this.shouldMergeEvents(lastEvent.getEvent(), newEvent.getEvent());
    }

    private final boolean shouldMergeEvents(LogEventAction lastEvent, LogEventAction newEvent) {
        if (lastEvent.getState() || newEvent.getState()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)lastEvent.getId(), (Object)newEvent.getId()) ^ true) {
            return false;
        }
        if (lastEvent.getData().size() != newEvent.getData().size()) {
            return false;
        }
        Map map = lastEvent.getData();
        for (Map.Entry datum : map.entrySet()) {
            Object value;
            String key = (String)datum.getKey();
            if (this.ignoredFields.contains(key) || (value = newEvent.getData().get(key)) != null && !(Intrinsics.areEqual(value, datum.getValue()) ^ true)) continue;
            return false;
        }
        return true;
    }

    public FilteredEventMergeStrategy(@NotNull Set<String> ignoredFields) {
        this.ignoredFields = ignoredFields;
    }
}

