/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.application.Topics;
import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.internal.statistic.config.EventLogOptions;
import com.intellij.internal.statistic.eventLog.AnonymizedIdsCache;
import com.intellij.internal.statistic.eventLog.AtomicLazyValue;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsService;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfigOptionsListener;
import com.intellij.internal.statistic.eventLog.MachineId;
import com.intellij.internal.statistic.eventLog.fus.MachineIdManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.MathUtil;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\f\u0018\u0000 %2\u00020\u0001:\u0001%B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\u001a\u0010\u001e\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u00032\u0006\u0010 \u001a\u00020\u000bH\u0002J\r\u0010\u0018\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\u0003H\u0002J\b\u0010#\u001a\u00020\u001aH\u0002J\f\u0010$\u001a\u00020\u000b*\u00020\u0003H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0010\u00a8\u0006&"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration;", "", "recorderId", "", "eventLogConfiguration", "Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration;", "sessionId", "(Ljava/lang/String;Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration;Ljava/lang/String;)V", "anonymizedCache", "Lcom/intellij/internal/statistic/eventLog/AnonymizedIdsCache;", "bucket", "", "getBucket", "()I", "deviceId", "getDeviceId", "()Ljava/lang/String;", "machineId", "Lcom/intellij/internal/statistic/eventLog/MachineId;", "getMachineId", "()Lcom/intellij/internal/statistic/eventLog/MachineId;", "machineIdReference", "Lcom/intellij/internal/statistic/eventLog/AtomicLazyValue;", "maxFilesToSend", "getMaxFilesToSend", "salt", "", "getSessionId", "anonymize", "data", "generateMachineId", "machineIdSalt", "value", "getMaxFilesToSend$intellij_platform_statistics", "getOrGenerateDeviceId", "getOrGenerateSalt", "asBucket", "Companion", "intellij.platform.statistics"})
public final class EventLogRecorderConfiguration {
    @NotNull
    private final String deviceId;
    private final int bucket;
    private final byte[] salt;
    private final AnonymizedIdsCache anonymizedCache;
    private final AtomicLazyValue<MachineId> machineIdReference;
    private final int maxFilesToSend;
    private final String recorderId;
    private final EventLogConfiguration eventLogConfiguration;
    @NotNull
    private final String sessionId;
    private static final int DEFAULT_MAX_FILES_TO_SEND = 5;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getDeviceId() {
        return this.deviceId;
    }

    public final int getBucket() {
        return this.bucket;
    }

    @NotNull
    public final MachineId getMachineId() {
        return this.machineIdReference.getValue();
    }

    public final int getMaxFilesToSend() {
        return this.maxFilesToSend;
    }

    private final MachineId generateMachineId(String machineIdSalt, int value) {
        String salt;
        String string = machineIdSalt;
        if (string == null) {
            string = salt = "";
        }
        if (Intrinsics.areEqual((Object)salt, (Object)"disabled")) {
            return MachineId.DISABLED;
        }
        int revision = value >= 0 ? value : 0;
        String machineId = MachineIdManager.INSTANCE.getAnonymizedMachineId("JetBrains" + this.recorderId, salt);
        if (machineId == null) {
            return MachineId.UNKNOWN;
        }
        return new MachineId(machineId, revision);
    }

    @NotNull
    public final String anonymize(@NotNull String data) {
        if (StringsKt.isBlank((CharSequence)data)) {
            return data;
        }
        return this.anonymizedCache.computeIfAbsent(data, (Function1<? super String, String>)((Function1)new Function1<String, String>(this){
            final /* synthetic */ EventLogRecorderConfiguration this$0;

            @NotNull
            public final String invoke(@NotNull String it) {
                return EventLogConfiguration.Companion.hashSha256(EventLogRecorderConfiguration.access$getSalt$p(this.this$0), it);
            }
            {
                this.this$0 = eventLogRecorderConfiguration;
                super(1);
            }
        }));
    }

    private final int asBucket(String $this$asBucket) {
        return MathUtil.nonNegativeAbs((int)$this$asBucket.hashCode()) % 256;
    }

    private final String getOrGenerateDeviceId() {
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment()) {
            String property = this.eventLogConfiguration.getHeadlessDeviceIdProperty$intellij_platform_statistics(this.recorderId);
            String string = System.getProperty(property);
            if (string != null) {
                String string2;
                String it = string2 = string;
                boolean bl = false;
                return it;
            }
        }
        try {
            return DeviceIdManager.getOrGenerateId(new DeviceIdManager.DeviceIdToken(){}, this.recorderId);
        }
        catch (DeviceIdManager.InvalidDeviceIdTokenException e) {
            EventLogConfiguration.Companion.getLOG$intellij_platform_statistics().warn("Failed retrieving device id for " + this.recorderId);
            return "000000000000000-0000-0000-0000-000000000000";
        }
    }

    private final byte[] getOrGenerateSalt() {
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment()) {
            String property = this.eventLogConfiguration.getHeadlessSaltProperty$intellij_platform_statistics(this.recorderId);
            String string = System.getProperty(property);
            if (string != null) {
                String string2;
                String it = string2 = string;
                boolean bl = false;
                String string3 = it;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = string3.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                return byArray;
            }
        }
        return EventLogConfiguration.Companion.getOrGenerateSaltFromPrefs(this.recorderId);
    }

    public final int getMaxFilesToSend$intellij_platform_statistics() {
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isHeadlessEnvironment()) {
            Integer value;
            String property = this.eventLogConfiguration.getHeadlessMaxFilesToSendProperty$intellij_platform_statistics(this.recorderId);
            String string = System.getProperty(property);
            Integer n = value = string != null ? StringsKt.toIntOrNull((String)string) : null;
            if (value != null && (value == -1 || value >= 0)) {
                return value;
            }
        }
        return 5;
    }

    @NotNull
    public final String getSessionId() {
        return this.sessionId;
    }

    public EventLogRecorderConfiguration(@NotNull String recorderId, @NotNull EventLogConfiguration eventLogConfiguration, @NotNull String sessionId) {
        this.recorderId = recorderId;
        this.eventLogConfiguration = eventLogConfiguration;
        this.sessionId = sessionId;
        this.deviceId = this.getOrGenerateDeviceId();
        this.bucket = this.asBucket(this.deviceId);
        this.salt = this.getOrGenerateSalt();
        this.anonymizedCache = new AnonymizedIdsCache();
        this.maxFilesToSend = this.getMaxFilesToSend$intellij_platform_statistics();
        final EventLogOptions configOptions = EventLogConfigOptionsService.getInstance().getOptions(this.recorderId);
        this.machineIdReference = new AtomicLazyValue((Function0)new Function0<MachineId>(){

            @NotNull
            public final MachineId invoke() {
                return this.generateMachineId(configOptions.getMachineIdSalt(), configOptions.getMachineIdRevision());
            }
        });
        Topics.subscribe(EventLogConfigOptionsService.TOPIC, null, (Object)new EventLogRecorderConfigOptionsListener(this.recorderId){

            @Override
            public void onMachineIdConfigurationChanged(@Nullable String salt, int revision) {
                machineIdReference.updateAndGet((Function1)new Function1<MachineId, MachineId>(this, salt, revision){
                    final /* synthetic */ 2 this$0;
                    final /* synthetic */ String $salt;
                    final /* synthetic */ int $revision;

                    @NotNull
                    public final MachineId invoke(@NotNull MachineId prevValue) {
                        return this.$salt != null && this.$revision != -1 && this.$revision > prevValue.getRevision() ? EventLogRecorderConfiguration.access$generateMachineId(this.this$0.this, this.$salt, this.$revision) : prevValue;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$salt = string;
                        this.$revision = n;
                        super(1);
                    }
                });
            }
        });
    }

    public /* synthetic */ EventLogRecorderConfiguration(String string, EventLogConfiguration eventLogConfiguration, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = EventLogConfiguration.Companion.generateSessionId$intellij_platform_statistics();
        }
        this(string, eventLogConfiguration, string2);
    }

    public static final /* synthetic */ byte[] access$getSalt$p(EventLogRecorderConfiguration $this) {
        return $this.salt;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration$Companion;", "", "()V", "DEFAULT_MAX_FILES_TO_SEND", "", "intellij.platform.statistics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

