/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.DefaultFilesToSendProvider;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogFilesProvider;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogSendConfig;
import com.intellij.internal.statistic.eventLog.FilesToSendProvider;
import com.intellij.internal.statistic.eventLog.MachineId;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class EventLogInternalSendConfig
implements EventLogSendConfig {
    private final String myRecorderId;
    private final String myDeviceId;
    private final int myBucket;
    private final MachineId myMachineId;
    private final boolean myFilterActiveFile;

    private EventLogInternalSendConfig(@NotNull String recorderId, @NotNull EventLogRecorderConfiguration config, boolean filterActiveFile) {
        this.myRecorderId = recorderId;
        this.myDeviceId = config.getDeviceId();
        this.myBucket = config.getBucket();
        this.myMachineId = config.getMachineId();
        this.myFilterActiveFile = filterActiveFile;
    }

    @NotNull
    public static EventLogInternalSendConfig createByRecorder(@NotNull String recorderId, boolean filterActiveFile) {
        EventLogRecorderConfiguration config = EventLogConfiguration.getInstance().getOrCreate(recorderId);
        return new EventLogInternalSendConfig(recorderId, config, filterActiveFile);
    }

    @Override
    @NotNull
    public String getDeviceId() {
        return this.myDeviceId;
    }

    @Override
    public int getBucket() {
        return this.myBucket;
    }

    @Override
    @NotNull
    public MachineId getMachineId() {
        return this.myMachineId;
    }

    @Override
    @NotNull
    public String getRecorderId() {
        return this.myRecorderId;
    }

    @Override
    public boolean isSendEnabled() {
        return StatisticsEventLogProviderUtil.getEventLogProvider(this.myRecorderId).isSendEnabled();
    }

    @Override
    @NotNull
    public FilesToSendProvider getFilesToSendProvider() {
        int maxFilesToSend = EventLogConfiguration.getInstance().getOrCreate(this.myRecorderId).getMaxFilesToSend();
        EventLogFilesProvider logFilesProvider = StatisticsEventLogProviderUtil.getEventLogProvider(this.myRecorderId).getLogFilesProvider();
        return new DefaultFilesToSendProvider(logFilesProvider, maxFilesToSend, this.myFilterActiveFile);
    }
}

