/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.DataCollectorSystemEventLogger;
import com.intellij.internal.statistic.eventLog.EventLogAppConnectionSettings;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogEndpointSubstitutor;
import com.intellij.internal.statistic.eventLog.EventLogSystemLogger;
import com.intellij.internal.statistic.eventLog.ExternalEventLogSettings;
import com.intellij.internal.statistic.eventLog.InternalDataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.connection.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.EventLogStatisticsService;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class EventLogInternalApplicationInfo
implements EventLogApplicationInfo {
    private static final DataCollectorDebugLogger LOG = new InternalDataCollectorDebugLogger(Logger.getInstance(EventLogStatisticsService.class));
    private final boolean myIsTest;
    private final DataCollectorSystemEventLogger myEventLogger;
    private final EventLogAppConnectionSettings myConnectionSettings;

    @Deprecated(forRemoval=true)
    public EventLogInternalApplicationInfo(@NotNull String recorderId, boolean isTest) {
        this(isTest);
    }

    public EventLogInternalApplicationInfo(boolean isTest) {
        this.myIsTest = isTest;
        this.myConnectionSettings = new EventLogAppConnectionSettings();
        this.myEventLogger = new DataCollectorSystemEventLogger(){

            @Override
            public void logErrorEvent(@NotNull String recorderId, @NotNull String eventId, @NotNull Throwable exception) {
                EventLogSystemLogger.logSystemError(recorderId, eventId, exception.getClass().getName(), -1L);
            }
        };
    }

    @Override
    @NotNull
    public String getTemplateUrl() {
        ExternalEventLogSettings externalEventLogSettings2 = StatisticsEventLogProviderUtil.getExternalEventLogSettings();
        if (externalEventLogSettings2 != null) {
            String result = externalEventLogSettings2.getTemplateUrl();
            return result == null ? EventLogInternalApplicationInfo.getDefaultTemplateUrl() : result;
        }
        if (ApplicationManager.getApplication().getExtensionArea().hasExtensionPoint(EventLogEndpointSubstitutor.EP_NAME.getName())) {
            EventLogEndpointSubstitutor validSubstitutor = (EventLogEndpointSubstitutor)EventLogEndpointSubstitutor.EP_NAME.findFirstSafe(substitutor -> PluginInfoDetectorKt.getPluginInfo(substitutor.getClass()).isAllowedToInjectIntoFUS());
            String result = validSubstitutor == null ? null : validSubstitutor.getTemplateUrl();
            return result == null ? EventLogInternalApplicationInfo.getDefaultTemplateUrl() : result;
        }
        return EventLogInternalApplicationInfo.getDefaultTemplateUrl();
    }

    private static String getDefaultTemplateUrl() {
        return ((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEventLogSettingsUrl();
    }

    @Override
    @NotNull
    public String getProductCode() {
        return ApplicationInfo.getInstance().getBuild().getProductCode();
    }

    @Override
    @NotNull
    public String getProductVersion() {
        ApplicationInfo info = ApplicationInfo.getInstance();
        return info.getMajorVersion() + "." + info.getMinorVersion();
    }

    @Override
    @NotNull
    public EventLogConnectionSettings getConnectionSettings() {
        return this.myConnectionSettings;
    }

    @Override
    public boolean isInternal() {
        return StatisticsUploadAssistant.isTestStatisticsEnabled();
    }

    @Override
    public boolean isTest() {
        return this.myIsTest;
    }

    @Override
    public boolean isEAP() {
        return ApplicationManager.getApplication().isEAP();
    }

    @Override
    @NotNull
    public DataCollectorDebugLogger getLogger() {
        return LOG;
    }

    @Override
    @NotNull
    public DataCollectorSystemEventLogger getEventLogger() {
        return this.myEventLogger;
    }
}

