/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.config.eventLog.EventLogBuildType;
import java.io.File;
import java.nio.file.Path;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\rJ\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\t\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "component1", "copy", "equals", "", "other", "getType", "Lcom/intellij/internal/statistic/config/eventLog/EventLogBuildType;", "defaultType", "hashCode", "", "parseType", "", "toString", "Companion", "intellij.platform.statistics.uploader"})
public final class EventLogFile {
    @NotNull
    private final File file;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final EventLogBuildType getType(@NotNull EventLogBuildType defaultType) {
        String string = this.parseType();
        return Intrinsics.areEqual((Object)string, (Object)EventLogBuildType.EAP.text) ? EventLogBuildType.EAP : (Intrinsics.areEqual((Object)string, (Object)EventLogBuildType.RELEASE.text) ? EventLogBuildType.RELEASE : defaultType);
    }

    public static /* synthetic */ EventLogBuildType getType$default(EventLogFile eventLogFile, EventLogBuildType eventLogBuildType, int n, Object object) {
        if ((n & 1) != 0) {
            eventLogBuildType = EventLogBuildType.UNKNOWN;
        }
        return eventLogFile.getType(eventLogBuildType);
    }

    private final String parseType() {
        String name = this.file.getName();
        int separator = StringsKt.lastIndexOf$default((CharSequence)name, (String)"-", (int)0, (boolean)false, (int)6, null);
        if (separator + 1 < name.length()) {
            String string;
            int n = separator + 1;
            int n2 = 0;
            int startIndex = Math.max(n, n2);
            int endIndex = StringsKt.indexOf$default((CharSequence)name, (String)".", (int)startIndex, (boolean)false, (int)4, null);
            if (endIndex < 0) {
                String string2 = name;
                String string3 = string2.substring(startIndex);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                String string4 = name;
                String string5 = string4.substring(startIndex, endIndex);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            return string;
        }
        return name;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public EventLogFile(@NotNull File file) {
        this.file = file;
    }

    @NotNull
    public final File component1() {
        return this.file;
    }

    @NotNull
    public final EventLogFile copy(@NotNull File file) {
        return new EventLogFile(file);
    }

    public static /* synthetic */ EventLogFile copy$default(EventLogFile eventLogFile, File file, int n, Object object) {
        if ((n & 1) != 0) {
            file = eventLogFile.file;
        }
        return eventLogFile.copy(file);
    }

    @NotNull
    public String toString() {
        return "EventLogFile(file=" + this.file + ")";
    }

    public int hashCode() {
        File file = this.file;
        return file != null ? ((Object)file).hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof EventLogFile)) break block3;
                EventLogFile eventLogFile = (EventLogFile)object;
                if (!Intrinsics.areEqual((Object)this.file, (Object)eventLogFile.file)) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final EventLogFile create(@NotNull Path dir, @NotNull EventLogBuildType buildType, @NotNull String suffix) {
        return Companion.create(dir, buildType, suffix);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogFile$Companion;", "", "()V", "create", "Lcom/intellij/internal/statistic/eventLog/EventLogFile;", "dir", "Ljava/nio/file/Path;", "buildType", "Lcom/intellij/internal/statistic/config/eventLog/EventLogBuildType;", "suffix", "", "newName", "intellij.platform.statistics.uploader"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final EventLogFile create(@NotNull Path dir, @NotNull EventLogBuildType buildType, @NotNull String suffix) {
            File file = dir.resolve(this.newName(buildType, suffix)).toFile();
            while (file.exists()) {
                file = dir.resolve(this.newName(buildType, suffix)).toFile();
            }
            return new EventLogFile(file);
        }

        private final String newName(EventLogBuildType buildType, String suffix) {
            String string;
            CharSequence charSequence;
            String rand = UUID.randomUUID().toString();
            int start = StringsKt.indexOf$default((CharSequence)rand, (char)'-', (int)0, (boolean)false, (int)6, null);
            if (start > 0 && start + 1 < rand.length()) {
                charSequence = rand;
                int n = start + 1;
                String string2 = ((String)charSequence).substring(n);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string = rand;
            }
            String unique = string;
            charSequence = suffix;
            return charSequence.length() > 0 ? unique + "-" + suffix + "-" + buildType.text + ".log" : unique + "-" + buildType.text + ".log";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

