/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfiguration;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.DigestUtil;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.Preferences;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0007J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0015\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0018J\u0015\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001cJ\u000e\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\bJ\u0018\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\f\u0010 \u001a\u00020\b*\u00020!H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration;", "", "()V", "bucket", "", "getBucket", "()I", "build", "", "getBuild", "()Ljava/lang/String;", "build$delegate", "Lkotlin/Lazy;", "configurations", "", "Lcom/intellij/internal/statistic/eventLog/EventLogRecorderConfiguration;", "defaultConfiguration", "anonymize", "data", "getEventLogDataPath", "Ljava/nio/file/Path;", "getEventLogSettingsPath", "getHeadlessDeviceIdProperty", "recorderId", "getHeadlessDeviceIdProperty$intellij_platform_statistics", "getHeadlessMaxFilesToSendProperty", "getHeadlessMaxFilesToSendProperty$intellij_platform_statistics", "getHeadlessSaltProperty", "getHeadlessSaltProperty$intellij_platform_statistics", "getOrCreate", "getRecorderBasedProperty", "property", "asBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "Companion", "intellij.platform.statistics"})
@ApiStatus.Internal
public final class EventLogConfiguration {
    private final EventLogRecorderConfiguration defaultConfiguration = new EventLogRecorderConfiguration("FUS", this, Companion.getDefaultSessionId());
    private final Map<String, EventLogRecorderConfiguration> configurations = new HashMap();
    @NotNull
    private final Lazy build$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
        final /* synthetic */ EventLogConfiguration this$0;

        @NotNull
        public final String invoke() {
            return EventLogConfiguration.access$asBuildNumber(this.this$0, ApplicationInfo.getInstance().getBuild());
        }
        {
            this.this$0 = eventLogConfiguration;
            super(0);
        }
    }));
    private final int bucket = this.defaultConfiguration.getBucket();
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String UNDEFINED_DEVICE_ID = "000000000000000-0000-0000-0000-000000000000";
    private static final String FUS_RECORDER = "FUS";
    private static final String SALT_PREFERENCE_KEY = "feature_usage_event_log_salt";
    private static final String IDEA_HEADLESS_STATISTICS_DEVICE_ID = "idea.headless.statistics.device.id";
    private static final String IDEA_HEADLESS_STATISTICS_SALT = "idea.headless.statistics.salt";
    private static final String IDEA_HEADLESS_STATISTICS_MAX_FILES_TO_SEND = "idea.headless.statistics.max.files.to.send";
    @NotNull
    private static final Lazy defaultSessionId$delegate;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String getBuild() {
        Lazy lazy = this.build$delegate;
        EventLogConfiguration eventLogConfiguration = this;
        Object var3_3 = null;
        return (String)lazy.getValue();
    }

    public final int getBucket() {
        return this.bucket;
    }

    @Deprecated(message="Call method on configuration created with getOrCreate method")
    @NotNull
    public final String anonymize(@NotNull String data) {
        return this.defaultConfiguration.anonymize(data);
    }

    private final String asBuildNumber(BuildNumber $this$asBuildNumber) {
        String str = $this$asBuildNumber.asStringWithoutProductCodeAndSnapshot();
        return StringsKt.endsWith$default((String)str, (String)".", (boolean)false, (int)2, null) ? str + "0" : str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final EventLogRecorderConfiguration getOrCreate(@NotNull String recorderId) {
        EventLogConfiguration eventLogConfiguration;
        if (EventLogConfiguration.Companion.isDefaultRecorderId(recorderId)) {
            return this.defaultConfiguration;
        }
        EventLogConfiguration eventLogConfiguration2 = eventLogConfiguration = this;
        synchronized (eventLogConfiguration2) {
            Object object;
            void $this$getOrPut$iv;
            boolean bl = false;
            Map<String, EventLogRecorderConfiguration> map = this.configurations;
            String key$iv = recorderId;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                EventLogRecorderConfiguration answer$iv = new EventLogRecorderConfiguration(recorderId, this, null, 4, null);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            EventLogRecorderConfiguration eventLogRecorderConfiguration = (EventLogRecorderConfiguration)object;
            return eventLogRecorderConfiguration;
        }
    }

    @NotNull
    public final Path getEventLogDataPath() {
        return Paths.get(PathManager.getSystemPath(), new String[0]).resolve("event-log-data");
    }

    @NotNull
    public final Path getEventLogSettingsPath() {
        return this.getEventLogDataPath().resolve("settings");
    }

    @NotNull
    public final String getHeadlessDeviceIdProperty$intellij_platform_statistics(@NotNull String recorderId) {
        return this.getRecorderBasedProperty(recorderId, IDEA_HEADLESS_STATISTICS_DEVICE_ID);
    }

    @NotNull
    public final String getHeadlessSaltProperty$intellij_platform_statistics(@NotNull String recorderId) {
        return this.getRecorderBasedProperty(recorderId, IDEA_HEADLESS_STATISTICS_SALT);
    }

    @NotNull
    public final String getHeadlessMaxFilesToSendProperty$intellij_platform_statistics(@NotNull String recorderId) {
        return this.getRecorderBasedProperty(recorderId, IDEA_HEADLESS_STATISTICS_MAX_FILES_TO_SEND);
    }

    private final String getRecorderBasedProperty(String recorderId, String property) {
        return EventLogConfiguration.Companion.isDefaultRecorderId(recorderId) ? property : property + "." + StringUtil.toLowerCase((String)recorderId);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(EventLogConfiguration.class);
        defaultSessionId$delegate = LazyKt.lazy((Function0)Companion.defaultSessionId.2.INSTANCE);
    }

    public static final /* synthetic */ String access$asBuildNumber(EventLogConfiguration $this, BuildNumber $this$access_u24asBuildNumber) {
        return $this.asBuildNumber($this$access_u24asBuildNumber);
    }

    @JvmStatic
    @NotNull
    public static final EventLogConfiguration getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0014\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0004J\u0015\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001cJ\u0016\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0004J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\f\u0010\"\u001a\u00020\u0004*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration$Companion;", "", "()V", "FUS_RECORDER", "", "IDEA_HEADLESS_STATISTICS_DEVICE_ID", "IDEA_HEADLESS_STATISTICS_MAX_FILES_TO_SEND", "IDEA_HEADLESS_STATISTICS_SALT", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$intellij_platform_statistics", "()Lcom/intellij/openapi/diagnostic/Logger;", "SALT_PREFERENCE_KEY", "UNDEFINED_DEVICE_ID", "defaultSessionId", "getDefaultSessionId", "()Ljava/lang/String;", "defaultSessionId$delegate", "Lkotlin/Lazy;", "generateSessionId", "generateSessionId$intellij_platform_statistics", "getInstance", "Lcom/intellij/internal/statistic/eventLog/EventLogConfiguration;", "getOrGenerateSaltFromPrefs", "", "recorderId", "getSaltPropertyKey", "getSaltPropertyKey$intellij_platform_statistics", "hashSha256", "salt", "data", "isDefaultRecorderId", "", "shortedUUID", "intellij.platform.statistics"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG$intellij_platform_statistics() {
            return LOG;
        }

        @JvmStatic
        @NotNull
        public final EventLogConfiguration getInstance() {
            return (EventLogConfiguration)ApplicationManager.getApplication().getService(EventLogConfiguration.class);
        }

        @NotNull
        public final String hashSha256(@NotNull byte[] salt, @NotNull String data) {
            MessageDigest md = DigestUtil.sha256();
            md.update(salt);
            String string = data;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            md.update(byArray);
            return StringUtil.toHexString((byte[])md.digest());
        }

        @NotNull
        public final byte[] getOrGenerateSaltFromPrefs(@NotNull String recorderId) {
            String string;
            String companyName = ApplicationInfoImpl.getShadowInstance().getShortCompanyName();
            if (StringUtil.isEmptyOrSpaces((String)companyName)) {
                string = "jetbrains";
            } else {
                String string2 = companyName;
                Locale locale = Locale.US;
                String string3 = string2.toLowerCase(locale);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            }
            String name = string;
            Preferences prefs = Preferences.userRoot().node(name);
            String saltKey = this.getSaltPropertyKey$intellij_platform_statistics(recorderId);
            byte[] salt = prefs.getByteArray(saltKey, null);
            if (salt == null) {
                salt = new byte[32];
                new SecureRandom().nextBytes(salt);
                prefs.putByteArray(saltKey, salt);
                this.getLOG$intellij_platform_statistics().info("Generating new salt for " + recorderId);
            }
            return salt;
        }

        @NotNull
        public final String getDefaultSessionId() {
            Lazy lazy = defaultSessionId$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String generateSessionId$intellij_platform_statistics() {
            String presentableHour = StatisticsUtil.getCurrentHourInUTC$default(StatisticsUtil.INSTANCE, null, 1, null);
            return presentableHour + "-" + this.shortedUUID(UUID.randomUUID().toString());
        }

        private final String shortedUUID(String $this$shortedUUID) {
            int start = StringsKt.lastIndexOf$default((CharSequence)$this$shortedUUID, (char)'-', (int)0, (boolean)false, (int)6, null);
            if (start > 0 && start + 1 < $this$shortedUUID.length()) {
                String string = $this$shortedUUID;
                int n = start + 1;
                String string2 = string.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                return string2;
            }
            return $this$shortedUUID;
        }

        private final boolean isDefaultRecorderId(String recorderId) {
            return Intrinsics.areEqual((Object)EventLogConfiguration.FUS_RECORDER, (Object)recorderId);
        }

        @NotNull
        public final String getSaltPropertyKey$intellij_platform_statistics(@NotNull String recorderId) {
            return this.isDefaultRecorderId(recorderId) ? EventLogConfiguration.SALT_PREFERENCE_KEY : StringUtil.toLowerCase((String)recorderId) + "_feature_usage_event_log_salt";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

