/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.config.EventLogOptions;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsListener;
import com.intellij.internal.statistic.eventLog.validator.storage.EventLogMetadataLoader;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
public final class EventLogConfigOptionsService {
    public static final Topic<EventLogConfigOptionsListener> TOPIC = new Topic(EventLogConfigOptionsListener.class, Topic.BroadcastDirection.NONE);
    private static final Set<String> ourOptions = Set.of("dataThreshold", "groupDataThreshold", "groupAlertThreshold", "id_salt_revision", "id_salt");

    public static EventLogConfigOptionsService getInstance() {
        return (EventLogConfigOptionsService)ApplicationManager.getApplication().getService(EventLogConfigOptionsService.class);
    }

    public void updateOptions(@NotNull String recorderId, @NotNull EventLogMetadataLoader loader) {
        Map newOptions;
        EventLogMetadataSettingsPersistence persisted = EventLogMetadataSettingsPersistence.getInstance();
        Map<String, String> changedOptions = persisted.updateOptions(recorderId, newOptions = ContainerUtil.filter(loader.getOptionValues(), option -> ourOptions.contains(option)));
        if (!changedOptions.isEmpty()) {
            ((EventLogConfigOptionsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).optionsChanged(recorderId, changedOptions);
        }
    }

    @NotNull
    public EventLogOptions getOptions(@NotNull String recorderId) {
        return new EventLogOptions(EventLogMetadataSettingsPersistence.getInstance().getOptions(recorderId));
    }

    public static abstract class EventLogThresholdConfigOptionsListener
    implements EventLogConfigOptionsListener {
        private final String myRecorderId;

        protected EventLogThresholdConfigOptionsListener(@NotNull String recorderId) {
            this.myRecorderId = recorderId;
        }

        @Override
        public void optionsChanged(@NotNull String recorderId, @NotNull Map<String, String> options) {
            if (StringUtil.equals((CharSequence)this.myRecorderId, (CharSequence)recorderId)) {
                for (Map.Entry<String, String> entry : options.entrySet()) {
                    String name = entry.getKey();
                    String value = entry.getValue();
                    if (StringUtil.equals((CharSequence)name, (CharSequence)"dataThreshold")) {
                        this.onThresholdChanged(EventLogOptions.tryParseInt(value));
                    }
                    if (StringUtil.equals((CharSequence)name, (CharSequence)"groupDataThreshold")) {
                        this.onGroupThresholdChanged(EventLogOptions.tryParseInt(value));
                    }
                    if (!StringUtil.equals((CharSequence)name, (CharSequence)"groupAlertThreshold")) continue;
                    this.onGroupAlertThresholdChanged(EventLogOptions.tryParseInt(value));
                }
            }
        }

        public abstract void onThresholdChanged(int var1);

        public abstract void onGroupThresholdChanged(int var1);

        public abstract void onGroupAlertThresholdChanged(int var1);
    }
}

