/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.ide.ui.IdeUiService;
import com.intellij.internal.statistic.eventLog.ExternalEventLogSettings;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.connection.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.request.StatsProxyInfo;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogAppConnectionSettings
implements EventLogConnectionSettings {
    private static final StatsProxyInfo NO_PROXY = new StatsProxyInfo(Proxy.NO_PROXY, null);

    @Override
    @NotNull
    public String getUserAgent() {
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isDisposed()) {
            String productName = ApplicationNamesInfo.getInstance().getFullProductName();
            String version = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
            return productName + "/" + version;
        }
        return "IntelliJ";
    }

    @Override
    @NotNull
    public StatsProxyInfo selectProxy(@NotNull String url) {
        Proxy proxy;
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isDisposed() && (proxy = EventLogAppConnectionSettings.findProxy(url)) != Proxy.NO_PROXY) {
            return new StatsProxyInfo(proxy, EventLogAppConnectionSettings.getAuthProvider());
        }
        return NO_PROXY;
    }

    @Override
    @Nullable
    public SSLContext getSSLContext() {
        return IdeUiService.getInstance().getSslContext();
    }

    @Override
    @NotNull
    public Map<String, String> getExtraHeaders() {
        ExternalEventLogSettings externalEventLogSettings2 = StatisticsEventLogProviderUtil.getExternalEventLogSettings();
        if (externalEventLogSettings2 != null) {
            return externalEventLogSettings2.getExtraLogUploadHeaders();
        }
        return Collections.emptyMap();
    }

    @Nullable
    private static StatsProxyInfo.StatsProxyAuthProvider getAuthProvider() {
        if (IdeUiService.getInstance().isProxyAuth()) {
            return EventLogAppProxyAuth.INSTANCE;
        }
        return null;
    }

    @NotNull
    private static Proxy findProxy(@NotNull String url) {
        try {
            List proxies = IdeUiService.getInstance().getProxyList(new URL(url));
            return !proxies.isEmpty() ? (Proxy)proxies.get(0) : Proxy.NO_PROXY;
        }
        catch (MalformedURLException malformedURLException) {
            return Proxy.NO_PROXY;
        }
    }

    private static class EventLogAppProxyAuth
    implements StatsProxyInfo.StatsProxyAuthProvider {
        private static final EventLogAppProxyAuth INSTANCE = new EventLogAppProxyAuth();

        private EventLogAppProxyAuth() {
        }

        @Override
        @Nullable
        public String getProxyLogin() {
            return IdeUiService.getInstance().getProxyLogin();
        }

        @Override
        @Nullable
        public String getProxyPassword() {
            return IdeUiService.getInstance().getPlainProxyPassword();
        }
    }
}

