/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.config.eventLog;

import com.intellij.internal.statistic.config.StatisticsStringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum EventLogBuildType {
    EAP("eap"),
    RELEASE("release"),
    UNKNOWN("unknown");

    private static final String ALL = "all";
    public final String text;

    private EventLogBuildType(String text) {
        this.text = text;
    }

    public static EventLogBuildType @NotNull [] getTypesByString(@Nullable String type) {
        if (StatisticsStringUtil.isNotEmpty(type)) {
            String unifiedType = StatisticsStringUtil.toLowerCase(type);
            if (ALL.equals(unifiedType)) {
                return EventLogBuildType.values();
            }
            for (EventLogBuildType value : EventLogBuildType.values()) {
                if (!unifiedType.equals(value.text)) continue;
                return new EventLogBuildType[]{value};
            }
        }
        return new EventLogBuildType[0];
    }
}

