/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.config;

import com.google.gson.GsonBuilder;
import com.intellij.internal.statistic.config.EventLogConfigParserException;
import com.intellij.internal.statistic.config.EventLogExternalSendSettings;
import com.intellij.internal.statistic.config.bean.EventLogBucketRange;
import com.intellij.internal.statistic.config.bean.EventLogConfigVersions;
import com.intellij.internal.statistic.config.bean.EventLogSendConfiguration;
import com.intellij.internal.statistic.config.eventLog.EventLogBuildType;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogExternalSettings {
    public static final EventLogExternalSendSettings EMPTY = new EventLogExternalSendSettings(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    public String productCode;
    public List<EventLogConfigVersions> versions;

    @NotNull
    public static EventLogExternalSendSettings parseSendSettings(@NotNull Reader reader, @NotNull String version) throws EventLogConfigParserException {
        try {
            EventLogExternalSettings parsed = (EventLogExternalSettings)new GsonBuilder().create().fromJson(reader, EventLogExternalSettings.class);
            if (parsed != null) {
                return parsed.toSendSettings(version);
            }
        }
        catch (Exception e) {
            throw new EventLogConfigParserException(e);
        }
        return EMPTY;
    }

    @NotNull
    private EventLogExternalSendSettings toSendSettings(@NotNull String productVersion) {
        EventLogConfigVersions version = this.findMajorVersion(productVersion);
        if (version == null) {
            return EMPTY;
        }
        EnumMap<EventLogBuildType, EventLogSendConfiguration> configurations = new EnumMap<EventLogBuildType, EventLogSendConfiguration>(EventLogBuildType.class);
        for (EventLogConfigVersions.EventLogConfigFilterCondition filter : version.getFilters()) {
            EventLogBuildType[] types;
            for (EventLogBuildType type : types = EventLogBuildType.getTypesByString(filter.releaseType)) {
                EventLogBucketRange range = filter.getBucketRange();
                if (range == null) continue;
                if (!configurations.containsKey((Object)type)) {
                    configurations.put(type, new EventLogSendConfiguration(new ArrayList<EventLogBucketRange>()));
                }
                ((EventLogSendConfiguration)configurations.get((Object)type)).addBucketRange(range);
            }
        }
        return new EventLogExternalSendSettings(version.getEndpoints(), version.getOptions(), configurations);
    }

    @Nullable
    private EventLogConfigVersions findMajorVersion(@NotNull String productVersion) {
        if (this.versions == null || this.versions.isEmpty()) {
            return null;
        }
        return this.versions.stream().filter(v -> v.majorBuildVersionBorders != null && v.majorBuildVersionBorders.accept(productVersion)).findFirst().orElse(null);
    }
}

