/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.PluginType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassNameRuleValidator
extends CustomValidationRule {
    @Override
    @NotNull
    public String getRuleId() {
        return "class_name";
    }

    @Override
    public boolean acceptRuleId(@Nullable String ruleId) {
        return "dialog_class".equals(ruleId) || "quick_fix_class_name".equals(ruleId) || this.getRuleId().equals(ruleId);
    }

    @NotNull
    protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
        if (ClassNameRuleValidator.isThirdPartyValue(data)) {
            return ValidationResultType.ACCEPTED;
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(ClassNameRuleValidator.getClassName(data));
        context.setPayload(PLUGIN_INFO, (Object)info);
        if (info.getType() == PluginType.UNKNOWN) {
            return ValidationResultType.REJECTED;
        }
        return info.isSafeToReport() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
    }

    @NotNull
    private static String getClassName(@NotNull String data) {
        int i = data.indexOf("$$Lambda$");
        if (i == -1) {
            return data;
        }
        return data.substring(0, i);
    }
}

