/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic;

import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeviceIdManager {
    private static final Logger LOG = Logger.getInstance(DeviceIdManager.class);
    private static final String UNDEFINED = "UNDEFINED";
    private static final String DEVICE_ID_SHARED_FILE = "PermanentDeviceId";
    private static final String DEVICE_ID_PREFERENCE_KEY = "device_id";

    @Deprecated(forRemoval=true)
    public static String getOrGenerateId() {
        try {
            return DeviceIdManager.getOrGenerateId(null, UNDEFINED);
        }
        catch (InvalidDeviceIdTokenException e) {
            LOG.error((Throwable)e);
            return "";
        }
    }

    public static String getOrGenerateId(@Nullable DeviceIdToken token, @NotNull String recorderId) throws InvalidDeviceIdTokenException {
        DeviceIdManager.assertAllowed(token, recorderId);
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        Preferences prefs = DeviceIdManager.getPreferences(appInfo);
        String preferenceKey = DeviceIdManager.getPreferenceKey(recorderId);
        String deviceId = prefs.get(preferenceKey, null);
        if (StringUtil.isEmptyOrSpaces((String)deviceId)) {
            deviceId = DeviceIdManager.generateId(Calendar.getInstance(Locale.ENGLISH), DeviceIdManager.getOSChar());
            prefs.put(preferenceKey, deviceId);
            LOG.info("Generating new Device ID for '" + recorderId + "'");
        }
        if (appInfo.isVendorJetBrains() && SystemInfo.isWindows) {
            if (DeviceIdManager.isBaseRecorder(recorderId)) {
                deviceId = DeviceIdManager.syncWithSharedFile(DEVICE_ID_SHARED_FILE, deviceId, prefs, preferenceKey);
            } else {
                DeviceIdManager.deleteLegacySharedFile(recorderId + "_PermanentDeviceId");
            }
        }
        return deviceId;
    }

    private static void assertAllowed(@Nullable DeviceIdToken token, @NotNull String recorderId) throws InvalidDeviceIdTokenException {
        if (DeviceIdManager.isBaseRecorder(recorderId)) {
            if (token == null) {
                throw new InvalidDeviceIdTokenException("Cannot access base device id from unknown class");
            }
            if (!PluginInfoDetectorKt.isPlatformOrJetBrainsBundled(token.getClass())) {
                throw new InvalidDeviceIdTokenException("Cannot access base device id from " + token.getClass().getName());
            }
        } else if (!DeviceIdManager.isUndefinedRecorder(recorderId) && token == null) {
            throw new InvalidDeviceIdTokenException("Cannot access device id from unknown class");
        }
    }

    @NotNull
    private static String getPreferenceKey(@NotNull String recorderId) {
        return DeviceIdManager.isBaseRecorder(recorderId) ? DEVICE_ID_PREFERENCE_KEY : StringUtil.toLowerCase((String)recorderId) + "_device_id";
    }

    private static boolean isBaseRecorder(@NotNull String recorderId) {
        return "FUS".equals(recorderId);
    }

    private static boolean isUndefinedRecorder(@NotNull String recorderId) {
        return UNDEFINED.equals(recorderId);
    }

    @NotNull
    private static String syncWithSharedFile(@NotNull String fileName, @NotNull String installationId, @NotNull Preferences prefs, @NotNull String prefsKey) {
        File dir;
        String appdata = System.getenv("APPDATA");
        if (appdata != null && ((dir = new File(appdata, "JetBrains")).exists() || dir.mkdirs())) {
            File permanentIdFile = new File(dir, fileName);
            try {
                String fromFile = "";
                if (permanentIdFile.exists()) {
                    fromFile = DeviceIdManager.loadFromFile(permanentIdFile).trim();
                }
                if (!fromFile.isEmpty()) {
                    if (!fromFile.equals(installationId)) {
                        installationId = fromFile;
                        prefs.put(prefsKey, installationId);
                    }
                } else {
                    DeviceIdManager.writeToFile(permanentIdFile, installationId);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return installationId;
    }

    private static void deleteLegacySharedFile(@NotNull String fileName) {
        try {
            File permanentIdFile;
            File dir;
            String appdata = System.getenv("APPDATA");
            if (appdata != null && (dir = new File(appdata, "JetBrains")).exists() && (permanentIdFile = new File(dir, fileName)).exists()) {
                permanentIdFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    private static String loadFromFile(@NotNull File file) throws IOException {
        try (FileInputStream is = new FileInputStream(file);){
            byte[] bytes = FileUtilRt.loadBytes((InputStream)is);
            int offset = CharsetToolkit.hasUTF8Bom((byte[])bytes) ? CharsetToolkit.UTF8_BOM.length : 0;
            String string = new String(bytes, offset, bytes.length - offset, StandardCharsets.UTF_8);
            return string;
        }
    }

    private static void writeToFile(@NotNull File file, @NotNull String text) throws IOException {
        try (DataOutputStream stream = new DataOutputStream(new FileOutputStream(file));){
            stream.write(text.getBytes(StandardCharsets.UTF_8));
        }
    }

    @NotNull
    private static Preferences getPreferences(@NotNull ApplicationInfoEx appInfo) {
        String companyName = appInfo.getShortCompanyName();
        String name = StringUtil.isEmptyOrSpaces((String)companyName) ? "jetbrains" : companyName.toLowerCase(Locale.US);
        return Preferences.userRoot().node(name);
    }

    public static String generateId(@NotNull Calendar calendar, char OSChar) {
        int year = calendar.get(1);
        if (year < 2000) {
            year = 2000;
        }
        if (year > 2099) {
            year = 2099;
        }
        calendar.set(1, year);
        return new SimpleDateFormat("ddMMyy", Locale.ENGLISH).format(calendar.getTime()) + OSChar + UUID.randomUUID().toString();
    }

    private static char getOSChar() {
        if (SystemInfo.isWindows) {
            return '1';
        }
        if (SystemInfo.isMac) {
            return '2';
        }
        if (SystemInfo.isLinux) {
            return '3';
        }
        return '0';
    }

    public static class InvalidDeviceIdTokenException
    extends Exception {
        private InvalidDeviceIdTokenException(String message) {
            super(message);
        }
    }

    public static interface DeviceIdToken {
    }
}

