/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.loginActivity.src.app_package.ui.login;

import com.android.tools.idea.wizard.template.Language;
import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import com.android.tools.idea.wizard.template.impl.activities.common.ViewBindingUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"loginActivityJava", "", "layoutName", "packageName", "applicationPackage", "useAndroidX", "", "isViewBindingSupported", "intellij.android.wizardTemplate.impl"})
public final class LoginActivityJavaKt {
    @NotNull
    public static final String loginActivityJava(@NotNull String layoutName2, @NotNull String packageName, @Nullable String applicationPackage, boolean useAndroidX, boolean isViewBindingSupported) {
        String string;
        Intrinsics.checkNotNullParameter((Object)layoutName2, (String)"layoutName");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String contentViewBlock = isViewBindingSupported ? "\n     binding = " + ViewBindingUtilsKt.layoutToViewBindingClass(layoutName2) + ".inflate(getLayoutInflater());\n     setContentView(binding.getRoot());\n  " : "setContentView(R.layout." + layoutName2 + ");";
        String string2 = packageName;
        String string3 = TemplateHelpersKt.getMaterialComponentName("android.arch.lifecycle.Observer", useAndroidX);
        String string4 = TemplateHelpersKt.getMaterialComponentName("android.arch.lifecycle.ViewModelProvider", useAndroidX);
        String string5 = TemplateHelpersKt.getMaterialComponentName("android.support.annotation.Nullable", useAndroidX);
        String string6 = TemplateHelpersKt.getMaterialComponentName("android.support.annotation.StringRes", useAndroidX);
        String string7 = TemplateHelpersKt.getMaterialComponentName("android.support.v7.app.AppCompatActivity", useAndroidX);
        String string8 = packageName;
        String string9 = packageName;
        String string10 = packageName;
        String string11 = ViewBindingUtilsKt.importViewBindingClass(isViewBindingSupported, packageName, applicationPackage, layoutName2, Language.Java);
        boolean trim$iv = true;
        boolean skipLine$iv = true;
        boolean $i$f$renderIf = false;
        if (isViewBindingSupported) {
            String string12 = string11;
            String string13 = string10;
            String string14 = string9;
            String string15 = string8;
            String string16 = string7;
            String string17 = string6;
            String string18 = string5;
            String string19 = string4;
            String string20 = string3;
            String string21 = string2;
            boolean bl = false;
            String string22 = "\n    private " + ViewBindingUtilsKt.layoutToViewBindingClass(layoutName2) + " binding;\n";
            string2 = string21;
            string3 = string20;
            string4 = string19;
            string5 = string18;
            string6 = string17;
            string7 = string16;
            string8 = string15;
            string9 = string14;
            string10 = string13;
            string11 = string12;
            string = ((Object)StringsKt.trim((CharSequence)string22)).toString();
        } else {
            String string23;
            String it$iv = string23 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            boolean bl = false;
            string = string23;
            if (string == null) {
                string = "";
            }
        }
        return "package  " + string2 + ".ui.login;\n\nimport android.app.Activity;\nimport " + string3 + ";\nimport " + string4 + ";\nimport android.os.Bundle;\nimport " + string5 + ";\nimport " + string6 + ";\nimport " + string7 + ";\nimport android.text.Editable;\nimport android.text.TextWatcher;\nimport android.view.KeyEvent;\nimport android.view.View;\nimport android.view.inputmethod.EditorInfo;\nimport android.widget.Button;\nimport android.widget.EditText;\nimport android.widget.ProgressBar;\nimport android.widget.TextView;\nimport android.widget.Toast;\n\nimport " + string8 + ".R;\nimport " + string9 + ".ui.login.LoginViewModel;\nimport " + string10 + ".ui.login.LoginViewModelFactory;\n" + string11 + "\n\npublic class LoginActivity extends AppCompatActivity {\n\n    private LoginViewModel loginViewModel;\n" + string + "\n\n    @Override\n    public void onCreate(Bundle savedInstanceState) {\n        super.onCreate(savedInstanceState);\n        " + contentViewBlock + "\n        loginViewModel = new ViewModelProvider(this, new LoginViewModelFactory())\n                .get(LoginViewModel.class);\n\n        final EditText usernameEditText = " + ViewBindingUtilsKt.findViewById$default(Language.Java, isViewBindingSupported, "username", null, null, null, 56, null) + ";\n        final EditText passwordEditText = " + ViewBindingUtilsKt.findViewById$default(Language.Java, isViewBindingSupported, "password", null, null, null, 56, null) + ";\n        final Button loginButton = " + ViewBindingUtilsKt.findViewById$default(Language.Java, isViewBindingSupported, "login", null, null, null, 56, null) + ";\n        final ProgressBar loadingProgressBar = " + ViewBindingUtilsKt.findViewById$default(Language.Java, isViewBindingSupported, "loading", null, null, null, 56, null) + ";\n\n        loginViewModel.getLoginFormState().observe(this, new Observer<LoginFormState>() {\n            @Override\n            public void onChanged(@Nullable LoginFormState loginFormState) {\n                if (loginFormState == null) {\n                    return;\n                }\n                loginButton.setEnabled(loginFormState.isDataValid());\n                if (loginFormState.getUsernameError() != null) {\n                    usernameEditText.setError(getString(loginFormState.getUsernameError()));\n                }\n                if (loginFormState.getPasswordError() != null) {\n                    passwordEditText.setError(getString(loginFormState.getPasswordError()));\n                }\n            }\n        });\n\n        loginViewModel.getLoginResult().observe(this, new Observer<LoginResult>() {\n            @Override\n            public void onChanged(@Nullable LoginResult loginResult) {\n                if (loginResult == null) {\n                    return;\n                }\n                loadingProgressBar.setVisibility(View.GONE);\n                if (loginResult.getError() != null) {\n                    showLoginFailed(loginResult.getError());\n                }\n                if (loginResult.getSuccess() != null) {\n                    updateUiWithUser(loginResult.getSuccess());\n                }\n                setResult(Activity.RESULT_OK);\n\n                //Complete and destroy login activity once successful\n                finish();\n            }\n        });\n\n        TextWatcher afterTextChangedListener = new TextWatcher() {\n            @Override\n            public void beforeTextChanged(CharSequence s, int start, int count, int after) {\n                // ignore\n            }\n\n            @Override\n            public void onTextChanged(CharSequence s, int start, int before, int count) {\n                // ignore\n            }\n\n            @Override\n            public void afterTextChanged(Editable s) {\n                loginViewModel.loginDataChanged(usernameEditText.getText().toString(),\n                        passwordEditText.getText().toString());\n            }\n        };\n        usernameEditText.addTextChangedListener(afterTextChangedListener);\n        passwordEditText.addTextChangedListener(afterTextChangedListener);\n        passwordEditText.setOnEditorActionListener(new TextView.OnEditorActionListener() {\n\n            @Override\n            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {\n                if (actionId == EditorInfo.IME_ACTION_DONE) {\n                    loginViewModel.login(usernameEditText.getText().toString(),\n                            passwordEditText.getText().toString());\n                }\n                return false;\n            }\n        });\n\n        loginButton.setOnClickListener(new View.OnClickListener() {\n            @Override\n            public void onClick(View v) {\n                loadingProgressBar.setVisibility(View.VISIBLE);\n                loginViewModel.login(usernameEditText.getText().toString(),\n                        passwordEditText.getText().toString());\n            }\n        });\n    }\n\n    private void updateUiWithUser(LoggedInUserView model) {\n        String welcome = getString(R.string.welcome) + model.getDisplayName();\n        // TODO : initiate successful logged in experience\n        Toast.makeText(getApplicationContext(), welcome, Toast.LENGTH_LONG).show();\n    }\n\n    private void showLoginFailed(@StringRes Integer errorString) {\n        Toast.makeText(getApplicationContext(), errorString, Toast.LENGTH_SHORT).show();\n    }\n}\n";
    }
}

