/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.androidTVActivity.src.app_package;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"mainFragmentJava", "", "detailsActivity", "mainFragment", "minApiLevel", "", "packageName", "intellij.android.wizardTemplate.impl"})
public final class MainFragmentJavaKt {
    @NotNull
    public static final String mainFragmentJava(@NotNull String detailsActivity2, @NotNull String mainFragment2, int minApiLevel, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)detailsActivity2, (String)"detailsActivity");
        Intrinsics.checkNotNullParameter((Object)mainFragment2, (String)"mainFragment");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String contextArgBlock = minApiLevel >= 23 ? "getContext()" : "getActivity()";
        return "\npackage " + packageName + ";\n\nimport android.content.Intent;\nimport android.graphics.Color;\nimport android.graphics.drawable.Drawable;\nimport android.os.Bundle;\nimport android.os.Handler;\nimport android.os.Looper;\nimport androidx.annotation.NonNull;\nimport androidx.annotation.Nullable;\nimport androidx.leanback.app.BackgroundManager;\nimport androidx.leanback.app.BrowseSupportFragment;\nimport androidx.leanback.widget.ArrayObjectAdapter;\nimport androidx.leanback.widget.HeaderItem;\nimport androidx.leanback.widget.ImageCardView;\nimport androidx.leanback.widget.ListRow;\nimport androidx.leanback.widget.ListRowPresenter;\nimport androidx.leanback.widget.OnItemViewClickedListener;\nimport androidx.leanback.widget.OnItemViewSelectedListener;\nimport androidx.leanback.widget.Presenter;\nimport androidx.leanback.widget.Row;\nimport androidx.leanback.widget.RowPresenter;\nimport androidx.core.app.ActivityOptionsCompat;\nimport androidx.core.content.ContextCompat;\nimport android.util.DisplayMetrics;\nimport android.util.Log;\nimport android.view.Gravity;\nimport android.view.View;\nimport android.view.ViewGroup;\nimport android.widget.TextView;\nimport android.widget.Toast;\n\nimport com.bumptech.glide.Glide;\nimport com.bumptech.glide.request.target.SimpleTarget;\nimport com.bumptech.glide.request.transition.Transition;\n\nimport java.util.Collections;\nimport java.util.List;\nimport java.util.Timer;\nimport java.util.TimerTask;\n\npublic class " + mainFragment2 + " extends BrowseSupportFragment {\n    private static final String TAG = \"" + StringsKt.take((String)mainFragment2, (int)23) + "\";\n\n    private static final int BACKGROUND_UPDATE_DELAY = 300;\n    private static final int GRID_ITEM_WIDTH = 200;\n    private static final int GRID_ITEM_HEIGHT = 200;\n    private static final int NUM_ROWS = 6;\n    private static final int NUM_COLS = 15;\n\n    private final Handler mHandler = new Handler(Looper.myLooper());\n    private Drawable mDefaultBackground;\n    private DisplayMetrics mMetrics;\n    private Timer mBackgroundTimer;\n    private String mBackgroundUri;\n    private BackgroundManager mBackgroundManager;\n\n    @Override\n    public void onActivityCreated(Bundle savedInstanceState) {\n        Log.i(TAG, \"onCreate\");\n        super.onActivityCreated(savedInstanceState);\n\n        prepareBackgroundManager();\n\n        setupUIElements();\n\n        loadRows();\n\n        setupEventListeners();\n    }\n\n    @Override\n    public void onDestroy() {\n        super.onDestroy();\n        if (null != mBackgroundTimer) {\n            Log.d(TAG, \"onDestroy: \" + mBackgroundTimer.toString());\n            mBackgroundTimer.cancel();\n        }\n    }\n\n    private void loadRows() {\n        List<Movie> list = MovieList.setupMovies();\n\n        ArrayObjectAdapter rowsAdapter = new ArrayObjectAdapter(new ListRowPresenter());\n        CardPresenter cardPresenter = new CardPresenter();\n\n        int i;\n        for (i = 0; i < NUM_ROWS; i++) {\n            if (i != 0) {\n                Collections.shuffle(list);\n            }\n            ArrayObjectAdapter listRowAdapter = new ArrayObjectAdapter(cardPresenter);\n            for (int j = 0; j < NUM_COLS; j++) {\n                listRowAdapter.add(list.get(j % 5));\n            }\n            HeaderItem header = new HeaderItem(i, MovieList.MOVIE_CATEGORY[i]);\n            rowsAdapter.add(new ListRow(header, listRowAdapter));\n        }\n\n        HeaderItem gridHeader = new HeaderItem(i, \"PREFERENCES\");\n\n        GridItemPresenter mGridPresenter = new GridItemPresenter();\n        ArrayObjectAdapter gridRowAdapter = new ArrayObjectAdapter(mGridPresenter);\n        gridRowAdapter.add(getResources().getString(R.string.grid_view));\n        gridRowAdapter.add(getString(R.string.error_fragment));\n        gridRowAdapter.add(getResources().getString(R.string.personal_settings));\n        rowsAdapter.add(new ListRow(gridHeader, gridRowAdapter));\n\n        setAdapter(rowsAdapter);\n    }\n\n    private void prepareBackgroundManager() {\n\n        mBackgroundManager = BackgroundManager.getInstance(getActivity());\n        mBackgroundManager.attach(getActivity().getWindow());\n\n        mDefaultBackground = ContextCompat.getDrawable(" + contextArgBlock + ", R.drawable.default_background);\n        mMetrics = new DisplayMetrics();\n        getActivity().getWindowManager().getDefaultDisplay().getMetrics(mMetrics);\n    }\n\n    private void setupUIElements() {\n        // setBadgeDrawable(getActivity().getResources().getDrawable(\n        // R.drawable.videos_by_google_banner));\n        setTitle(getString(R.string.browse_title)); // Badge, when set, takes precedent\n        // over title\n        setHeadersState(HEADERS_ENABLED);\n        setHeadersTransitionOnBackEnabled(true);\n\n        // set fastLane (or headers) background color\n        setBrandColor(ContextCompat.getColor(" + contextArgBlock + ", R.color.fastlane_background));\n        // set search icon color\n        setSearchAffordanceColor(ContextCompat.getColor(" + contextArgBlock + ", R.color.search_opaque));\n    }\n\n    private void setupEventListeners() {\n        setOnSearchClickedListener(new View.OnClickListener() {\n\n            @Override\n            public void onClick(View view) {\n                Toast.makeText(getActivity(), \"Implement your own in-app search\", Toast.LENGTH_LONG)\n                        .show();\n            }\n        });\n\n        setOnItemViewClickedListener(new ItemViewClickedListener());\n        setOnItemViewSelectedListener(new ItemViewSelectedListener());\n    }\n\n    private final class ItemViewClickedListener implements OnItemViewClickedListener {\n        @Override\n        public void onItemClicked(Presenter.ViewHolder itemViewHolder, Object item,\n                                  RowPresenter.ViewHolder rowViewHolder, Row row) {\n\n            if (item instanceof Movie) {\n                Movie movie = (Movie) item;\n                Log.d(TAG, \"Item: \" + item.toString());\n                Intent intent = new Intent(getActivity(), " + detailsActivity2 + ".class);\n                intent.putExtra(" + detailsActivity2 + ".MOVIE, movie);\n\n                Bundle bundle = ActivityOptionsCompat.makeSceneTransitionAnimation(\n                                                getActivity(),\n                                                ((ImageCardView) itemViewHolder.view).getMainImageView(),\n                                                " + detailsActivity2 + ".SHARED_ELEMENT_NAME)\n                                        .toBundle();\n                getActivity().startActivity(intent, bundle);\n            } else if (item instanceof String) {\n                if (((String) item).contains(getString(R.string.error_fragment))) {\n                    Intent intent = new Intent(getActivity(), BrowseErrorActivity.class);\n                    startActivity(intent);\n                } else {\n                    Toast.makeText(getActivity(), ((String) item), Toast.LENGTH_SHORT).show();\n                }\n            }\n        }\n    }\n\n    private final class ItemViewSelectedListener implements OnItemViewSelectedListener {\n        @Override\n        public void onItemSelected(\n                Presenter.ViewHolder itemViewHolder,\n                Object item,\n                RowPresenter.ViewHolder rowViewHolder,\n                Row row) {\n            if (item instanceof Movie) {\n                mBackgroundUri = ((Movie) item).getBackgroundImageUrl();\n                startBackgroundTimer();\n            }\n        }\n    }\n\n    private void updateBackground(String uri) {\n        int width = mMetrics.widthPixels;\n        int height = mMetrics.heightPixels;\n        Glide.with(getActivity())\n                .load(uri)\n                .centerCrop()\n                .error(mDefaultBackground)\n                .into(new SimpleTarget<Drawable>(width, height) {\n                    @Override\n                    public void onResourceReady(@NonNull Drawable drawable,\n                                                @Nullable Transition<? super Drawable> transition) {\n                        mBackgroundManager.setDrawable(drawable);\n                    }\n                });\n        mBackgroundTimer.cancel();\n    }\n\n    private void startBackgroundTimer() {\n        if (null != mBackgroundTimer) {\n            mBackgroundTimer.cancel();\n        }\n        mBackgroundTimer = new Timer();\n        mBackgroundTimer.schedule(new UpdateBackgroundTask(), BACKGROUND_UPDATE_DELAY);\n    }\n\n    private class UpdateBackgroundTask extends TimerTask {\n\n        @Override\n        public void run() {\n            mHandler.post(new Runnable() {\n                @Override\n                public void run() {\n                    updateBackground(mBackgroundUri);\n                }\n            });\n        }\n    }\n\n    private class GridItemPresenter extends Presenter {\n        @Override\n        public ViewHolder onCreateViewHolder(ViewGroup parent) {\n            TextView view = new TextView(parent.getContext());\n            view.setLayoutParams(new ViewGroup.LayoutParams(GRID_ITEM_WIDTH, GRID_ITEM_HEIGHT));\n            view.setFocusable(true);\n            view.setFocusableInTouchMode(true);\n            view.setBackgroundColor(\n                    ContextCompat.getColor(" + contextArgBlock + ", R.color.default_background));\n            view.setTextColor(Color.WHITE);\n            view.setGravity(Gravity.CENTER);\n            return new ViewHolder(view);\n        }\n\n        @Override\n        public void onBindViewHolder(ViewHolder viewHolder, Object item) {\n            ((TextView) viewHolder.view).setText((String) item);\n        }\n\n        @Override\n        public void onUnbindViewHolder(ViewHolder viewHolder) { }\n    }\n\n}\n";
    }
}

