/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.androidTVActivity.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0005"}, d2={"browseErrorActivityKt", "", "layoutName", "packageName", "mainFragment", "intellij.android.wizardTemplate.impl"})
public final class BrowseErrorActivityKtKt {
    @NotNull
    public static final String browseErrorActivityKt(@NotNull String layoutName2, @NotNull String packageName, @NotNull String mainFragment2) {
        Intrinsics.checkNotNullParameter((Object)layoutName2, (String)"layoutName");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)mainFragment2, (String)"mainFragment");
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + "\n\nimport android.os.Bundle\nimport android.os.Handler\nimport android.os.Looper\nimport android.view.Gravity\nimport android.view.LayoutInflater\nimport android.view.View\nimport android.view.ViewGroup\nimport android.widget.FrameLayout\nimport android.widget.ProgressBar\nimport androidx.fragment.app.Fragment\nimport androidx.fragment.app.FragmentActivity\n\n/**\n * BrowseErrorActivity shows how to use ErrorFragment.\n */\nclass BrowseErrorActivity : FragmentActivity() {\n\n    private lateinit var mErrorFragment: ErrorFragment\n    private lateinit var mSpinnerFragment: SpinnerFragment\n\n    override fun onCreate(savedInstanceState: Bundle?) {\n        super.onCreate(savedInstanceState)\n        setContentView(R.layout." + layoutName2 + ")\n        if (savedInstanceState == null) {\n            getSupportFragmentManager().beginTransaction()\n                .replace(R.id.main_browse_fragment, " + mainFragment2 + "())\n                .commitNow()\n        }\n        testError()\n    }\n\n    private fun testError() {\n        mErrorFragment = ErrorFragment()\n        supportFragmentManager\n                .beginTransaction()\n                .add(R.id.main_browse_fragment, mErrorFragment)\n                .commit()\n\n        mSpinnerFragment = SpinnerFragment()\n        supportFragmentManager\n                .beginTransaction()\n                .add(R.id.main_browse_fragment, mSpinnerFragment)\n                .commit()\n\n        val handler = Handler(Looper.myLooper()!!)\n        handler.postDelayed({\n            supportFragmentManager\n                    .beginTransaction()\n                    .remove(mSpinnerFragment)\n                    .commit()\n            mErrorFragment.setErrorContent()\n        }, TIMER_DELAY)\n    }\n\n    class SpinnerFragment : Fragment() {\n        override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?,\n                                  savedInstanceState: Bundle?): View? {\n            val progressBar = ProgressBar(container?.context)\n            if (container is FrameLayout) {\n                val layoutParams = FrameLayout.LayoutParams(SPINNER_WIDTH, SPINNER_HEIGHT, Gravity.CENTER)\n                progressBar.layoutParams = layoutParams\n            }\n            return progressBar\n        }\n    }\n\n    companion object {\n        private val TIMER_DELAY = 3000L\n        private val SPINNER_WIDTH = 100\n        private val SPINNER_HEIGHT = 100\n    }\n}";
    }
}

