/*
 * Decompiled with CFR 0.152.
 */
package com.android.prefs;

import com.android.io.CancellableFileIo;
import com.android.prefs.AbstractAndroidLocations;
import com.android.prefs.AbstractAndroidLocationsKt;
import com.android.prefs.AndroidLocationsException;
import com.android.prefs.AndroidLocationsProvider;
import com.android.prefs.AndroidPathLocator;
import com.android.prefs.Global;
import com.android.prefs.PathLocator;
import com.android.utils.EnvironmentProvider;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB!\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0017\u001a\u00020\nH\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0007R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/android/prefs/AbstractAndroidLocations;", "Lcom/android/prefs/AndroidLocationsProvider;", "environmentProvider", "Lcom/android/utils/EnvironmentProvider;", "logger", "Lcom/android/utils/ILogger;", "silent", "", "(Lcom/android/utils/EnvironmentProvider;Lcom/android/utils/ILogger;Z)V", "avdLocation", "Ljava/nio/file/Path;", "getAvdLocation", "()Ljava/nio/file/Path;", "gradleAvdLocation", "getGradleAvdLocation", "internalAvdLocation", "internalGradleAvdLocation", "internalPrefsLocation", "internalUserHomeLocation", "prefsLocation", "getPrefsLocation", "userHomeLocation", "getUserHomeLocation", "computeAndroidFolder", "resetPathsForTest", "", "Companion", "android.sdktools.common"})
public abstract class AbstractAndroidLocations
implements AndroidLocationsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnvironmentProvider environmentProvider;
    @NotNull
    private final ILogger logger;
    private final boolean silent;
    @Nullable
    private Path internalPrefsLocation;
    @Nullable
    private Path internalAvdLocation;
    @Nullable
    private Path internalGradleAvdLocation;
    @Nullable
    private Path internalUserHomeLocation;
    @JvmField
    @NotNull
    public static final String FOLDER_DOT_ANDROID = ".android";
    @JvmField
    @NotNull
    public static final String FOLDER_AVD = "avd";
    @JvmField
    @NotNull
    public static final String FOLDER_GRADLE_AVD = "gradle-managed";
    @JvmField
    @NotNull
    public static final String ANDROID_PREFS_ROOT = "ANDROID_PREFS_ROOT";
    @NotNull
    private static final String ANDROID_USER_HOME = "ANDROID_USER_HOME";

    protected AbstractAndroidLocations(@NotNull EnvironmentProvider environmentProvider, @NotNull ILogger logger, boolean silent) {
        Intrinsics.checkNotNullParameter((Object)environmentProvider, (String)"environmentProvider");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.environmentProvider = environmentProvider;
        this.logger = logger;
        this.silent = silent;
    }

    public /* synthetic */ AbstractAndroidLocations(EnvironmentProvider environmentProvider, ILogger iLogger, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(environmentProvider, iLogger, bl);
    }

    @Override
    @NotNull
    public Path getPrefsLocation() throws AndroidLocationsException {
        Path path = this.internalPrefsLocation;
        if (path == null) {
            Path path2;
            Path it = path2 = this.computeAndroidFolder();
            boolean bl = false;
            this.internalPrefsLocation = it;
            if (CancellableFileIo.notExists(it, new LinkOption[0])) {
                try {
                    Files.createDirectories(it, new FileAttribute[0]);
                }
                catch (SecurityException e) {
                    throw new AndroidLocationsException("Unable to create folder '" + it + "'.\n|This is the path of preference folder expected by the Android tools.", e);
                }
            } else if (CancellableFileIo.isRegularFile(it, new LinkOption[0])) {
                throw new AndroidLocationsException(it + " is not a directory!\nThis is the path of preference folder expected by the Android tools.", null, 2, null);
            }
            path = path2;
        }
        return path;
    }

    @Override
    @NotNull
    public Path getAvdLocation() throws AndroidLocationsException {
        Path path = this.internalAvdLocation;
        if (path == null) {
            Path path2;
            Global[] globalArray = new Global[]{Global.ANDROID_AVD_HOME};
            Path path3 = new PathLocator(this.environmentProvider).singlePathOf(globalArray);
            if (path3 == null) {
                path3 = this.getPrefsLocation().resolve(FOLDER_AVD);
            }
            Path it = path2 = path3;
            boolean bl = false;
            this.internalAvdLocation = it;
            Path path4 = path2;
            path = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"PathLocator(environmentP\u2026nternalAvdLocation = it }");
        }
        return path;
    }

    @Override
    @NotNull
    public Path getGradleAvdLocation() throws AndroidLocationsException {
        Path path = this.internalGradleAvdLocation;
        if (path == null) {
            Path path2;
            Path it = path2 = this.getAvdLocation().resolve(FOLDER_GRADLE_AVD);
            boolean bl = false;
            this.internalGradleAvdLocation = it;
            Path path3 = path2;
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"avdLocation\n            \u2026lGradleAvdLocation = it }");
        }
        return path;
    }

    @Override
    @NotNull
    public Path getUserHomeLocation() {
        Path path;
        Path path2 = this.internalUserHomeLocation;
        if (path2 != null) {
            Path it = path2;
            boolean bl = false;
            return it;
        }
        PathLocator pathLocator = new PathLocator(this.environmentProvider);
        Global[] globalArray = new Global[]{Global.TEST_TMPDIR, Global.XGD_CONFIG_HOME, Global.USER_HOME, Global.HOME};
        Path path3 = pathLocator.firstPathOf(globalArray);
        if (path3 == null) {
            throw AndroidLocationsException.Companion.createForHomeLocation$android_sdktools_common(pathLocator.getVisitedVariables());
        }
        Path it = path = path3;
        boolean bl = false;
        this.internalUserHomeLocation = it;
        return path;
    }

    private final Path computeAndroidFolder() {
        Path path;
        Global[] globalArray;
        AndroidPathLocator locator = new AndroidPathLocator(this.environmentProvider, !this.silent ? this.logger : null);
        Path folder = locator.singlePathOf(globalArray = new Global[]{Global.ANDROID_USER_HOME, Global.ANDROID_PREFS_ROOT, Global.ANDROID_SDK_HOME});
        if (folder != null) {
            if (locator.getVisitedVariables().size() > 1 && !this.silent) {
                String message2 = AbstractAndroidLocationsKt.combineLocationValuesIntoMessage$default(locator.getVisitedVariables(), "More than one location points to the Android preference location\nbut only one is valid", null, computeAndroidFolder.message.1.INSTANCE, 4, null);
                this.logger.warning(message2, new Object[0]);
            }
            return folder;
        }
        PathLocator pathLocator = new PathLocator(this.environmentProvider);
        Global[] globalArray2 = new Global[]{Global.TEST_TMPDIR, Global.XGD_CONFIG_HOME, Global.USER_HOME, Global.HOME};
        Path path2 = pathLocator.firstPathOf(globalArray2);
        Path path3 = path = path2 != null ? path2.resolve(FOLDER_DOT_ANDROID) : null;
        if (path == null) {
            throw new AndroidLocationsException(AbstractAndroidLocationsKt.combineLocationValuesIntoMessage$default(CollectionsKt.plus((Collection)locator.getVisitedVariables(), (Iterable)pathLocator.getVisitedVariables()), "Unable to find the location for the android preferences.\nThe following locations have been checked, but they do not exist:", null, null, 12, null), null, 2, null);
        }
        return path;
    }

    @VisibleForTesting
    public final void resetPathsForTest() {
        this.internalPrefsLocation = null;
        this.internalAvdLocation = null;
        this.internalGradleAvdLocation = null;
        this.internalUserHomeLocation = null;
    }

    @NotNull
    public static final String getANDROID_USER_HOME() {
        return Companion.getANDROID_USER_HOME();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u001c\u0010\u0006\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/prefs/AbstractAndroidLocations$Companion;", "", "()V", "ANDROID_PREFS_ROOT", "", "getANDROID_PREFS_ROOT$annotations", "ANDROID_USER_HOME", "getANDROID_USER_HOME$annotations", "getANDROID_USER_HOME", "()Ljava/lang/String;", "FOLDER_AVD", "FOLDER_DOT_ANDROID", "FOLDER_GRADLE_AVD", "android.sdktools.common"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Use ANDROID_USER_HOME")
        public static /* synthetic */ void getANDROID_PREFS_ROOT$annotations() {
        }

        @NotNull
        public final String getANDROID_USER_HOME() {
            return ANDROID_USER_HOME;
        }

        @JvmStatic
        public static /* synthetic */ void getANDROID_USER_HOME$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

