/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.impl;

import com.intellij.ide.CopyPasteDelegator;
import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.intellij.images.ImagesBundle;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.intellij.images.search.ImageTagManager;
import org.intellij.images.search.TagFilter;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.actionSystem.ThumbnailViewActionUtil;
import org.intellij.images.thumbnail.actions.ThemeFilter;
import org.intellij.images.thumbnail.impl.ThumbnailViewImpl;
import org.intellij.images.ui.ImageComponent;
import org.intellij.images.ui.ImageComponentDecorator;
import org.intellij.images.ui.ThumbnailComponent;
import org.intellij.images.ui.ThumbnailComponentUI;
import org.intellij.images.vfs.IfsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ThumbnailViewUI
extends JPanel
implements DataProvider,
Disposable {
    private final ThumbnailView thumbnailView;
    private final CopyPasteSupport copyPasteSupport;
    private final DeleteProvider deleteProvider;
    private ThumbnailListCellRenderer cellRenderer;
    private JList list;
    private JPanel tagsPanel;
    private static final Comparator<VirtualFile> VIRTUAL_FILE_COMPARATOR = (o1, o2) -> {
        if (o1.isDirectory() && !o2.isDirectory()) {
            return -1;
        }
        if (o2.isDirectory() && !o1.isDirectory()) {
            return 1;
        }
        return o1.getPath().compareToIgnoreCase(o2.getPath());
    };
    private DefaultListModel<String> listModel;
    private Splitter previewSplitter;

    ThumbnailViewUI(ThumbnailViewImpl thumbnailView) {
        super(new BorderLayout());
        this.thumbnailView = thumbnailView;
        this.copyPasteSupport = new CopyPasteDelegator(thumbnailView.getProject(), (JComponent)this);
        this.deleteProvider = new DeleteHandler.DefaultDeleteProvider();
    }

    private void createUI() {
        if (this.cellRenderer == null || this.list == null) {
            this.cellRenderer = new ThumbnailListCellRenderer();
            ImageComponent imageComponent = this.cellRenderer.getImageComponent();
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VFSListener(), (Disposable)this);
            Options options = OptionsManager.getInstance().getOptions();
            EditorOptions editorOptions = options.getEditorOptions();
            TransparencyChessboardOptions chessboardOptions = editorOptions.getTransparencyChessboardOptions();
            imageComponent.setTransparencyChessboardVisible(chessboardOptions.isShowDefault());
            imageComponent.setTransparencyChessboardCellSize(chessboardOptions.getCellSize());
            imageComponent.setTransparencyChessboardWhiteColor(chessboardOptions.getWhiteColor());
            imageComponent.setTransparencyChessboardBlankColor(chessboardOptions.getBlackColor());
            imageComponent.setFileNameVisible(editorOptions.isFileNameVisible());
            imageComponent.setFileSizeVisible(editorOptions.isFileSizeVisible());
            options.addPropertyChangeListener(new OptionsChangeListener(), this);
            this.list = new JBList();
            this.list.setModel(new DefaultListModel());
            this.list.setLayoutOrientation(2);
            this.list.setVisibleRowCount(-1);
            this.list.setCellRenderer(this.cellRenderer);
            this.list.setSelectionMode(2);
            this.list.addListSelectionListener(e -> this.updateTagsPreviewModel());
            ThumbnailsMouseAdapter mouseListener = new ThumbnailsMouseAdapter();
            this.list.addMouseListener(mouseListener);
            this.list.addMouseMotionListener(mouseListener);
            ThumbnailComponentUI componentUI = (ThumbnailComponentUI)ThumbnailComponentUI.createUI(this.cellRenderer);
            Dimension preferredSize = componentUI.getPreferredSize(this.cellRenderer);
            this.list.setFixedCellWidth(preferredSize.width);
            this.list.setFixedCellHeight(preferredSize.height);
            JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.list, (int)20, (int)31);
            scrollPane.setBorder(IdeBorderFactory.createBorder((int)2));
            ActionManager actionManager = ActionManager.getInstance();
            ActionGroup actionGroup = (ActionGroup)actionManager.getAction("Images.ThumbnailsToolbar");
            ActionToolbar actionToolbar = actionManager.createActionToolbar("Images.Thumbnails", actionGroup, true);
            actionToolbar.setTargetComponent((JComponent)this);
            JComponent toolbar = actionToolbar.getComponent();
            FocusRequester focusRequester = new FocusRequester();
            toolbar.addMouseListener(focusRequester);
            scrollPane.addMouseListener(focusRequester);
            this.add((Component)toolbar, "North");
            this.previewSplitter = new Splitter();
            this.previewSplitter.setFirstComponent((JComponent)scrollPane);
            this.previewSplitter.setProportion(1.0f);
            this.previewSplitter.setSecondComponent(null);
            this.add((Component)this.previewSplitter, "Center");
        }
        this.updateTagsPreview();
    }

    private JPanel createTagPreviewPanel() {
        this.listModel = new DefaultListModel();
        this.updateTagsPreviewModel();
        final JBList tagsList = new JBList(this.listModel);
        tagsList.setEmptyText(ImagesBundle.message("list.empty.text.no.tags.defined", new Object[0]));
        final ImageTagManager imageTagManager = ImageTagManager.getInstance(this.thumbnailView.getProject());
        return ToolbarDecorator.createDecorator((JList)tagsList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                JBPopupFactory.getInstance().createActionGroupPopup(IdeBundle.message((String)"popup.title.add.tags", (Object[])new Object[0]), (ActionGroup)new AddTagGroup(), button.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false).show(button.getPreferredPopupPoint());
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                String selectedValue = (String)tagsList.getSelectedValue();
                if (selectedValue != null) {
                    Arrays.stream(ThumbnailViewUI.this.getSelection()).forEach(virtualFile -> imageTagManager.removeTag(selectedValue, (VirtualFile)virtualFile));
                }
                ThumbnailViewUI.this.updateTagsPreviewModel();
            }
        }).disableUpDownActions().setToolbarPosition(ActionToolbarPosition.RIGHT).createPanel();
    }

    private void updateTagsPreview() {
        Project project = this.thumbnailView.getProject();
        boolean enabled = PropertiesComponent.getInstance((Project)project).getBoolean("tags.panel.visible", false);
        float splitterProportion = this.previewSplitter.getProportion();
        if (enabled) {
            if (splitterProportion == 1.0f) {
                this.previewSplitter.setProportion(Float.parseFloat(PropertiesComponent.getInstance((Project)project).getValue("tags.panel.proportion", "0.5f")));
            }
            if (this.tagsPanel == null) {
                this.tagsPanel = this.createTagPreviewPanel();
            }
            this.previewSplitter.setSecondComponent((JComponent)this.tagsPanel);
        } else {
            if (splitterProportion != 1.0f) {
                PropertiesComponent.getInstance((Project)this.thumbnailView.getProject()).setValue("tags.panel.proportion", String.valueOf(splitterProportion));
            }
            this.previewSplitter.setProportion(1.0f);
            this.previewSplitter.setSecondComponent(null);
        }
    }

    private void updateTagsPreviewModel() {
        if (this.listModel == null) {
            return;
        }
        this.listModel.clear();
        VirtualFile[] selection = this.getSelection();
        ImageTagManager tagManager = ImageTagManager.getInstance(this.thumbnailView.getProject());
        ArrayList<String> commonTags = null;
        for (VirtualFile virtualFile : selection) {
            List<String> tags = tagManager.getTags(virtualFile);
            if (commonTags == null) {
                commonTags = new ArrayList<String>(tags);
                continue;
            }
            commonTags.retainAll(tags);
        }
        if (commonTags != null) {
            commonTags.forEach(this.listModel::addElement);
        }
    }

    public void refresh() {
        this.createUI();
        if (this.list != null) {
            DefaultListModel model = (DefaultListModel)this.list.getModel();
            model.clear();
            VirtualFile root = this.thumbnailView.getRoot();
            if (root != null && root.isValid() && root.isDirectory()) {
                Set<VirtualFile> files = this.findFiles(root.getChildren());
                VirtualFile[] virtualFiles = VfsUtilCore.toVirtualFileArray(files);
                Arrays.sort(virtualFiles, VIRTUAL_FILE_COMPARATOR);
                model.ensureCapacity(model.size() + virtualFiles.length + 1);
                ThemeFilter filter = this.thumbnailView.getFilter();
                TagFilter[] tagFilters = this.thumbnailView.getTagFilters();
                for (VirtualFile virtualFile : virtualFiles) {
                    if (filter != null && !filter.accepts(virtualFile) || tagFilters != null && !Arrays.stream(tagFilters).anyMatch(tagFilter -> tagFilter.accepts(virtualFile))) continue;
                    model.addElement(virtualFile);
                }
                if (model.size() > 0) {
                    this.list.setSelectedIndex(0);
                }
            } else {
                this.thumbnailView.setVisible(false);
            }
        }
    }

    public boolean isTransparencyChessboardVisible() {
        this.createUI();
        return this.cellRenderer.getImageComponent().isTransparencyChessboardVisible();
    }

    public void setTransparencyChessboardVisible(boolean visible) {
        this.createUI();
        this.cellRenderer.getImageComponent().setTransparencyChessboardVisible(visible);
        this.list.repaint();
    }

    public void setFileNameVisible(boolean visible) {
        this.createUI();
        this.cellRenderer.getImageComponent().setFileNameVisible(visible);
        this.list.repaint();
    }

    public boolean isFileNameVisible() {
        this.createUI();
        return this.cellRenderer.getImageComponent().isFileNameVisible();
    }

    public void setFileSizeVisible(boolean visible) {
        this.createUI();
        this.cellRenderer.getImageComponent().setFileSizeVisible(visible);
        this.list.repaint();
    }

    public boolean isFileSizeVisible() {
        this.createUI();
        return this.cellRenderer.getImageComponent().isFileSizeVisible();
    }

    public void setSelected(VirtualFile file, boolean selected) {
        this.createUI();
        this.list.setSelectedValue(file, false);
    }

    public void scrollToSelection() {
        int minSelectionIndex = this.list.getMinSelectionIndex();
        int maxSelectionIndex = this.list.getMaxSelectionIndex();
        if (minSelectionIndex != -1 && maxSelectionIndex != -1) {
            this.list.scrollRectToVisible(this.list.getCellBounds(minSelectionIndex, maxSelectionIndex));
        }
    }

    public boolean isSelected(VirtualFile file) {
        int index = ((DefaultListModel)this.list.getModel()).indexOf(file);
        return index != -1 && this.list.isSelectedIndex(index);
    }

    public VirtualFile @NotNull [] getSelection() {
        Object[] selectedValues;
        if (this.list != null && (selectedValues = this.list.getSelectedValues()) != null) {
            VirtualFile[] files = new VirtualFile[selectedValues.length];
            for (int i = 0; i < selectedValues.length; ++i) {
                files[i] = (VirtualFile)selectedValues[i];
            }
            return files;
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    private Set<VirtualFile> findFiles(VirtualFile[] roots) {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        for (VirtualFile root : roots) {
            files.addAll(this.findFiles(root));
        }
        return files;
    }

    private Set<VirtualFile> findFiles(VirtualFile file) {
        ProjectRootManager rootManager;
        boolean projectIgnored;
        HashSet<VirtualFile> files = new HashSet<VirtualFile>(0);
        Project project = this.thumbnailView.getProject();
        if (!(project.isDisposed() || (projectIgnored = (rootManager = ProjectRootManager.getInstance((Project)project)).getFileIndex().isExcluded(file)) || FileTypeManager.getInstance().isFileIgnored(file))) {
            ImageFileTypeManager typeManager = ImageFileTypeManager.getInstance();
            if (file.isDirectory()) {
                if (this.thumbnailView.isRecursive()) {
                    files.addAll(this.findFiles(file.getChildren()));
                } else if (this.isImagesInDirectory(file)) {
                    files.add(file);
                }
            } else if (typeManager.isImage(file)) {
                files.add(file);
            }
        }
        return files;
    }

    private boolean isImagesInDirectory(VirtualFile dir) {
        VirtualFile[] files;
        ImageFileTypeManager typeManager = ImageFileTypeManager.getInstance();
        for (VirtualFile file : files = dir.getChildren()) {
            if (file.isDirectory()) {
                return true;
            }
            if (!typeManager.isImage(file)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.thumbnailView.getProject();
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            VirtualFile[] selectedFiles = this.getSelectedFiles();
            return selectedFiles.length > 0 ? selectedFiles[0] : null;
        }
        if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return this.getSelectedFiles();
        }
        if (CommonDataKeys.PSI_FILE.is(dataId)) {
            return this.getData(CommonDataKeys.PSI_ELEMENT.getName());
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            VirtualFile[] selectedFiles = this.getSelectedFiles();
            return selectedFiles.length > 0 ? PsiManager.getInstance((Project)this.thumbnailView.getProject()).findFile(selectedFiles[0]) : null;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            return this.getSelectedElements();
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            VirtualFile[] selectedFiles = this.getSelectedFiles();
            return new ThumbnailNavigatable(selectedFiles.length > 0 ? selectedFiles[0] : null);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.copyPasteSupport.getCopyProvider();
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.copyPasteSupport.getCutProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.copyPasteSupport.getPasteProvider();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.deleteProvider;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            VirtualFile[] selectedFiles = this.getSelectedFiles();
            HashSet<ThumbnailNavigatable> navigatables = new HashSet<ThumbnailNavigatable>(selectedFiles.length);
            for (VirtualFile selectedFile : selectedFiles) {
                if (selectedFile.isDirectory()) continue;
                navigatables.add(new ThumbnailNavigatable(selectedFile));
            }
            return navigatables.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
        }
        if (ThumbnailView.DATA_KEY.is(dataId)) {
            return this.thumbnailView;
        }
        if (ImageComponentDecorator.DATA_KEY.is(dataId)) {
            return this.thumbnailView;
        }
        return null;
    }

    private PsiElement @NotNull [] getSelectedElements() {
        VirtualFile[] selectedFiles = this.getSelectedFiles();
        HashSet<PsiFile> psiElements = new HashSet<PsiFile>(selectedFiles.length);
        PsiManager psiManager = PsiManager.getInstance((Project)this.thumbnailView.getProject());
        for (VirtualFile file : selectedFiles) {
            PsiFile element;
            PsiFile psiFile = psiManager.findFile(file);
            Object object = element = psiFile != null ? psiFile : psiManager.findDirectory(file);
            if (element == null) continue;
            psiElements.add(element);
        }
        return PsiUtilCore.toPsiElementArray(psiElements);
    }

    private VirtualFile @NotNull [] getSelectedFiles() {
        Object[] selectedValues;
        if (this.list != null && (selectedValues = this.list.getSelectedValues()) != null) {
            VirtualFile[] files = new VirtualFile[selectedValues.length];
            for (int i = 0; i < selectedValues.length; ++i) {
                files[i] = (VirtualFile)selectedValues[i];
            }
            return files;
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    public void dispose() {
        this.removeAll();
        this.list = null;
        this.cellRenderer = null;
        this.tagsPanel = null;
    }

    public class AddTagGroup
    extends ActionGroup {
        public AddTagGroup() {
            this.setPopup(true);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (e == null) {
                return EMPTY_ARRAY;
            }
            Project project = e.getProject();
            final ImageTagManager tagManager = ImageTagManager.getInstance(project);
            List<String> tags = tagManager.getAllTags();
            int tagsNumber = tags.size();
            AnAction[] actions = new AnAction[tagsNumber + 1];
            for (int i = 0; i < tagsNumber; ++i) {
                final String tag = tags.get(i);
                actions[i] = new AnAction(tag){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        for (VirtualFile file : ThumbnailViewUI.this.thumbnailView.getSelection()) {
                            tagManager.addTag(tag, file);
                        }
                        ThumbnailViewUI.this.updateTagsPreviewModel();
                    }

                    public void update(@NotNull AnActionEvent e) {
                        e.getPresentation().setEnabledAndVisible(!ContainerUtil.exists((Object[])ThumbnailViewUI.this.thumbnailView.getSelection(), file -> tagManager.hasTag(tag, (VirtualFile)file)));
                    }
                };
            }
            actions[tagsNumber] = new AnAction(IdeBundle.messagePointer((String)"action.Anonymous.text.new.tag", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    String tag;
                    VirtualFile[] selection;
                    ThumbnailView view = ThumbnailViewActionUtil.getVisibleThumbnailView(e);
                    if (view != null && (selection = view.getSelection()).length > 0 && (tag = Messages.showInputDialog((String)"", (String)IdeBundle.message((String)"dialog.title.new.tag.name", (Object[])new Object[0]), null)) != null) {
                        for (VirtualFile file : selection) {
                            tagManager.addTag(tag, file);
                        }
                    }
                }
            };
            return actions;
        }
    }

    private class FocusRequester
    extends MouseAdapter {
        private FocusRequester() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)ThumbnailViewUI.this, true));
        }
    }

    private final class OptionsChangeListener
    implements PropertyChangeListener {
        private OptionsChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Options options = (Options)evt.getSource();
            EditorOptions editorOptions = options.getEditorOptions();
            TransparencyChessboardOptions chessboardOptions = editorOptions.getTransparencyChessboardOptions();
            GridOptions gridOptions = editorOptions.getGridOptions();
            ImageComponent imageComponent = ThumbnailViewUI.this.cellRenderer.getImageComponent();
            imageComponent.setTransparencyChessboardCellSize(chessboardOptions.getCellSize());
            imageComponent.setTransparencyChessboardWhiteColor(chessboardOptions.getWhiteColor());
            imageComponent.setTransparencyChessboardBlankColor(chessboardOptions.getBlackColor());
            imageComponent.setGridLineZoomFactor(gridOptions.getLineZoomFactor());
            imageComponent.setGridLineSpan(gridOptions.getLineSpan());
            imageComponent.setGridLineColor(gridOptions.getLineColor());
        }
    }

    private final class VFSListener
    implements VirtualFileListener {
        private VFSListener() {
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            int index;
            VirtualFile file = event.getFile();
            if (ThumbnailViewUI.this.list != null && (index = ((DefaultListModel)ThumbnailViewUI.this.list.getModel()).indexOf(file)) != -1) {
                Rectangle cellBounds = ThumbnailViewUI.this.list.getCellBounds(index, index);
                ThumbnailViewUI.this.list.repaint(cellBounds);
            }
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            VirtualFile file = event.getFile();
            VirtualFile root = ThumbnailViewUI.this.thumbnailView.getRoot();
            if (root != null && VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)root, (boolean)false)) {
                ThumbnailViewUI.this.refresh();
            }
            if (ThumbnailViewUI.this.list != null) {
                ((DefaultListModel)ThumbnailViewUI.this.list.getModel()).removeElement(file);
            }
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            ThumbnailViewUI.this.refresh();
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            ThumbnailViewUI.this.refresh();
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            ThumbnailViewUI.this.refresh();
        }
    }

    private final class ThumbnailNavigatable
    implements Navigatable {
        private final VirtualFile file;

        ThumbnailNavigatable(VirtualFile file) {
            this.file = file;
        }

        public void navigate(boolean requestFocus) {
            if (this.file != null) {
                FileEditorManager manager = FileEditorManager.getInstance((Project)ThumbnailViewUI.this.thumbnailView.getProject());
                manager.openFile(this.file, true);
            }
        }

        public boolean canNavigate() {
            return this.file != null;
        }

        public boolean canNavigateToSource() {
            return this.file != null;
        }
    }

    private final class ThumbnailsMouseAdapter
    extends MouseAdapter
    implements MouseMotionListener {
        private ThumbnailsMouseAdapter() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Rectangle cellBounds;
            Point point = e.getPoint();
            int index = ThumbnailViewUI.this.list.locationToIndex(point);
            if (index != -1 && !(cellBounds = ThumbnailViewUI.this.list.getCellBounds(index, index)).contains(point) && (0x80 & e.getModifiersEx()) != 128) {
                ThumbnailViewUI.this.list.clearSelection();
                e.consume();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Rectangle cellBounds;
            Point point = e.getPoint();
            int index = ThumbnailViewUI.this.list.locationToIndex(point);
            if (index != -1 && !(cellBounds = ThumbnailViewUI.this.list.getCellBounds(index, index)).contains(point) && (0x80 & e.getModifiersEx()) != 128) {
                ThumbnailViewUI.this.list.clearSelection();
                e.consume();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Rectangle cellBounds;
            Point point = e.getPoint();
            int index = ThumbnailViewUI.this.list.locationToIndex(point);
            if (index != -1 && !(cellBounds = ThumbnailViewUI.this.list.getCellBounds(index, index)).contains(point) && (0x80 & e.getModifiersEx()) != 128) {
                index = -1;
                ThumbnailViewUI.this.list.clearSelection();
            }
            if (index != -1) {
                if (1 == e.getButton() && e.getClickCount() == 2) {
                    ThumbnailViewUI.this.list.setSelectedIndex(index);
                    VirtualFile selected = (VirtualFile)ThumbnailViewUI.this.list.getSelectedValue();
                    if (selected != null) {
                        if (selected.isDirectory()) {
                            ThumbnailViewUI.this.thumbnailView.setRoot(selected);
                        } else {
                            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)ThumbnailViewUI.this.thumbnailView.getProject());
                            fileEditorManager.openFile(selected, true);
                        }
                        e.consume();
                    }
                }
                if (3 == e.getButton() && e.getClickCount() == 1) {
                    if ((0x80 & e.getModifiersEx()) != 128) {
                        ThumbnailViewUI.this.list.setSelectedIndex(index);
                    } else {
                        ThumbnailViewUI.this.list.getSelectionModel().addSelectionInterval(index, index);
                    }
                    ActionManager actionManager = ActionManager.getInstance();
                    ActionGroup actionGroup = (ActionGroup)actionManager.getAction("Images.ThumbnailsPopupMenu");
                    ActionPopupMenu menu = actionManager.createActionPopupMenu("Images.Thumbnails", actionGroup);
                    JPopupMenu popupMenu = menu.getComponent();
                    popupMenu.pack();
                    JBPopupMenu.showByEvent((MouseEvent)e, (JPopupMenu)popupMenu);
                    e.consume();
                }
            }
        }
    }

    private final class ThumbnailListCellRenderer
    extends ThumbnailComponent
    implements ListCellRenderer {
        private final ImageFileTypeManager typeManager = ImageFileTypeManager.getInstance();

        private ThumbnailListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof VirtualFile) {
                String description;
                VirtualFile file = (VirtualFile)value;
                this.setFileName(file.getName());
                Object toolTipText = IfsUtil.getReferencePath(ThumbnailViewUI.this.thumbnailView.getProject(), file);
                if (!ThumbnailViewUI.this.isFileSizeVisible() && (description = this.getImageComponent().getDescription()) != null) {
                    toolTipText = (String)toolTipText + " [" + description + "]";
                }
                this.setToolTipText((String)toolTipText);
                this.setDirectory(file.isDirectory());
                if (file.isDirectory()) {
                    VirtualFile child;
                    VirtualFile[] children;
                    int imagesCount = 0;
                    VirtualFile[] virtualFileArray = children = file.getChildren();
                    int n = virtualFileArray.length;
                    for (int i = 0; !(i >= n || this.typeManager.isImage(child = virtualFileArray[i]) && ++imagesCount > 100); ++i) {
                    }
                    this.setImagesCount(imagesCount);
                } else {
                    this.setFileSize(file.getLength());
                    try {
                        ImageComponent imageComponent = this.getImageComponent();
                        BufferedImage image = IfsUtil.getImage(file, imageComponent);
                        imageComponent.getDocument().setValue(image);
                        this.setFormat(IfsUtil.getFormat(file));
                    }
                    catch (Exception e) {
                        ImageComponent imageComponent = this.getImageComponent();
                        imageComponent.getDocument().setValue((BufferedImage)null);
                    }
                }
            } else {
                ImageComponent imageComponent = this.getImageComponent();
                imageComponent.getDocument().setValue((BufferedImage)null);
                this.setFileName(null);
                this.setFileSize(0L);
                this.setToolTipText(null);
            }
            if (isSelected) {
                this.setForeground(list.getSelectionForeground());
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setForeground(list.getForeground());
                this.setBackground(list.getBackground());
            }
            return this;
        }
    }
}

