/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.intellij.images.ImagesBundle;
import org.intellij.images.ImagesIcons;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.search.TagFilter;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.actions.ThemeFilter;
import org.intellij.images.thumbnail.impl.ThumbnailViewUI;
import org.intellij.images.vfs.IfsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ThumbnailViewImpl
implements ThumbnailView {
    private final Project project;
    private final ToolWindow toolWindow;
    private boolean recursive = false;
    private VirtualFile root = null;
    private final ThumbnailViewUI myThumbnailViewUI;
    private ThemeFilter myFilter;
    private TagFilter[] myTagFilters;

    ThumbnailViewImpl(Project project) {
        this.project = project;
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)project);
        this.myThumbnailViewUI = new ThumbnailViewUI(this);
        Disposer.register((Disposable)this, (Disposable)this.myThumbnailViewUI);
        this.toolWindow = windowManager.registerToolWindow("Thumbnails", (JComponent)this.myThumbnailViewUI, ToolWindowAnchor.BOTTOM);
        this.toolWindow.setStripeTitle(ImagesBundle.message("thumbnails.toolwindow.name", new Object[0]));
        this.toolWindow.setIcon(ImagesIcons.ThumbnailToolWindow);
        this.setVisible(false);
    }

    private ThumbnailViewUI getUI() {
        return this.myThumbnailViewUI;
    }

    @Override
    public void setRoot(@NotNull VirtualFile root) {
        this.root = root;
        this.updateUI();
    }

    @Override
    public VirtualFile getRoot() {
        return this.root;
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
        this.updateUI();
    }

    @Override
    public void setSelected(@NotNull VirtualFile file, boolean selected) {
        if (this.isVisible()) {
            this.getUI().setSelected(file, selected);
        }
    }

    @Override
    public boolean isSelected(@NotNull VirtualFile file) {
        return this.isVisible() && this.getUI().isSelected(file);
    }

    @Override
    public VirtualFile @NotNull [] getSelection() {
        if (this.isVisible()) {
            return this.getUI().getSelection();
        }
        return VirtualFile.EMPTY_ARRAY;
    }

    @Override
    public void scrollToSelection() {
        if (this.isVisible()) {
            if (!this.toolWindow.isActive()) {
                this.toolWindow.activate((Runnable)new LazyScroller());
            } else {
                this.getUI().scrollToSelection();
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.toolWindow.isAvailable();
    }

    @Override
    public void activate() {
        if (this.isVisible() && !this.toolWindow.isActive()) {
            this.toolWindow.activate(null);
        }
    }

    @Override
    public void setFilter(ThemeFilter filter) {
        this.myFilter = filter;
        this.updateUI();
    }

    @Override
    public ThemeFilter getFilter() {
        return this.myFilter;
    }

    @Override
    public void setTagFilters(TagFilter[] filter) {
        this.myTagFilters = filter;
        this.updateUI();
    }

    @Override
    public TagFilter @Nullable [] getTagFilters() {
        return this.myTagFilters;
    }

    @Override
    public void setVisible(boolean visible) {
        this.toolWindow.setAvailable(visible);
        if (visible) {
            this.setTitle();
            this.getUI().refresh();
        }
    }

    @Override
    public void refresh() {
        this.updateUI();
    }

    private void updateUI() {
        if (this.isVisible()) {
            this.setTitle();
            this.getUI().refresh();
        }
    }

    private void setTitle() {
        this.toolWindow.setTitle(this.root != null ? IfsUtil.getReferencePath(this.project, this.root) : null);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    public void setTransparencyChessboardVisible(boolean visible) {
        if (this.isVisible()) {
            this.getUI().setTransparencyChessboardVisible(visible);
        }
    }

    @Override
    public boolean isTransparencyChessboardVisible() {
        return this.isVisible() && this.getUI().isTransparencyChessboardVisible();
    }

    @Override
    public boolean isEnabledForActionPlace(String place) {
        return this.isVisible() && !"Images.Editor".equals(place);
    }

    @Override
    public boolean isFileSizeVisible() {
        return this.isVisible() && this.getUI().isFileSizeVisible();
    }

    @Override
    public void setFileSizeVisible(boolean visible) {
        if (this.isVisible()) {
            this.getUI().setFileSizeVisible(visible);
        }
    }

    @Override
    public boolean isFileNameVisible() {
        return this.isVisible() && this.getUI().isFileNameVisible();
    }

    @Override
    public void setFileNameVisible(boolean visible) {
        if (this.isVisible()) {
            this.getUI().setFileNameVisible(visible);
        }
    }

    public void dispose() {
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)this.project);
        windowManager.unregisterToolWindow("Thumbnails");
    }

    @Override
    public ImageZoomModel getZoomModel() {
        return ImageZoomModel.STUB;
    }

    @Override
    public void setGridVisible(boolean visible) {
    }

    @Override
    public boolean isGridVisible() {
        return false;
    }

    private final class LazyScroller
    implements Runnable {
        private LazyScroller() {
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(() -> ThumbnailViewImpl.this.getUI().scrollToSelection());
        }
    }
}

