/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.ui.ImageComponentDecorator;
import org.jetbrains.annotations.NotNull;

public final class ToggleFileNameAction
extends ToggleAction {
    public boolean isSelected(@NotNull AnActionEvent e) {
        ImageComponentDecorator decorator = (ImageComponentDecorator)e.getData(ImageComponentDecorator.DATA_KEY);
        return decorator != null && decorator.isEnabledForActionPlace(e.getPlace()) && decorator.isFileNameVisible();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        ImageComponentDecorator decorator = (ImageComponentDecorator)e.getData(ImageComponentDecorator.DATA_KEY);
        if (decorator != null && decorator.isEnabledForActionPlace(e.getPlace())) {
            decorator.setFileNameVisible(state);
            OptionsManager.getInstance().getOptions().getEditorOptions().setFileNameVisible(state);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        ImageComponentDecorator decorator = (ImageComponentDecorator)e.getData(ImageComponentDecorator.DATA_KEY);
        e.getPresentation().setEnabled(decorator != null && decorator.isEnabledForActionPlace(e.getPlace()));
        e.getPresentation().setText(this.isSelected(e) ? IdeBundle.message((String)"action.text.hide.file.name", (Object[])new Object[0]) : IdeBundle.message((String)"action.text.show.file.name", (Object[])new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }
}

