/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.JComponent;
import org.intellij.images.ImagesBundle;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.actionSystem.ThumbnailViewActionUtil;
import org.intellij.images.thumbnail.actions.FilterImagesAction;
import org.intellij.images.thumbnail.actions.ThemeFilter;
import org.jetbrains.annotations.NotNull;

public final class FilterByThemeComboBoxAction
extends ComboBoxAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        ThumbnailView view = ThumbnailViewActionUtil.getVisibleThumbnailView(e);
        boolean hasApplicableExtension = ContainerUtil.and((Object[])((ThemeFilter[])ThemeFilter.EP_NAME.getExtensions()), filter -> project != null && filter.isApplicableToProject(project));
        e.getPresentation().setVisible(view != null && hasApplicableExtension);
        ThemeFilter filter2 = view != null ? view.getFilter() : null;
        e.getPresentation().setText(filter2 == null ? CommonBundle.message((String)"action.text.all", (Object[])new Object[0]) : filter2.getDisplayName());
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new FilterImagesAction(new ThemeFilter(){

            @Override
            public String getDisplayName() {
                return ImagesBundle.message("action.all.text", new Object[0]);
            }

            @Override
            public boolean accepts(VirtualFile file) {
                return true;
            }

            @Override
            public boolean isApplicableToProject(Project project) {
                return true;
            }

            @Override
            public void setFilter(ThumbnailView view) {
                view.setFilter(this);
            }
        }));
        for (ThemeFilter filter : (ThemeFilter[])ThemeFilter.EP_NAME.getExtensions()) {
            group.add((AnAction)new FilterImagesAction(filter));
        }
        return group;
    }
}

