/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.options.impl;

import com.intellij.DynamicBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.intellij.images.ImagesBundle;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.ExternalEditorOptions;
import org.intellij.images.options.GridOptions;
import org.intellij.images.options.Options;
import org.intellij.images.options.TransparencyChessboardOptions;
import org.intellij.images.options.impl.OptionsImpl;
import org.jetbrains.annotations.NotNull;

final class ImagesOptionsComponent {
    private JPanel contentPane;
    private JCheckBox showGrid;
    private JLabel gridLineZoomFactorLabel;
    private JSpinner gridLineZoomFactor;
    private JLabel gridLineSpanLabel;
    private JSpinner gridLineSpan;
    private JCheckBox showChessboard;
    private JSpinner chessboardSize;
    private JLabel chessboardSizeLabel;
    private JLabel externalEditorLabel;
    private TextFieldWithBrowseButton externalEditorPath;
    private final Options options;

    ImagesOptionsComponent() {
        this.$$$setupUI$$$();
        this.options = new OptionsImpl();
        this.gridLineZoomFactorLabel.setLabelFor(this.gridLineZoomFactor);
        this.gridLineSpanLabel.setLabelFor(this.gridLineSpan);
        this.chessboardSizeLabel.setLabelFor(this.chessboardSize);
        this.externalEditorLabel.setLabelFor((Component)this.externalEditorPath);
        this.gridLineZoomFactor.setModel(new SpinnerNumberModel(3, 2, 8, 1));
        this.gridLineSpan.setModel(new SpinnerNumberModel(1, 1, 100, 1));
        this.chessboardSize.setModel(new SpinnerNumberModel(5, 1, 100, 1));
        this.showGrid.addItemListener(new CheckboxOptionsListener("Editor.Grid.showDefault"));
        this.gridLineZoomFactor.addChangeListener(new SpinnerOptionsListener("Editor.Grid.lineZoomFactor"));
        this.gridLineSpan.addChangeListener(new SpinnerOptionsListener("Editor.Grid.lineSpan"));
        this.showChessboard.addItemListener(new CheckboxOptionsListener("Editor.TransparencyChessboard.showDefault"));
        this.chessboardSize.addChangeListener(new SpinnerOptionsListener("Editor.TransparencyChessboard.cellSize"));
        this.externalEditorPath.getTextField().getDocument().addDocumentListener((DocumentListener)((Object)new TextDocumentOptionsListener("ExternalEditor.executablePath")));
        this.externalEditorPath.addActionListener((ActionListener)new ExternalEditorPathActionListener());
        this.updateUI();
    }

    public JPanel getContentPane() {
        return this.contentPane;
    }

    @NotNull
    public Options getOptions() {
        return this.options;
    }

    public void updateUI() {
        EditorOptions editorOptions = this.options.getEditorOptions();
        ExternalEditorOptions externalEditorOptions = this.options.getExternalEditorOptions();
        GridOptions gridOptions = editorOptions.getGridOptions();
        this.showGrid.setSelected(gridOptions.isShowDefault());
        this.gridLineZoomFactor.setValue(gridOptions.getLineZoomFactor());
        this.gridLineSpan.setValue(gridOptions.getLineSpan());
        TransparencyChessboardOptions transparencyChessboardOptions = editorOptions.getTransparencyChessboardOptions();
        this.showChessboard.setSelected(transparencyChessboardOptions.isShowDefault());
        this.chessboardSize.setValue(transparencyChessboardOptions.getCellSize());
        this.externalEditorPath.setText(externalEditorOptions.getExecutablePath());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JSpinner jSpinner;
        JLabel jLabel2;
        JSpinner jSpinner2;
        JLabel jLabel3;
        JSpinner jSpinner3;
        JLabel jLabel4;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(12, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setEnabled(true);
        ((Component)jPanel2).setVisible(true);
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/ImagesBundle", ImagesOptionsComponent.class).getString("main.page.border.title"), (int)0, (int)0, null, null));
        this.showGrid = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/ImagesBundle", ImagesOptionsComponent.class).getString("show.grid.lines"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.showChessboard = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/ImagesBundle", ImagesOptionsComponent.class).getString("show.transparency.chessboard"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 4, 8, 0, 3, 0, null, null, null));
        this.chessboardSizeLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/ImagesBundle", ImagesOptionsComponent.class).getString("chessboard.cell.size"));
        jPanel2.add((Component)jLabel4, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.chessboardSize = jSpinner3 = new JSpinner();
        jPanel2.add((Component)jSpinner3, new GridConstraints(5, 2, 1, 1, 8, 1, 3, 0, null, null, null));
        this.gridLineSpanLabel = jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/ImagesBundle", ImagesOptionsComponent.class).getString("show.grid.every"));
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.gridLineSpan = jSpinner2 = new JSpinner();
        jPanel2.add((Component)jSpinner2, new GridConstraints(2, 2, 1, 1, 8, 1, 3, 0, null, null, null));
        this.gridLineZoomFactorLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/ImagesBundle", ImagesOptionsComponent.class).getString("show.grid.zoom.limit"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.gridLineZoomFactor = jSpinner = new JSpinner();
        jPanel2.add((Component)jSpinner, new GridConstraints(1, 2, 1, 1, 8, 1, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("");
        jPanel2.add((Component)jLabel5, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 1, new Dimension(22, -1), null, new Dimension(22, -1)));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/ImagesBundle", ImagesOptionsComponent.class).getString("external.editor.border.title"), (int)0, (int)0, null, null));
        this.externalEditorLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/ImagesBundle", ImagesOptionsComponent.class).getString("external.editor.executable.path"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.externalEditorPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 2, 1, 1, 0, 1, 7, 3, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, new Dimension(22, -1), null, new Dimension(22, -1)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private final class ExternalEditorPathActionListener
    implements ActionListener {
        private ExternalEditorPathActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Application application = ApplicationManager.getApplication();
            VirtualFile previous = (VirtualFile)application.runWriteAction((Computable)((NullableComputable)() -> {
                String path = FileUtil.toSystemIndependentName((String)ImagesOptionsComponent.this.externalEditorPath.getText());
                return LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
            }));
            FileChooserDescriptor fileDescriptor = new FileChooserDescriptor(true, SystemInfo.isMac, false, false, false, false);
            fileDescriptor.setShowFileSystemRoots(true);
            fileDescriptor.setTitle(ImagesBundle.message("select.external.executable.title", new Object[0]));
            fileDescriptor.setDescription(ImagesBundle.message("select.external.executable.message", new Object[0]));
            FileChooser.chooseFiles((FileChooserDescriptor)fileDescriptor, null, (VirtualFile)previous, files -> {
                String path = ((VirtualFile)files.get(0)).getPath();
                ImagesOptionsComponent.this.externalEditorPath.setText(path);
            });
        }
    }

    private final class TextDocumentOptionsListener
    extends DocumentAdapter {
        private final String name;

        TextDocumentOptionsListener(String name) {
            this.name = name;
        }

        protected void textChanged(@NotNull DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            Position startPosition = document.getStartPosition();
            try {
                ImagesOptionsComponent.this.options.setOption(this.name, document.getText(startPosition.getOffset(), document.getLength()));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private final class ColorOptionsListener
    implements ActionListener {
        private final String name;

        private ColorOptionsListener(String name) {
            this.name = name;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorPanel source = (ColorPanel)e.getSource();
            ImagesOptionsComponent.this.options.setOption(this.name, source.getSelectedColor());
        }
    }

    private final class SpinnerOptionsListener
    implements ChangeListener {
        private final String name;

        private SpinnerOptionsListener(String name) {
            this.name = name;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSpinner source = (JSpinner)e.getSource();
            ImagesOptionsComponent.this.options.setOption(this.name, source.getValue());
        }
    }

    private final class CheckboxOptionsListener
    implements ItemListener {
        @NotNull
        private final String name;

        private CheckboxOptionsListener(String name) {
            this.name = name;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ImagesOptionsComponent.this.options.setOption(this.name, 1 == e.getStateChange());
        }
    }

    private static class LinkEnabledListener
    implements ItemListener {
        private final JComponent[] children;

        LinkEnabledListener(JComponent[] children) {
            this.children = (JComponent[])children.clone();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.setSelected(e.getStateChange() == 1);
        }

        private void setSelected(boolean selected) {
            for (JComponent component : this.children) {
                component.setEnabled(selected);
            }
        }
    }
}

