/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.editor.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import org.intellij.images.editor.actionSystem.ImageEditorActionUtil;
import org.intellij.images.ui.ImageComponentDecorator;
import org.jetbrains.annotations.NotNull;

public final class ToggleGridAction
extends ToggleAction
implements DumbAware {
    public boolean isSelected(@NotNull AnActionEvent e) {
        ImageComponentDecorator decorator = ImageEditorActionUtil.getImageComponentDecorator(e);
        return decorator != null && decorator.isGridVisible();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        ImageComponentDecorator decorator = ImageEditorActionUtil.getImageComponentDecorator(e);
        if (decorator != null) {
            decorator.setGridVisible(state);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        ImageEditorActionUtil.setEnabled(e);
        e.getPresentation().setText(this.isSelected(e) ? IdeBundle.message((String)"action.text.hide.grid", (Object[])new Object[0]) : IdeBundle.message((String)"action.text.show.grid", (Object[])new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }
}

