/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.lower;

import androidx.compose.compiler.plugins.kotlin.lower.FunctionReferenceBuilder;
import androidx.compose.compiler.plugins.kotlin.lower.ModuleLoweringPass;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.IrGeneratorContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextImpl;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/compose/compiler/plugins/kotlin/lower/ComposableFunInterfaceLowering;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "Landroidx/compose/compiler/plugins/kotlin/lower/ModuleLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "(Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;)V", "isFunInterfaceConversion", "", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "lower", "", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "compiler-hosted"})
public final class ComposableFunInterfaceLowering
extends IrElementTransformerVoidWithContext
implements ModuleLoweringPass {
    @NotNull
    private final IrPluginContext context;

    public ComposableFunInterfaceLowering(@NotNull IrPluginContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    public void lower(@NotNull IrModuleFragment module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (JvmPlatformKt.isJvm((TargetPlatform)this.context.getPlatform())) {
            IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)module), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
        }
    }

    private final boolean isFunInterfaceConversion(IrTypeOperatorCall expression) {
        IrExpression argument = expression.getArgument();
        IrTypeOperator operator = expression.getOperator();
        IrType type = expression.getTypeOperand();
        IrClassSymbol functionClass = IrTypesKt.getClassOrNull((IrType)type);
        return operator == IrTypeOperator.SAM_CONVERSION && argument instanceof IrFunctionExpression && IrUtilsKt.isLambda((IrStatementOrigin)((IrFunctionExpression)argument).getOrigin()) && functionClass != null && ((IrClass)functionClass.getOwner()).isFun();
    }

    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (this.isFunInterfaceConversion(expression)) {
            IrExpression irExpression = expression.getArgument().transform((IrElementTransformer)this, null);
            Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionExpression");
            IrFunctionExpression argument = (IrFunctionExpression)irExpression;
            IrType superType = expression.getTypeOperand();
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)superType);
            if (irClassSymbol == null) {
                throw new IllegalStateException("Expected non-null class".toString());
            }
            IrClassSymbol superClass = irClassSymbol;
            IrDeclarationParent irDeclarationParent = this.getCurrentDeclarationParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent);
            IrGeneratorContext irGeneratorContext = (IrGeneratorContext)this.context;
            ScopeWithIr scopeWithIr = this.getCurrentScope();
            Intrinsics.checkNotNull((Object)scopeWithIr);
            return new FunctionReferenceBuilder(argument, superClass, superType, irDeclarationParent, irGeneratorContext, scopeWithIr.getScope().getScopeOwnerSymbol(), (IrTypeSystemContext)new IrTypeSystemContextImpl(this.context.getIrBuiltIns())).build();
        }
        return super.visitTypeOperator(expression);
    }
}

