/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.inference;

import androidx.compose.compiler.plugins.kotlin.inference.Binding;
import androidx.compose.compiler.plugins.kotlin.inference.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0006H\u0002J\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u000eJ\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0006\u0010\u0017\u001a\u00020\nJ\u0016\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/compose/compiler/plugins/kotlin/inference/Bindings;", "", "()V", "listeners", "", "Lkotlin/Function0;", "", "bind", "", "a", "Landroidx/compose/compiler/plugins/kotlin/inference/Binding;", "b", "binding", "token", "", "bindingValueChanged", "value", "Landroidx/compose/compiler/plugins/kotlin/inference/Value;", "changed", "closed", "target", "onChange", "callback", "open", "unify", "unifyValues", "compiler-hosted"})
public final class Bindings {
    @NotNull
    private final List<Function0<Unit>> listeners = new ArrayList();

    @NotNull
    public final Binding open() {
        return new Binding(null, SetsKt.setOf((Object)this), 1, null);
    }

    @NotNull
    public final Binding closed(@NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new Binding(target, SetsKt.emptySet());
    }

    @NotNull
    public final Function0<Unit> onChange(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.listeners.add(callback);
        return (Function0)new Function0<Unit>(this, callback){
            final /* synthetic */ Bindings this$0;
            final /* synthetic */ Function0<Unit> $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
                super(0);
            }

            public final void invoke() {
                Bindings.access$getListeners$p(this.this$0).remove(this.$callback);
            }
        };
    }

    public final boolean unify(@NotNull Binding a, @NotNull Binding b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        String at = a.getValue().getToken();
        String bt = b.getValue().getToken();
        return at != null && bt == null ? this.bind(b, at) : (at == null && bt != null ? this.bind(a, bt) : (at != null && bt != null ? Intrinsics.areEqual((Object)at, (Object)bt) : this.bind(a, b)));
    }

    private final void unifyValues(Binding b, Value value) {
        b.setValue(value);
        Binding current = b.getNext();
        while (!Intrinsics.areEqual((Object)current, (Object)b)) {
            current.setValue(value);
            current = current.getNext();
        }
    }

    private final boolean bind(Binding a, Binding b) {
        Value bValue;
        Value aValue = a.getValue();
        if (Intrinsics.areEqual((Object)aValue, (Object)(bValue = b.getValue()))) {
            return true;
        }
        int aValueSize = aValue.getSize();
        int bValueSize = bValue.getSize();
        Set newObservers = SetsKt.plus(aValue.getObservers(), (Iterable)bValue.getObservers());
        if (aValueSize > bValueSize) {
            aValue.setSize(aValue.getSize() + bValueSize);
            aValue.setObservers(newObservers);
            this.unifyValues(b, aValue);
        } else {
            bValue.setSize(bValue.getSize() + aValueSize);
            bValue.setObservers(newObservers);
            this.unifyValues(a, bValue);
        }
        Binding nextA = a.getNext();
        Binding nextB = b.getNext();
        a.setNext(nextB);
        b.setNext(nextA);
        this.bindingValueChanged(a.getValue());
        return true;
    }

    private final boolean bind(Binding binding, String token) {
        Value value = binding.getValue();
        value.setToken(token);
        this.bindingValueChanged(value);
        value.setObservers(SetsKt.emptySet());
        return true;
    }

    private final void bindingValueChanged(Value value) {
        for (Bindings observer : value.getObservers()) {
            observer.changed();
        }
    }

    private final void changed() {
        if (!((Collection)this.listeners).isEmpty()) {
            for (Function0 listener : CollectionsKt.toMutableList((Collection)this.listeners)) {
                listener.invoke();
            }
        }
    }

    public static final /* synthetic */ List access$getListeners$p(Bindings $this) {
        return $this.listeners;
    }
}

