/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin;

import androidx.compose.compiler.plugins.kotlin.CsvBuilder;
import androidx.compose.compiler.plugins.kotlin.FunctionMetrics;
import androidx.compose.compiler.plugins.kotlin.FunctionMetricsImpl;
import androidx.compose.compiler.plugins.kotlin.JsonBuilder;
import androidx.compose.compiler.plugins.kotlin.JsonBuilderKt;
import androidx.compose.compiler.plugins.kotlin.KtxNameConventions;
import androidx.compose.compiler.plugins.kotlin.ModuleMetrics;
import androidx.compose.compiler.plugins.kotlin.ModuleMetricsImpl;
import androidx.compose.compiler.plugins.kotlin.analysis.Stability;
import androidx.compose.compiler.plugins.kotlin.analysis.StabilityKt;
import androidx.compose.compiler.plugins.kotlin.lower.ComposableFunctionBodyTransformer;
import androidx.compose.compiler.plugins.kotlin.lower.IrSourcePrinterVisitor;
import java.io.File;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrCall;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001GB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0003H\u0016J\u0010\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020+H\u0016J \u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\u001e\u00103\u001a\u00020'2\u0006\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0016J\u0010\u00109\u001a\u00020'2\u0006\u0010*\u001a\u00020\fH\u0016J \u0010:\u001a\u00020'2\u0006\u0010;\u001a\u0002002\u0006\u0010<\u001a\u0002002\u0006\u0010=\u001a\u000200H\u0016J\u0010\u0010>\u001a\u00020'2\u0006\u0010?\u001a\u00020\u0003H\u0016J\u0010\u0010@\u001a\u00020'2\u0006\u0010?\u001a\u00020\u0003H\u0016J\u0010\u0010A\u001a\u00020'*\u00060Bj\u0002`CH\u0016J\u0010\u0010D\u001a\u00020'*\u00060Bj\u0002`CH\u0016J\u0010\u0010E\u001a\u00020'*\u00060Bj\u0002`CH\u0016J\u0010\u0010F\u001a\u00020'*\u00060Bj\u0002`CH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0004R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ModuleMetricsImpl;", "Landroidx/compose/compiler/plugins/kotlin/ModuleMetrics;", "name", "", "(Ljava/lang/String;)V", "certainArguments", "", "classes", "", "Landroidx/compose/compiler/plugins/kotlin/ModuleMetricsImpl$ClassMetrics;", "composableLambdas", "composables", "Landroidx/compose/compiler/plugins/kotlin/FunctionMetrics;", "effectivelyStableClasses", "inferredStableClasses", "inferredUncertainClasses", "inferredUnstableClasses", "knownStableArguments", "knownUnstableArguments", "logMessages", "markedStableClasses", "memoizedLambdas", "getName", "()Ljava/lang/String;", "setName", "readonlyComposables", "restartGroups", "restartableComposables", "singletonComposableLambdas", "singletonLambdas", "skippableComposables", "staticArguments", "totalArguments", "totalClasses", "totalComposables", "totalGroups", "totalLambdas", "unknownStableArguments", "log", "", "message", "makeFunctionMetrics", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "recordClass", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "marked", "", "stability", "Landroidx/compose/compiler/plugins/kotlin/analysis/Stability;", "recordComposableCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "paramMeta", "", "Landroidx/compose/compiler/plugins/kotlin/lower/ComposableFunctionBodyTransformer$ParamMeta;", "recordFunction", "recordLambda", "composable", "memoized", "singleton", "saveMetricsTo", "directory", "saveReportsTo", "appendClassesTxt", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "appendComposablesCsv", "appendComposablesTxt", "appendModuleJson", "ClassMetrics", "compiler-hosted"})
public final class ModuleMetricsImpl
implements ModuleMetrics {
    @NotNull
    private String name;
    private int skippableComposables;
    private int restartableComposables;
    private int readonlyComposables;
    private int totalComposables;
    private int restartGroups;
    private int totalGroups;
    private int staticArguments;
    private int certainArguments;
    private int knownStableArguments;
    private int knownUnstableArguments;
    private int unknownStableArguments;
    private int totalArguments;
    private int markedStableClasses;
    private int inferredStableClasses;
    private int inferredUnstableClasses;
    private int inferredUncertainClasses;
    private int effectivelyStableClasses;
    private int totalClasses;
    private int memoizedLambdas;
    private int singletonLambdas;
    private int singletonComposableLambdas;
    private int composableLambdas;
    private int totalLambdas;
    @NotNull
    private final List<FunctionMetrics> composables;
    @NotNull
    private final List<ClassMetrics> classes;
    @NotNull
    private final List<String> logMessages;

    public ModuleMetricsImpl(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.composables = new ArrayList();
        this.classes = new ArrayList();
        this.logMessages = new ArrayList();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Override
    public void recordFunction(@NotNull FunctionMetrics function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (!function.getComposable()) {
            return;
        }
        int n = this.totalComposables;
        this.totalComposables = n + 1;
        if (!function.isLambda()) {
            this.composables.add(function);
        }
        if (function.getReadonly()) {
            n = this.readonlyComposables;
            this.readonlyComposables = n + 1;
        }
        if (function.getSkippable()) {
            n = this.skippableComposables;
            this.skippableComposables = n + 1;
        }
        if (function.getRestartable()) {
            n = this.restartableComposables;
            this.restartableComposables = n + 1;
            n = this.restartGroups;
            this.restartGroups = n + 1;
        }
        this.totalGroups += function.getGroups();
    }

    @Override
    public void recordClass(@NotNull IrClass declaration, boolean marked, @NotNull Stability stability) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)stability, (String)"stability");
        this.classes.add(new ClassMetrics(declaration, marked, stability));
        int n = this.totalClasses;
        this.totalClasses = n + 1;
        if (marked) {
            n = this.markedStableClasses;
            this.markedStableClasses = n + 1;
            n = this.effectivelyStableClasses;
            this.effectivelyStableClasses = n + 1;
        } else if (StabilityKt.knownStable(stability)) {
            n = this.inferredStableClasses;
            this.inferredStableClasses = n + 1;
            n = this.effectivelyStableClasses;
            this.effectivelyStableClasses = n + 1;
        } else if (StabilityKt.knownUnstable(stability)) {
            n = this.inferredUnstableClasses;
            this.inferredUnstableClasses = n + 1;
        } else {
            n = this.inferredUncertainClasses;
            this.inferredUncertainClasses = n + 1;
        }
    }

    @Override
    public void recordLambda(boolean composable, boolean memoized, boolean singleton) {
        int n = this.totalLambdas;
        this.totalLambdas = n + 1;
        if (composable) {
            n = this.composableLambdas;
            this.composableLambdas = n + 1;
        }
        if (memoized) {
            n = this.memoizedLambdas;
            this.memoizedLambdas = n + 1;
        }
        if (composable && singleton) {
            n = this.singletonComposableLambdas;
            this.singletonComposableLambdas = n + 1;
        }
        if (!composable && singleton) {
            n = this.singletonLambdas;
            this.singletonLambdas = n + 1;
        }
    }

    @Override
    public void recordComposableCall(@NotNull IrCall expression, @NotNull List<ComposableFunctionBodyTransformer.ParamMeta> paramMeta) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter(paramMeta, (String)"paramMeta");
        for (ComposableFunctionBodyTransformer.ParamMeta arg : paramMeta) {
            int n = this.totalArguments;
            this.totalArguments = n + 1;
            if (arg.isCertain()) {
                n = this.certainArguments;
                this.certainArguments = n + 1;
            }
            if (arg.isStatic()) {
                n = this.staticArguments;
                this.staticArguments = n + 1;
            }
            if (StabilityKt.knownStable(arg.getStability())) {
                n = this.knownStableArguments;
                this.knownStableArguments = n + 1;
                continue;
            }
            if (StabilityKt.knownUnstable(arg.getStability())) {
                n = this.knownUnstableArguments;
                this.knownUnstableArguments = n + 1;
                continue;
            }
            n = this.unknownStableArguments;
            this.unknownStableArguments = n + 1;
        }
    }

    @Override
    public void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logMessages.add(message);
    }

    @Override
    public void appendModuleJson(@NotNull Appendable $this$appendModuleJson) {
        Intrinsics.checkNotNullParameter((Object)$this$appendModuleJson, (String)"<this>");
        JsonBuilderKt.appendJson($this$appendModuleJson, (Function1<? super JsonBuilder, Unit>)((Function1)new Function1<JsonBuilder, Unit>(this){
            final /* synthetic */ ModuleMetricsImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull JsonBuilder $this$appendJson) {
                Intrinsics.checkNotNullParameter((Object)$this$appendJson, (String)"$this$appendJson");
                $this$appendJson.entry("skippableComposables", ModuleMetricsImpl.access$getSkippableComposables$p(this.this$0));
                $this$appendJson.entry("restartableComposables", ModuleMetricsImpl.access$getRestartableComposables$p(this.this$0));
                $this$appendJson.entry("readonlyComposables", ModuleMetricsImpl.access$getReadonlyComposables$p(this.this$0));
                $this$appendJson.entry("totalComposables", ModuleMetricsImpl.access$getTotalComposables$p(this.this$0));
                $this$appendJson.entry("restartGroups", ModuleMetricsImpl.access$getRestartGroups$p(this.this$0));
                $this$appendJson.entry("totalGroups", ModuleMetricsImpl.access$getTotalGroups$p(this.this$0));
                $this$appendJson.entry("staticArguments", ModuleMetricsImpl.access$getStaticArguments$p(this.this$0));
                $this$appendJson.entry("certainArguments", ModuleMetricsImpl.access$getCertainArguments$p(this.this$0));
                $this$appendJson.entry("knownStableArguments", ModuleMetricsImpl.access$getKnownStableArguments$p(this.this$0));
                $this$appendJson.entry("knownUnstableArguments", ModuleMetricsImpl.access$getKnownUnstableArguments$p(this.this$0));
                $this$appendJson.entry("unknownStableArguments", ModuleMetricsImpl.access$getUnknownStableArguments$p(this.this$0));
                $this$appendJson.entry("totalArguments", ModuleMetricsImpl.access$getTotalArguments$p(this.this$0));
                $this$appendJson.entry("markedStableClasses", ModuleMetricsImpl.access$getMarkedStableClasses$p(this.this$0));
                $this$appendJson.entry("inferredStableClasses", ModuleMetricsImpl.access$getInferredStableClasses$p(this.this$0));
                $this$appendJson.entry("inferredUnstableClasses", ModuleMetricsImpl.access$getInferredUnstableClasses$p(this.this$0));
                $this$appendJson.entry("inferredUncertainClasses", ModuleMetricsImpl.access$getInferredUncertainClasses$p(this.this$0));
                $this$appendJson.entry("effectivelyStableClasses", ModuleMetricsImpl.access$getEffectivelyStableClasses$p(this.this$0));
                $this$appendJson.entry("totalClasses", ModuleMetricsImpl.access$getTotalClasses$p(this.this$0));
                $this$appendJson.entry("memoizedLambdas", ModuleMetricsImpl.access$getMemoizedLambdas$p(this.this$0));
                $this$appendJson.entry("singletonLambdas", ModuleMetricsImpl.access$getSingletonLambdas$p(this.this$0));
                $this$appendJson.entry("singletonComposableLambdas", ModuleMetricsImpl.access$getSingletonComposableLambdas$p(this.this$0));
                $this$appendJson.entry("composableLambdas", ModuleMetricsImpl.access$getComposableLambdas$p(this.this$0));
                $this$appendJson.entry("totalLambdas", ModuleMetricsImpl.access$getTotalLambdas$p(this.this$0));
            }
        }));
    }

    @Override
    public void appendComposablesCsv(@NotNull Appendable $this$appendComposablesCsv) {
        Intrinsics.checkNotNullParameter((Object)$this$appendComposablesCsv, (String)"<this>");
        JsonBuilderKt.appendCsv($this$appendComposablesCsv, (Function1<? super CsvBuilder, Unit>)((Function1)new Function1<CsvBuilder, Unit>(this){
            final /* synthetic */ ModuleMetricsImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CsvBuilder $this$appendCsv) {
                Intrinsics.checkNotNullParameter((Object)$this$appendCsv, (String)"$this$appendCsv");
                $this$appendCsv.row((Function1<? super CsvBuilder, Unit>)((Function1)appendComposablesCsv.1.INSTANCE));
                for (FunctionMetrics fn : ModuleMetricsImpl.access$getComposables$p(this.this$0)) {
                    $this$appendCsv.row((Function1<? super CsvBuilder, Unit>)((Function1)new Function1<CsvBuilder, Unit>(fn){
                        final /* synthetic */ FunctionMetrics $fn;
                        {
                            this.$fn = $fn;
                            super(1);
                        }

                        public final void invoke(@NotNull CsvBuilder $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            String string = this.$fn.getPackageName().asString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fn.packageName.asString()");
                            $this$row.col(string);
                            $this$row.col(this.$fn.getName());
                            $this$row.col(this.$fn.getComposable());
                            $this$row.col(this.$fn.getSkippable());
                            $this$row.col(this.$fn.getRestartable());
                            $this$row.col(this.$fn.getReadonly());
                            $this$row.col(this.$fn.getInline());
                            $this$row.col(this.$fn.isLambda());
                            $this$row.col(this.$fn.getHasDefaults());
                            $this$row.col(this.$fn.getDefaultsGroup());
                            $this$row.col(this.$fn.getGroups());
                            $this$row.col(this.$fn.getCalls());
                        }
                    }));
                }
            }
        }));
    }

    @Override
    public void appendComposablesTxt(@NotNull Appendable $this$appendComposablesTxt) {
        Intrinsics.checkNotNullParameter((Object)$this$appendComposablesTxt, (String)"<this>");
        IrSourcePrinterVisitor src = new IrSourcePrinterVisitor($this$appendComposablesTxt, null, 2, null);
        for (FunctionMetrics fn : this.composables) {
            fn.print($this$appendComposablesTxt, src);
        }
    }

    @Override
    public void appendClassesTxt(@NotNull Appendable $this$appendClassesTxt) {
        Intrinsics.checkNotNullParameter((Object)$this$appendClassesTxt, (String)"<this>");
        IrSourcePrinterVisitor src = new IrSourcePrinterVisitor($this$appendClassesTxt, null, 2, null);
        for (ClassMetrics declaration : this.classes) {
            declaration.print($this$appendClassesTxt, src);
        }
    }

    @Override
    public void saveMetricsTo(@NotNull String directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        File dir = new File(directory);
        String prefix = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)this.name, (char)'.', (char)'_', (boolean)false, (int)4, null), (String)"<", (String)"", (boolean)false, (int)4, null), (String)">", (String)"", (boolean)false, (int)4, null);
        JsonBuilderKt.write(new File(dir, prefix + "-module.json"), (Function1<? super OutputStreamWriter, Unit>)((Function1)new Function1<OutputStreamWriter, Unit>(this){
            final /* synthetic */ ModuleMetricsImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull OutputStreamWriter $this$write) {
                Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                this.this$0.appendModuleJson($this$write);
            }
        }));
    }

    @Override
    public void saveReportsTo(@NotNull String directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        File dir = new File(directory);
        String prefix = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)this.name, (char)'.', (char)'_', (boolean)false, (int)4, null), (String)"<", (String)"", (boolean)false, (int)4, null), (String)">", (String)"", (boolean)false, (int)4, null);
        JsonBuilderKt.write(new File(dir, prefix + "-composables.csv"), (Function1<? super OutputStreamWriter, Unit>)((Function1)new Function1<OutputStreamWriter, Unit>(this){
            final /* synthetic */ ModuleMetricsImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull OutputStreamWriter $this$write) {
                Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                this.this$0.appendComposablesCsv($this$write);
            }
        }));
        JsonBuilderKt.write(new File(dir, prefix + "-composables.txt"), (Function1<? super OutputStreamWriter, Unit>)((Function1)new Function1<OutputStreamWriter, Unit>(this){
            final /* synthetic */ ModuleMetricsImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull OutputStreamWriter $this$write) {
                Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                this.this$0.appendComposablesTxt($this$write);
            }
        }));
        if (!((Collection)this.logMessages).isEmpty()) {
            JsonBuilderKt.write(new File(dir, prefix + "-composables.log"), (Function1<? super OutputStreamWriter, Unit>)((Function1)new Function1<OutputStreamWriter, Unit>(this){
                final /* synthetic */ ModuleMetricsImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull OutputStreamWriter $this$write) {
                    Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                    for (String line : ModuleMetricsImpl.access$getLogMessages$p(this.this$0)) {
                        Appendable appendable = ((Appendable)$this$write).append(line);
                        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value)");
                        Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append('\\n')");
                    }
                }
            }));
        }
        JsonBuilderKt.write(new File(dir, prefix + "-classes.txt"), (Function1<? super OutputStreamWriter, Unit>)((Function1)new Function1<OutputStreamWriter, Unit>(this){
            final /* synthetic */ ModuleMetricsImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull OutputStreamWriter $this$write) {
                Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                this.this$0.appendClassesTxt($this$write);
            }
        }));
    }

    @Override
    @NotNull
    public FunctionMetrics makeFunctionMetrics(@NotNull IrFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        return new FunctionMetricsImpl(function);
    }

    public static final /* synthetic */ int access$getSkippableComposables$p(ModuleMetricsImpl $this) {
        return $this.skippableComposables;
    }

    public static final /* synthetic */ int access$getRestartableComposables$p(ModuleMetricsImpl $this) {
        return $this.restartableComposables;
    }

    public static final /* synthetic */ int access$getReadonlyComposables$p(ModuleMetricsImpl $this) {
        return $this.readonlyComposables;
    }

    public static final /* synthetic */ int access$getTotalComposables$p(ModuleMetricsImpl $this) {
        return $this.totalComposables;
    }

    public static final /* synthetic */ int access$getRestartGroups$p(ModuleMetricsImpl $this) {
        return $this.restartGroups;
    }

    public static final /* synthetic */ int access$getTotalGroups$p(ModuleMetricsImpl $this) {
        return $this.totalGroups;
    }

    public static final /* synthetic */ int access$getStaticArguments$p(ModuleMetricsImpl $this) {
        return $this.staticArguments;
    }

    public static final /* synthetic */ int access$getCertainArguments$p(ModuleMetricsImpl $this) {
        return $this.certainArguments;
    }

    public static final /* synthetic */ int access$getKnownStableArguments$p(ModuleMetricsImpl $this) {
        return $this.knownStableArguments;
    }

    public static final /* synthetic */ int access$getKnownUnstableArguments$p(ModuleMetricsImpl $this) {
        return $this.knownUnstableArguments;
    }

    public static final /* synthetic */ int access$getUnknownStableArguments$p(ModuleMetricsImpl $this) {
        return $this.unknownStableArguments;
    }

    public static final /* synthetic */ int access$getTotalArguments$p(ModuleMetricsImpl $this) {
        return $this.totalArguments;
    }

    public static final /* synthetic */ int access$getMarkedStableClasses$p(ModuleMetricsImpl $this) {
        return $this.markedStableClasses;
    }

    public static final /* synthetic */ int access$getInferredStableClasses$p(ModuleMetricsImpl $this) {
        return $this.inferredStableClasses;
    }

    public static final /* synthetic */ int access$getInferredUnstableClasses$p(ModuleMetricsImpl $this) {
        return $this.inferredUnstableClasses;
    }

    public static final /* synthetic */ int access$getInferredUncertainClasses$p(ModuleMetricsImpl $this) {
        return $this.inferredUncertainClasses;
    }

    public static final /* synthetic */ int access$getEffectivelyStableClasses$p(ModuleMetricsImpl $this) {
        return $this.effectivelyStableClasses;
    }

    public static final /* synthetic */ int access$getTotalClasses$p(ModuleMetricsImpl $this) {
        return $this.totalClasses;
    }

    public static final /* synthetic */ int access$getMemoizedLambdas$p(ModuleMetricsImpl $this) {
        return $this.memoizedLambdas;
    }

    public static final /* synthetic */ int access$getSingletonLambdas$p(ModuleMetricsImpl $this) {
        return $this.singletonLambdas;
    }

    public static final /* synthetic */ int access$getSingletonComposableLambdas$p(ModuleMetricsImpl $this) {
        return $this.singletonComposableLambdas;
    }

    public static final /* synthetic */ int access$getComposableLambdas$p(ModuleMetricsImpl $this) {
        return $this.composableLambdas;
    }

    public static final /* synthetic */ int access$getTotalLambdas$p(ModuleMetricsImpl $this) {
        return $this.totalLambdas;
    }

    public static final /* synthetic */ List access$getComposables$p(ModuleMetricsImpl $this) {
        return $this.composables;
    }

    public static final /* synthetic */ List access$getLogMessages$p(ModuleMetricsImpl $this) {
        return $this.logMessages;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\n\u0010\u0012\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ModuleMetricsImpl$ClassMetrics;", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "marked", "", "stability", "Landroidx/compose/compiler/plugins/kotlin/analysis/Stability;", "(Landroidx/compose/compiler/plugins/kotlin/ModuleMetricsImpl;Lorg/jetbrains/kotlin/ir/declarations/IrClass;ZLandroidx/compose/compiler/plugins/kotlin/analysis/Stability;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getMarked", "()Z", "getStability", "()Landroidx/compose/compiler/plugins/kotlin/analysis/Stability;", "print", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "out", "src", "Landroidx/compose/compiler/plugins/kotlin/lower/IrSourcePrinterVisitor;", "simpleHumanReadable", "", "compiler-hosted"})
    private final class ClassMetrics {
        @NotNull
        private final IrClass declaration;
        private final boolean marked;
        @NotNull
        private final Stability stability;

        public ClassMetrics(IrClass declaration, @NotNull boolean marked, Stability stability) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)stability, (String)"stability");
            this.declaration = declaration;
            this.marked = marked;
            this.stability = stability;
        }

        @NotNull
        public final IrClass getDeclaration() {
            return this.declaration;
        }

        public final boolean getMarked() {
            return this.marked;
        }

        @NotNull
        public final Stability getStability() {
            return this.stability;
        }

        private final String simpleHumanReadable(Stability $this$simpleHumanReadable) {
            return StabilityKt.knownStable($this$simpleHumanReadable) ? "stable" : (StabilityKt.knownUnstable($this$simpleHumanReadable) ? "unstable" : "runtime");
        }

        @NotNull
        public final Appendable print(@NotNull Appendable out, @NotNull IrSourcePrinterVisitor src) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            Appendable $this$print_u24lambda_u240 = out;
            boolean bl = false;
            $this$print_u24lambda_u240.append(this.simpleHumanReadable(this.stability) + " ");
            $this$print_u24lambda_u240.append("class ");
            $this$print_u24lambda_u240.append(this.declaration.getName().asString());
            Appendable appendable = $this$print_u24lambda_u240.append(" {");
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append('\\n')");
            for (IrDeclaration decl : this.declaration.getDeclarations()) {
                IrField field;
                IrField irField;
                IrDeclaration irDeclaration = decl;
                boolean isVar = irDeclaration instanceof IrProperty ? ((IrProperty)decl).isVar() : irDeclaration instanceof IrField;
                IrDeclaration irDeclaration2 = decl;
                if (irDeclaration2 instanceof IrProperty) {
                    irField = ((IrProperty)decl).getBackingField();
                    if (irField == null) {
                        continue;
                    }
                } else {
                    if (!(irDeclaration2 instanceof IrField)) continue;
                    irField = (IrField)decl;
                }
                if (Intrinsics.areEqual((Object)(field = irField).getName(), (Object)KtxNameConventions.INSTANCE.getSTABILITY_FLAG())) continue;
                $this$print_u24lambda_u240.append("  ");
                Stability fieldStability = StabilityKt.stabilityOf(field.getType());
                $this$print_u24lambda_u240.append(this.simpleHumanReadable(fieldStability) + " ");
                $this$print_u24lambda_u240.append(isVar ? "var " : "val ");
                $this$print_u24lambda_u240.append(field.getName().asString());
                $this$print_u24lambda_u240.append(": ");
                $this$print_u24lambda_u240.append(src.printType(field.getType()));
                Intrinsics.checkNotNullExpressionValue((Object)$this$print_u24lambda_u240.append('\n'), (String)"append('\\n')");
            }
            if (!this.marked) {
                Appendable appendable2 = $this$print_u24lambda_u240.append("  <runtime stability> = " + this.stability);
                Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)appendable2.append('\n'), (String)"append('\\n')");
            }
            Appendable appendable3 = $this$print_u24lambda_u240.append("}");
            Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append(value)");
            Appendable appendable4 = appendable3.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)appendable4, (String)"append('\\n')");
            return appendable4;
        }
    }
}

