/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin;

import androidx.compose.compiler.plugins.kotlin.ComposableCallChecker;
import androidx.compose.compiler.plugins.kotlin.ComposableDeclarationChecker;
import androidx.compose.compiler.plugins.kotlin.ComposableTargetChecker;
import androidx.compose.compiler.plugins.kotlin.ComposeConfiguration;
import androidx.compose.compiler.plugins.kotlin.ComposeDiagnosticSuppressor;
import androidx.compose.compiler.plugins.kotlin.ComposeIrGenerationExtension;
import androidx.compose.compiler.plugins.kotlin.ComposeTypeResolutionInterceptorExtension;
import androidx.compose.compiler.plugins.kotlin.lower.ClassStabilityFieldSerializationPlugin;
import com.intellij.mock.MockProject;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compiler.plugin.ComponentRegistrar;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.extensions.StorageComponentContainerContributor;
import org.jetbrains.kotlin.extensions.internal.TypeResolutionInterceptor;
import org.jetbrains.kotlin.serialization.DescriptorSerializerPlugin;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ComposeComponentRegistrar;", "Lorg/jetbrains/kotlin/compiler/plugin/ComponentRegistrar;", "()V", "registerProjectComponents", "", "project", "Lcom/intellij/mock/MockProject;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "Companion", "compiler-hosted"})
public final class ComposeComponentRegistrar
implements ComponentRegistrar {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void registerProjectComponents(@NotNull MockProject project, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (Companion.checkCompilerVersion(configuration)) {
            Companion.registerCommonExtensions((Project)project);
            IrGenerationExtension.Companion.registerExtension((Project)project, (Object)Companion.createComposeIrExtension(configuration));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ComposeComponentRegistrar$Companion;", "", "()V", "checkCompilerVersion", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "createComposeIrExtension", "Landroidx/compose/compiler/plugins/kotlin/ComposeIrGenerationExtension;", "registerCommonExtensions", "", "project", "Lcom/intellij/openapi/project/Project;", "compiler-hosted"})
    @SourceDebugExtension(value={"SMAP\nComposePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposePlugin.kt\nandroidx/compose/compiler/plugins/kotlin/ComposeComponentRegistrar$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,363:1\n1#2:364\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean checkCompilerVersion(@NotNull CompilerConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            try {
                String KOTLIN_VERSION_EXPECTATION = "1.8.20";
                String string = KotlinCompilerVersion.getVersion();
                if (string != null) {
                    String version = string;
                    boolean bl = false;
                    MessageCollector msgCollector = (MessageCollector)configuration.get(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
                    String suppressKotlinVersionCheck = (String)configuration.get(ComposeConfiguration.INSTANCE.getSUPPRESS_KOTLIN_VERSION_COMPATIBILITY_CHECK());
                    if (suppressKotlinVersionCheck != null && !Intrinsics.areEqual((Object)suppressKotlinVersionCheck, (Object)version)) {
                        if (Intrinsics.areEqual((Object)suppressKotlinVersionCheck, (Object)"true")) {
                            MessageCollector messageCollector = msgCollector;
                            if (messageCollector != null) {
                                MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.STRONG_WARNING, (String)(" `suppressKotlinVersionCompatibilityCheck` should specify the version of Kotlin for which you want the compatibility check to be disabled. For example, `suppressKotlinVersionCompatibilityCheck=" + version + "`"), null, (int)4, null);
                            }
                        } else {
                            MessageCollector messageCollector = msgCollector;
                            if (messageCollector != null) {
                                MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.STRONG_WARNING, (String)(" `suppressKotlinVersionCompatibilityCheck` is set to a version of Kotlin (" + suppressKotlinVersionCheck + ") that you are not using and should be set properly. (you are using Kotlin " + version + ")"), null, (int)4, null);
                            }
                        }
                    }
                    if (Intrinsics.areEqual((Object)suppressKotlinVersionCheck, (Object)KOTLIN_VERSION_EXPECTATION)) {
                        MessageCollector messageCollector = msgCollector;
                        if (messageCollector != null) {
                            MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.STRONG_WARNING, (String)(" `suppressKotlinVersionCompatibilityCheck` is set to the same version of Kotlin that the Compose Compiler was already expecting (Kotlin " + suppressKotlinVersionCheck + "), and thus has no effect and should be removed."), null, (int)4, null);
                        }
                    }
                    if (!(Intrinsics.areEqual((Object)suppressKotlinVersionCheck, (Object)"true") || Intrinsics.areEqual((Object)version, (Object)KOTLIN_VERSION_EXPECTATION) || Intrinsics.areEqual((Object)version, (Object)suppressKotlinVersionCheck))) {
                        MessageCollector messageCollector = msgCollector;
                        if (messageCollector != null) {
                            MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)("This version (1.5.0-alpha02) of the Compose Compiler requires Kotlin version " + KOTLIN_VERSION_EXPECTATION + " but you appear to be using Kotlin version " + version + " which is not known to be compatible.  Please consult the Compose-Kotlin compatibility map located at https://developer.android.com/jetpack/androidx/releases/compose-kotlin to choose a compatible version pair (or `suppressKotlinVersionCompatibilityCheck` but don't say I didn't warn you!)."), null, (int)4, null);
                        }
                        return false;
                    }
                }
                return true;
            }
            catch (Throwable t) {
                throw new Error("Something went wrong while checking for version compatibility between the Compose Compiler and the Kotlin Compiler.  It is possible that the versions are incompatible.  Please verify your kotlin version  and consult the Compose-Kotlin compatibility map located at https://developer.android.com/jetpack/androidx/releases/compose-kotlin", t);
            }
        }

        public final void registerCommonExtensions(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            StorageComponentContainerContributor.Companion.registerExtension(project, (Object)new ComposableCallChecker());
            StorageComponentContainerContributor.Companion.registerExtension(project, (Object)new ComposableDeclarationChecker());
            StorageComponentContainerContributor.Companion.registerExtension(project, (Object)new ComposableTargetChecker());
            ComposeDiagnosticSuppressor.Companion.registerExtension(project, new ComposeDiagnosticSuppressor());
            TypeResolutionInterceptor.Companion.registerExtension(project, (Object)new ComposeTypeResolutionInterceptorExtension());
            DescriptorSerializerPlugin.Companion.registerExtension(project, (Object)new ClassStabilityFieldSerializationPlugin());
        }

        @NotNull
        public final ComposeIrGenerationExtension createComposeIrExtension(@NotNull CompilerConfiguration configuration) {
            CharSequence charSequence;
            CharSequence charSequence2;
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            boolean liveLiteralsEnabled = configuration.getBoolean(ComposeConfiguration.INSTANCE.getLIVE_LITERALS_ENABLED_KEY());
            boolean liveLiteralsV2Enabled = configuration.getBoolean(ComposeConfiguration.INSTANCE.getLIVE_LITERALS_V2_ENABLED_KEY());
            boolean generateFunctionKeyMetaClasses = configuration.getBoolean(ComposeConfiguration.INSTANCE.getGENERATE_FUNCTION_KEY_META_CLASSES_KEY());
            boolean sourceInformationEnabled = configuration.getBoolean(ComposeConfiguration.INSTANCE.getSOURCE_INFORMATION_ENABLED_KEY());
            Object object = configuration.get(ComposeConfiguration.INSTANCE.getINTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_KEY(), (Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configuration.get(\n     \u2026      false\n            )");
            boolean intrinsicRememberEnabled = (Boolean)object;
            boolean decoysEnabled = configuration.getBoolean(ComposeConfiguration.INSTANCE.getDECOYS_ENABLED_KEY());
            CharSequence charSequence3 = (CharSequence)configuration.get(ComposeConfiguration.INSTANCE.getMETRICS_DESTINATION_KEY(), (Object)"");
            if (StringsKt.isBlank((CharSequence)charSequence3)) {
                boolean bl = false;
                charSequence2 = null;
            } else {
                charSequence2 = charSequence3;
            }
            String metricsDestination = (String)charSequence2;
            CharSequence bl = (CharSequence)configuration.get(ComposeConfiguration.INSTANCE.getREPORTS_DESTINATION_KEY(), (Object)"");
            if (StringsKt.isBlank((CharSequence)bl)) {
                boolean bl2 = false;
                charSequence = null;
            } else {
                charSequence = bl;
            }
            String reportsDestination = (String)charSequence;
            boolean validateIr = configuration.getBoolean(JVMConfigurationKeys.VALIDATE_IR);
            return new ComposeIrGenerationExtension(liveLiteralsEnabled, liveLiteralsV2Enabled, generateFunctionKeyMetaClasses, sourceInformationEnabled, intrinsicRememberEnabled, decoysEnabled, metricsDestination, reportsDestination, validateIr);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

