/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin;

import androidx.compose.compiler.plugins.kotlin.ComposableCallCheckerKt;
import androidx.compose.compiler.plugins.kotlin.ComposeErrors;
import androidx.compose.compiler.plugins.kotlin.ComposeFqNamesKt;
import androidx.compose.compiler.plugins.kotlin.analysis.ComposeWritableSlices;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.container.StorageComponentContainer;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.extensions.StorageComponentContainerContributor;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\r\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J,\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J$\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\n2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0002J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0002J \u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016\u00a8\u0006*"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ComposableCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "Lorg/jetbrains/kotlin/extensions/StorageComponentContainerContributor;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkInlineLambdaCall", "checkType", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "illegalCall", "callEl", "functionEl", "illegalCallMustBeReadonly", "illegalComposableDelegate", "illegalComposableFunctionReference", "refExpr", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "missingDisallowedComposableCallPropagation", "unmarkedParamEl", "unmarkedParamDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "markedParamDescriptor", "registerModuleComponents", "container", "Lorg/jetbrains/kotlin/container/StorageComponentContainer;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "compiler-hosted"})
public class ComposableCallChecker
implements CallChecker,
AdditionalTypeChecker,
StorageComponentContainerContributor {
    public void registerModuleComponents(@NotNull StorageComponentContainer container, @NotNull TargetPlatform platform, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        DslKt.useInstance((StorageComponentContainer)container, (Object)this);
    }

    private final void checkInlineLambdaCall(ResolvedCall<?> resolvedCall, PsiElement reportOn, CallCheckerContext context) {
        if (!(resolvedCall instanceof VariableAsFunctionResolvedCall)) {
            return;
        }
        CallableDescriptor callableDescriptor = ((VariableAsFunctionResolvedCall)resolvedCall).getVariableCall().getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"resolvedCall.variableCall.resultingDescriptor");
        VariableDescriptor descriptor = (VariableDescriptor)callableDescriptor;
        if (!(descriptor instanceof ValueParameterDescriptor)) {
            return;
        }
        KotlinType kotlinType = ((ValueParameterDescriptor)descriptor).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"descriptor.type");
        if (ComposeFqNamesKt.hasDisallowComposableCallsAnnotation((Annotated)kotlinType)) {
            return;
        }
        CallableDescriptor function = ((ValueParameterDescriptor)descriptor).getContainingDeclaration();
        if (function instanceof FunctionDescriptor && ((FunctionDescriptor)function).isInline() && ComposableCallCheckerKt.isMarkedAsComposable(function)) {
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
            BindingContext bindingContext2 = bindingContext;
            PsiElement node = reportOn;
            while (node != null) {
                SimpleFunctionDescriptor fn;
                PsiElement psiElement = node;
                if (psiElement instanceof KtLambdaExpression) {
                    PsiElement parameterSrc;
                    KtFunctionLiteral ktFunctionLiteral = ((KtLambdaExpression)node).getFunctionLiteral();
                    Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"node.functionLiteral");
                    ValueParameterDescriptor arg = ComposableCallCheckerKt.access$getArgumentDescriptor((KtExpression)ktFunctionLiteral, bindingContext2);
                    ValueParameterDescriptor valueParameterDescriptor = arg;
                    boolean bl = valueParameterDescriptor != null && (valueParameterDescriptor = valueParameterDescriptor.getType()) != null ? ComposeFqNamesKt.hasDisallowComposableCallsAnnotation((Annotated)valueParameterDescriptor) : false;
                    if (bl && (parameterSrc = SourceLocationUtilsKt.findPsi((DeclarationDescriptor)((DeclarationDescriptor)descriptor))) != null) {
                        this.missingDisallowedComposableCallPropagation(context, parameterSrc, (ValueParameterDescriptor)descriptor, arg);
                    }
                } else if (psiElement instanceof KtFunction && Intrinsics.areEqual((Object)(fn = (SimpleFunctionDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)node)), (Object)function)) {
                    return;
                }
                node = (PsiElement)((psiElement = node.getParent()) instanceof KtElement ? (KtElement)psiElement : null);
            }
        }
    }

    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BindingContext bindingContext = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
        BindingContext bindingContext2 = bindingContext;
        if (!ComposableCallCheckerKt.isComposableDelegateReference(resolvedCall, bindingContext2) && !ComposableCallCheckerKt.isComposableInvocation(resolvedCall)) {
            this.checkInlineLambdaCall(resolvedCall, reportOn, context);
            return;
        }
        PsiElement node = reportOn;
        while (node != null) {
            PsiElement psiElement = node;
            if (!(psiElement instanceof KtFunctionLiteral)) {
                List arg;
                boolean composable;
                SimpleFunctionDescriptor descriptor;
                if (psiElement instanceof KtLambdaExpression) {
                    descriptor = (SimpleFunctionDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)((KtLambdaExpression)node).getFunctionLiteral());
                    if (descriptor == null) {
                        ComposableCallChecker.illegalCall$default(this, context, reportOn, null, 4, null);
                        return;
                    }
                    composable = ComposableCallCheckerKt.isComposableCallable((CallableDescriptor)descriptor, bindingContext2);
                    if (composable) {
                        return;
                    }
                    KtFunctionLiteral ktFunctionLiteral = ((KtLambdaExpression)node).getFunctionLiteral();
                    Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"node.functionLiteral");
                    arg = ComposableCallCheckerKt.access$getArgumentDescriptor((KtExpression)ktFunctionLiteral, bindingContext2);
                    List list = arg;
                    boolean bl = list != null && (list = list.getType()) != null ? ComposeFqNamesKt.hasDisallowComposableCallsAnnotation((Annotated)list) : false;
                    if (bl) {
                        context.getTrace().record(ComposeWritableSlices.INSTANCE.getLAMBDA_CAPABLE_OF_COMPOSER_CAPTURE(), (Object)descriptor, (Object)false);
                        context.getTrace().report((Diagnostic)ComposeErrors.CAPTURED_COMPOSABLE_INVOCATION.on(reportOn, (Object)arg, (Object)arg.getContainingDeclaration()));
                        return;
                    }
                    boolean isInlined = InlineUtil.isInlinedArgument((KtFunction)((KtFunction)((KtLambdaExpression)node).getFunctionLiteral()), (BindingContext)bindingContext2, (boolean)true);
                    if (!isInlined) {
                        ComposableCallChecker.illegalCall$default(this, context, reportOn, null, 4, null);
                        return;
                    }
                    context.getTrace().record(ComposeWritableSlices.INSTANCE.getLAMBDA_CAPABLE_OF_COMPOSER_CAPTURE(), (Object)descriptor, (Object)true);
                } else if (psiElement instanceof KtTryExpression) {
                    PsiElement tryKeyword = ((KtTryExpression)node).getTryKeyword();
                    if (((KtTryExpression)node).getTryBlock().getTextRange().contains(reportOn.getTextRange()) && tryKeyword != null) {
                        context.getTrace().report((Diagnostic)ComposeErrors.ILLEGAL_TRY_CATCH_AROUND_COMPOSABLE.on(tryKeyword));
                    }
                } else {
                    if (psiElement instanceof KtFunction) {
                        descriptor = (SimpleFunctionDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)node);
                        if (descriptor == null) {
                            ComposableCallChecker.illegalCall$default(this, context, reportOn, null, 4, null);
                            return;
                        }
                        composable = ComposableCallCheckerKt.isComposableCallable((CallableDescriptor)descriptor, bindingContext2);
                        if (!composable) {
                            PsiElement psiElement2 = ((KtFunction)node).getNameIdentifier();
                            if (psiElement2 == null) {
                                psiElement2 = node;
                            }
                            this.illegalCall(context, reportOn, psiElement2);
                        }
                        if (ComposeFqNamesKt.hasReadonlyComposableAnnotation((Annotated)descriptor) && !ComposableCallCheckerKt.isReadOnlyComposableInvocation(resolvedCall)) {
                            this.illegalCallMustBeReadonly(context, reportOn);
                        }
                        return;
                    }
                    if (psiElement instanceof KtProperty) {
                        descriptor = (DeclarationDescriptor)bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)node);
                        if (ComposableCallCheckerKt.isComposableDelegateOperator(resolvedCall) && descriptor instanceof VariableDescriptorWithAccessors && ((VariableDescriptorWithAccessors)descriptor).isDelegated()) {
                            if (((VariableDescriptorWithAccessors)descriptor).isVar()) {
                                this.illegalComposableDelegate(context, reportOn);
                            }
                            return;
                        }
                        if (!(descriptor instanceof LocalVariableDescriptor)) {
                            List list = ((KtProperty)node).getAnnotationEntries();
                            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"node.annotationEntries");
                            if (ComposableCallCheckerKt.hasComposableAnnotation(list, bindingContext2)) {
                                ComposableCallChecker.illegalCall$default(this, context, reportOn, null, 4, null);
                                return;
                            }
                        }
                    } else {
                        if (psiElement instanceof KtPropertyAccessor) {
                            KtProperty ktProperty = ((KtPropertyAccessor)node).getProperty();
                            Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"node.property");
                            KtProperty property = ktProperty;
                            arg = ((KtPropertyAccessor)node).getAnnotationEntries();
                            Intrinsics.checkNotNullExpressionValue((Object)arg, (String)"node\n                        .annotationEntries");
                            boolean isComposable = ComposableCallCheckerKt.hasComposableAnnotation(arg, bindingContext2);
                            if (!isComposable) {
                                PsiElement psiElement3 = property.getNameIdentifier();
                                if (psiElement3 == null) {
                                    psiElement3 = (PsiElement)property;
                                }
                                this.illegalCall(context, reportOn, psiElement3);
                            }
                            PropertyAccessorDescriptor propertyAccessorDescriptor = (PropertyAccessorDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.PROPERTY_ACCESSOR, (Object)node);
                            if (propertyAccessorDescriptor == null) {
                                return;
                            }
                            PropertyAccessorDescriptor descriptor2 = propertyAccessorDescriptor;
                            if (ComposeFqNamesKt.hasReadonlyComposableAnnotation((Annotated)descriptor2) && !ComposableCallCheckerKt.isReadOnlyComposableInvocation(resolvedCall)) {
                                this.illegalCallMustBeReadonly(context, reportOn);
                            }
                            return;
                        }
                        if (psiElement instanceof KtCallableReferenceExpression) {
                            this.illegalComposableFunctionReference(context, (KtCallableReferenceExpression)node);
                            return;
                        }
                        if (psiElement instanceof KtFile) {
                            ComposableCallChecker.illegalCall$default(this, context, reportOn, null, 4, null);
                            return;
                        }
                        if (psiElement instanceof KtClass) {
                            ComposableCallChecker.illegalCall$default(this, context, reportOn, null, 4, null);
                            return;
                        }
                    }
                }
            }
            node = (PsiElement)((psiElement = node.getParent()) instanceof KtElement ? (KtElement)psiElement : null);
        }
    }

    private final void missingDisallowedComposableCallPropagation(CallCheckerContext context, PsiElement unmarkedParamEl, ValueParameterDescriptor unmarkedParamDescriptor, ValueParameterDescriptor markedParamDescriptor) {
        context.getTrace().report((Diagnostic)ComposeErrors.MISSING_DISALLOW_COMPOSABLE_CALLS_ANNOTATION.on(unmarkedParamEl, (Object)unmarkedParamDescriptor, (Object)markedParamDescriptor, (Object)markedParamDescriptor.getContainingDeclaration()));
    }

    private final void illegalCall(CallCheckerContext context, PsiElement callEl, PsiElement functionEl) {
        context.getTrace().report((Diagnostic)ComposeErrors.COMPOSABLE_INVOCATION.on(callEl));
        if (functionEl != null) {
            context.getTrace().report((Diagnostic)ComposeErrors.COMPOSABLE_EXPECTED.on(functionEl));
        }
    }

    static /* synthetic */ void illegalCall$default(ComposableCallChecker composableCallChecker, CallCheckerContext callCheckerContext, PsiElement psiElement, PsiElement psiElement2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: illegalCall");
        }
        if ((n & 4) != 0) {
            psiElement2 = null;
        }
        composableCallChecker.illegalCall(callCheckerContext, psiElement, psiElement2);
    }

    private final void illegalCallMustBeReadonly(CallCheckerContext context, PsiElement callEl) {
        context.getTrace().report((Diagnostic)ComposeErrors.NONREADONLY_CALL_IN_READONLY_COMPOSABLE.on(callEl));
    }

    private final void illegalComposableFunctionReference(CallCheckerContext context, KtCallableReferenceExpression refExpr) {
        context.getTrace().report((Diagnostic)ComposeErrors.COMPOSABLE_FUNCTION_REFERENCE.on((PsiElement)refExpr));
    }

    private final void illegalComposableDelegate(CallCheckerContext context, PsiElement reportOn) {
        context.getTrace().report((Diagnostic)ComposeErrors.COMPOSE_INVALID_DELEGATE.on(reportOn));
    }

    public void checkType(@NotNull KtExpression expression, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expressionType, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        BindingContext bindingContext = c.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"c.trace.bindingContext");
        BindingContext bindingContext2 = bindingContext;
        if (TypeUtilsKt.isNothing((KotlinType)expressionType)) {
            return;
        }
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"c.expectedType");
        KotlinType expectedType = kotlinType;
        if (expectedType == TypeUtils.NO_EXPECTED_TYPE) {
            return;
        }
        if (expectedType == TypeUtils.UNIT_EXPECTED_TYPE) {
            return;
        }
        if (TypeUtilsKt.isAnyOrNullableAny((KotlinType)expectedType)) {
            return;
        }
        boolean expectedComposable = ComposableCallCheckerKt.hasComposableExpectedType(c, expression);
        if (expression instanceof KtLambdaExpression) {
            SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)bindingContext2.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)((KtLambdaExpression)expression).getFunctionLiteral());
            if (simpleFunctionDescriptor == null) {
                return;
            }
            SimpleFunctionDescriptor descriptor = simpleFunctionDescriptor;
            boolean isComposable = ComposableCallCheckerKt.isComposableCallable((CallableDescriptor)descriptor, bindingContext2);
            if (expectedComposable != isComposable) {
                KtExpression ktExpression;
                boolean inferred;
                boolean isInlineable = InlineUtil.isInlinedArgument((KtFunction)((KtFunction)((KtLambdaExpression)expression).getFunctionLiteral()), (BindingContext)c.trace.getBindingContext(), (boolean)true);
                if (isInlineable) {
                    return;
                }
                if (!expectedComposable && isComposable && (inferred = Intrinsics.areEqual((Object)c.trace.getBindingContext().get((ReadOnlySlice)ComposeWritableSlices.INSTANCE.getINFERRED_COMPOSABLE_DESCRIPTOR(), (Object)descriptor), (Object)true))) {
                    return;
                }
                if (((KtLambdaExpression)expression).getParent() instanceof KtAnnotatedExpression) {
                    PsiElement psiElement = ((KtLambdaExpression)expression).getParent();
                    Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    ktExpression = (KtExpression)psiElement;
                } else {
                    ktExpression = expression;
                }
                KtExpression reportOn = ktExpression;
                c.trace.report((Diagnostic)ComposeErrors.TYPE_MISMATCH.on((PsiElement)reportOn, (Object)expectedType, (Object)expressionTypeWithSmartCast));
            }
            return;
        }
        SimpleType simpleType = TypeUtilsKt.getBuiltIns((KotlinType)expectedType).getNullableAnyType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"expectedType.builtIns.nullableAnyType");
        SimpleType nullableAnyType = simpleType;
        SimpleType simpleType2 = TypeUtilsKt.getBuiltIns((KotlinType)expectedType).getAnyType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"expectedType.builtIns.anyType");
        SimpleType anyType = simpleType2;
        if (Intrinsics.areEqual((Object)anyType, (Object)FlexibleTypesKt.lowerIfFlexible((KotlinType)expectedType)) && Intrinsics.areEqual((Object)nullableAnyType, (Object)FlexibleTypesKt.upperIfFlexible((KotlinType)expectedType))) {
            return;
        }
        SimpleType simpleType3 = TypeUtilsKt.getBuiltIns((KotlinType)expectedType).getNullableNothingType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"expectedType.builtIns.nullableNothingType");
        SimpleType nullableNothingType = simpleType3;
        if (expectedType.isMarkedNullable() && Intrinsics.areEqual((Object)expressionTypeWithSmartCast, (Object)nullableNothingType)) {
            return;
        }
        boolean isComposable = ComposeFqNamesKt.hasComposableAnnotation(expressionType);
        if (expectedComposable != isComposable) {
            KtExpression ktExpression;
            if (expression.getParent() instanceof KtAnnotatedExpression) {
                PsiElement psiElement = expression.getParent();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                ktExpression = (KtExpression)psiElement;
            } else {
                ktExpression = expression;
            }
            KtExpression reportOn = ktExpression;
            c.trace.report((Diagnostic)ComposeErrors.TYPE_MISMATCH.on((PsiElement)reportOn, (Object)expectedType, (Object)expressionTypeWithSmartCast));
        }
    }
}

