/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.packaging.jlink;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.CommandLineWrapperUtil;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.JpsBuildBundle;
import org.jetbrains.jps.builders.artifacts.ArtifactBuildTaskProvider;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.packaging.jlink.JpsJLinkArtifactType;
import org.jetbrains.jps.packaging.jlink.JpsJLinkProperties;

public final class JLinkArtifactBuildTaskProvider
extends ArtifactBuildTaskProvider {
    public static final String IMAGE_DIR_NAME = "jdk";

    @Override
    @NotNull
    public List<? extends BuildTask> createArtifactBuildTasks(@NotNull JpsArtifact artifact, @NotNull ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        if (buildPhase != ArtifactBuildTaskProvider.ArtifactBuildPhase.POST_PROCESSING || !(artifact.getArtifactType() instanceof JpsJLinkArtifactType)) {
            return Collections.emptyList();
        }
        JpsElement properties = artifact.getProperties();
        if (!(properties instanceof JpsJLinkProperties)) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new JLinkBuildTask(artifact));
    }

    private static class JLinkBuildTask
    extends BuildTask {
        private static final Logger LOG = Logger.getInstance(JLinkBuildTask.class);
        private final JpsArtifact myArtifact;

        private JLinkBuildTask(@NotNull JpsArtifact artifact) {
            this.myArtifact = artifact;
        }

        @Override
        public void build(@NotNull CompileContext context) throws ProjectBuildException {
            LOG.info("jlink task was started");
            JpsSdk<?> javaSdk = JLinkBuildTask.findValidSdk(context);
            if (javaSdk == null) {
                JLinkBuildTask.error(context, JpsBuildBundle.message("packaging.jlink.build.task.wrong.java.version", new Object[0]));
                return;
            }
            JpsJLinkProperties properties = (JpsJLinkProperties)this.myArtifact.getProperties();
            String artifactOutputPath = this.myArtifact.getOutputPath();
            if (artifactOutputPath == null) {
                JLinkBuildTask.error(context, JpsBuildBundle.message("packaging.jlink.build.task.unknown.artifact.path", new Object[0]));
                return;
            }
            Path runtimeImagePath = Paths.get(artifactOutputPath, JLinkArtifactBuildTaskProvider.IMAGE_DIR_NAME);
            List<String> commands = JLinkBuildTask.buildCommands(context, properties, javaSdk, artifactOutputPath, runtimeImagePath);
            if (commands.isEmpty()) {
                return;
            }
            try {
                FileUtil.delete((Path)runtimeImagePath);
            }
            catch (IOException e) {
                JLinkBuildTask.error(context, JpsBuildBundle.message("packaging.jlink.build.task.run.time.image.deletion.failure", new Object[0]));
                return;
            }
            int errorCode = JLinkBuildTask.startProcess(context, commands, properties);
            if (errorCode != 0) {
                JLinkBuildTask.error(context, JpsBuildBundle.message("packaging.jlink.build.task.failure", new Object[0]));
                return;
            }
            LOG.info("jlink task was finished");
        }

        @Nullable
        private static JpsSdk<?> findValidSdk(@NotNull CompileContext context) {
            Set<JpsSdk<?>> sdks = context.getProjectDescriptor().getProjectJavaSdks();
            JpsSdk<?> javaSdk = null;
            for (JpsSdk<?> sdk : sdks) {
                JpsSdkType sdkType = sdk.getSdkType();
                if (!(sdkType instanceof JpsJavaSdkType) || JpsJavaSdkType.getJavaVersion(sdk) < 9) continue;
                javaSdk = sdk;
                break;
            }
            return javaSdk;
        }

        @NotNull
        private static List<String> buildCommands(@NotNull CompileContext context, @NotNull JpsJLinkProperties properties, @NotNull JpsSdk<?> javaSdk, @NotNull String artifactOutputPath, @NotNull Path runtimeImagePath) {
            String modulesSequence = JLinkBuildTask.getModulesSequence(artifactOutputPath);
            if (StringUtil.isEmpty((String)modulesSequence)) {
                JLinkBuildTask.error(context, JpsBuildBundle.message("packaging.jlink.build.task.modules.not.found", new Object[0]));
                return Collections.emptyList();
            }
            String sdkHomePath = javaSdk.getHomePath();
            String jLinkPath = Paths.get(sdkHomePath, "bin", "jlink").toString();
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(jLinkPath);
            if (properties.compressionLevel != null && properties.compressionLevel.hasCompression()) {
                JLinkBuildTask.addOption(commands, "--compress", String.valueOf(properties.compressionLevel.myValue));
            }
            if (properties.verbose) {
                commands.add("--verbose");
            }
            commands.add("--module-path");
            commands.add(String.join((CharSequence)File.pathSeparator, artifactOutputPath, Paths.get(sdkHomePath, "jmods").toString()));
            commands.add("--add-modules");
            commands.add(modulesSequence);
            JLinkBuildTask.addOption(commands, "--output", runtimeImagePath.toString());
            LOG.info(String.join((CharSequence)" ", commands));
            return commands;
        }

        @Nullable
        private static String getModulesSequence(@NotNull String artifactOutputPath) {
            Method name;
            Method descriptor;
            Object allRefs;
            Method findAll;
            Object finder;
            Method of;
            try {
                of = Class.forName("java.lang.module.ModuleFinder").getMethod("of", Path[].class);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                LOG.error("Couldn't get java.lang.module.ModuleFinder#of method");
                return null;
            }
            try {
                finder = of.invoke(null, new Object[]{new Path[]{Paths.get(artifactOutputPath, new String[0])}});
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.error("Couldn't call java.lang.module.ModuleFinder#of method");
                return null;
            }
            try {
                findAll = Class.forName("java.lang.module.ModuleFinder").getMethod("findAll", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                LOG.error("Couldn't get java.lang.module.ModuleFinder#findAll method");
                return null;
            }
            try {
                allRefs = findAll.invoke(finder, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.error("Couldn't call java.lang.module.ModuleFinder#findAll method");
                return null;
            }
            Set moduleRefs = (Set)allRefs;
            if (moduleRefs.isEmpty()) {
                return null;
            }
            try {
                descriptor = Class.forName("java.lang.module.ModuleReference").getMethod("descriptor", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                LOG.error("Couldn't get java.lang.module.ModuleReference#descriptor method");
                return null;
            }
            try {
                name = Class.forName("java.lang.module.ModuleDescriptor").getMethod("name", new Class[0]);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                LOG.error("Couldn't get java.lang.module.ModuleDescriptor#name method");
                return null;
            }
            StringJoiner result = new StringJoiner(",");
            try {
                for (Object moduleRef : moduleRefs) {
                    String moduleName = (String)ObjectUtils.tryCast((Object)name.invoke(descriptor.invoke(moduleRef, new Object[0]), new Object[0]), String.class);
                    if (moduleName == null) {
                        return null;
                    }
                    result.add(moduleName);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.error("Couldn't call java.lang.module.ModuleReference#descriptor or name method");
                return null;
            }
            return result.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static int startProcess(final @NotNull CompileContext context, @NotNull List<String> commands, final @NotNull JpsJLinkProperties properties) {
            int n;
            block8: {
                File arg_file = null;
                try {
                    final AtomicInteger exitCode = new AtomicInteger();
                    final @NlsSafe StringBuilder errorOutput = new StringBuilder();
                    final ArrayList<@NlsSafe E> delayedInfoOutput = new ArrayList();
                    arg_file = FileUtil.createTempFile((String)"jlink_arg_file", null);
                    CommandLineWrapperUtil.writeArgumentsFile((File)arg_file, commands.subList(1, commands.size()), (Charset)StandardCharsets.UTF_8);
                    List<String> newCommands = Arrays.asList(commands.get(0), "@" + arg_file.getCanonicalPath());
                    Process process = new ProcessBuilder(CommandLineUtil.toCommandLine(newCommands)).start();
                    BaseOSProcessHandler handler = new BaseOSProcessHandler(process, newCommands.toString(), null);
                    handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            exitCode.set(event.getExitCode());
                        }

                        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                            String message = StringUtil.trimTrailing((String)event.getText());
                            if (outputType == ProcessOutputTypes.STDERR) {
                                errorOutput.append(event.getText());
                            } else if (properties.verbose) {
                                JLinkBuildTask.info(context, message);
                            } else {
                                delayedInfoOutput.add(message);
                            }
                        }
                    });
                    handler.startNotify();
                    handler.waitFor();
                    int result = exitCode.get();
                    if (result != 0) {
                        String message = errorOutput.toString();
                        if (!StringUtil.isEmptyOrSpaces((String)message)) {
                            JLinkBuildTask.error(context, message);
                        }
                        for (String info : delayedInfoOutput) {
                            JLinkBuildTask.error(context, info);
                        }
                    }
                    n = result;
                    if (arg_file == null) break block8;
                }
                catch (Throwable e) {
                    int n2;
                    block9: {
                        try {
                            JLinkBuildTask.error(context, e.getMessage());
                            LOG.error(e);
                            n2 = -1;
                            if (arg_file == null) break block9;
                        }
                        catch (Throwable throwable) {
                            if (arg_file != null) {
                                FileUtil.delete(arg_file);
                            }
                            throw throwable;
                        }
                        FileUtil.delete((File)arg_file);
                    }
                    return n2;
                }
                FileUtil.delete((File)arg_file);
            }
            return n;
        }

        private static void addOption(List<String> commands, @NotNull String key, @Nullable String value) {
            if (!StringUtil.isEmpty((String)value)) {
                commands.add(key);
                commands.add(value);
            }
        }

        private static void error(@NotNull CompileContext compileContext, @Nls String message) {
            compileContext.processMessage(new CompilerMessage("jlink", BuildMessage.Kind.ERROR, message));
        }

        private static void info(@NotNull CompileContext compileContext, @Nls String message) {
            compileContext.processMessage(new CompilerMessage("jlink", BuildMessage.Kind.INFO, message));
        }
    }
}

